/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.google.gson.Gson;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.lang.typescript.compiler.protocol.TypeScriptServiceProtocolBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceStandardOutputProtocol
extends TypeScriptServiceProtocolBase {
    private static final Gson GSON = new Gson();
    @Nullable
    private OutputStream myProcessInput;
    private final AtomicInteger mySeq = new AtomicInteger();
    protected final ConcurrentMap<Integer, JSLanguageServiceAnswerConsumer> myCallbacks = ContainerUtil.newConcurrentMap();

    public TypeScriptServiceStandardOutputProtocol(Project project, boolean withConfig) {
        super(project, withConfig);
    }

    @Override
    @Nullable
    public ProcessHandler connect() throws Exception {
        OSProcessHandler processHandler;
        GeneralCommandLine line = this.createCommandLine();
        if (line == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            line.withEnvironment("TSS_LOG", LOGGER.isTraceEnabled() ? "-level verbose" : "");
        }
        if ((processHandler = this.createProcessHandler(line)) == null) {
            return null;
        }
        LOGGER.debug("Language service was started. Start initialization of typescript plugin");
        this.myProcessInput = processHandler.getProcessInput();
        try {
            if (!this.waitingReadyNotification(processHandler, this::sendInitialState)) {
                processHandler.destroyProcess();
                return null;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text;
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)(text = event.getText())) && (text = StringUtil.trim((String)text)).startsWith("{") && text.endsWith("}")) {
                    JSLanguageServiceAnswer answer = new JSLanguageServiceAnswer(text);
                    Integer seq = answer.getSeq();
                    if (seq != null) {
                        JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)TypeScriptServiceStandardOutputProtocol.this.myCallbacks.remove(seq);
                        if (consumer != null) {
                            TypeScriptServiceProtocolBase.LOGGER.debug("Pass request " + seq + " to consumer");
                            consumer.consume(answer);
                        } else {
                            TypeScriptServiceProtocolBase.LOGGER.debug("No callback for seq: " + text);
                        }
                    } else {
                        TypeScriptServiceProtocolBase.LOGGER.debug("No sequence number, skip request: " + text);
                    }
                }
            }
        });
        return processHandler;
    }

    @Override
    public Integer sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull String jsonData, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "sendCommand"));
        }
        if (jsonData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonData", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "sendCommand"));
        }
        int value = this.mySeq.getAndIncrement();
        if (resultConsumer != null) {
            this.myCallbacks.put(value, resultConsumer);
        }
        String request = "{ \"sessionId\":" + this.mySessionId + ", \"seq\":" + value + ", \"arguments\":" + jsonData + ", \"type\":\"" + command.getType() + "\"" + ", \"command\":\"" + command.getCommand() + "\"}\n";
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Request: " + request);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Request command: " + command.getCommand());
        }
        this.write(request);
        return value;
    }

    @Override
    public void cancelCommand(Object cancellationToken) {
        if (cancellationToken == null) {
            return;
        }
        this.myCallbacks.remove(cancellationToken);
    }

    private void sendInitialState() {
        String state = this.createState();
        LOGGER.debug("Send state to service: " + state);
        this.write(state + "\n");
    }

    public String createState() {
        TypeScriptServiceInitialStateObject state = new TypeScriptServiceInitialStateObject();
        state.pluginName = "typescript";
        state.serverFolderPath = this.getServicePath();
        state.sessionId = String.valueOf(this.mySessionId);
        return GSON.toJson((Object)state);
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    @Override
    @NotNull
    protected String getEntryPointFile() {
        if ("js-language-service.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "getEntryPointFile"));
        }
        return "js-language-service.js";
    }

    public void dispose() {
    }

    private void write(@NotNull String data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol", "write"));
        }
        if (this.myProcessInput != null) {
            try {
                this.myProcessInput.write(data.getBytes(CharsetToolkit.UTF8_CHARSET));
                this.myProcessInput.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

