/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.protocol;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptServiceProtocolBase
implements JSLanguageServiceProtocol {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final int OBJECT_LENGTH = 0x3200000;
    protected static final String ANSWER_READY = "ready";
    protected static final String ANSWER_ERROR = "error";
    protected static final Set<Macro> PROJECT_LEVEL_MACRO = ContainerUtil.newHashSet((Object[])new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()});
    protected final long mySessionId = System.currentTimeMillis();
    protected final Project myProject;
    protected final boolean myWithConfig;
    @Nullable
    protected String myInitializeError;
    protected JSLanguageServiceAnswerConsumer myDefaultConsumer = new JSLanguageServiceAnswerConsumer(){

        @Override
        public void consume(JSLanguageServiceAnswer message) {
            if (message != null) {
                LOGGER.debug(message.toString());
            }
        }
    };

    public TypeScriptServiceProtocolBase(Project project, boolean withConfig) {
        this.myProject = project;
        this.myWithConfig = withConfig;
    }

    protected static void setSkipForTSConfig(GeneralCommandLine line) {
        line.addParameter("-skip=true");
    }

    private static String getOutPath(String path) {
        return "-outPathTemplate=" + path;
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    private VirtualFile getRootDir() {
        return this.myProject.getBaseDir();
    }

    protected void setManualOptions(TypeScriptCompilerSettings settings, GeneralCommandLine commandLine) throws Macro.ExecutionCancelledException {
        boolean hasMainFile;
        boolean bl = hasMainFile = settings.isUseMainFile() && !StringUtil.isEmpty((String)settings.getMainFilePath());
        if (hasMainFile) {
            String mainFilePath = FileUtil.toSystemDependentName((String)settings.getMainFilePath());
            commandLine.addParameter("-mainFilePath=" + mainFilePath);
        }
        String outFile = null;
        if (settings.isHasOutDirectory() && !StringUtil.isEmpty((String)settings.getOutDirectory())) {
            int indexOfSeparator;
            int indexOfDot;
            String outWithExpandedProjectMacro = FileUtil.toSystemIndependentName((String)settings.getOutDirectory());
            DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
            for (Macro macro : PROJECT_LEVEL_MACRO) {
                String macroName = "$" + macro.getName() + "$";
                if (!outWithExpandedProjectMacro.contains(macroName)) continue;
                String expand = macro.expand(context);
                if (expand == null) {
                    expand = "";
                }
                outWithExpandedProjectMacro = StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand);
            }
            commandLine.addParameter(this.getProjectPath());
            if (hasMainFile && (indexOfDot = outWithExpandedProjectMacro.lastIndexOf(46)) > 0 && indexOfDot > (indexOfSeparator = outWithExpandedProjectMacro.lastIndexOf(47))) {
                if (indexOfSeparator >= 0) {
                    outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                    outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
                } else {
                    outFile = outWithExpandedProjectMacro;
                    outWithExpandedProjectMacro = null;
                }
            }
            if (!StringUtil.isEmpty((String)outWithExpandedProjectMacro)) {
                commandLine.addParameter(TypeScriptServiceProtocolBase.getOutPath(FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro)));
            }
        }
        if (settings.isGenerateSourceMap()) {
            commandLine.addParameter("--sourceMap");
        }
        boolean existsCommandLineOutParam = false;
        if (null != settings.getTypeScriptCompilerParams()) {
            String[] parse;
            for (String s : parse = ParametersList.parse((String)settings.getTypeScriptCompilerParams())) {
                if (!"-out".equals(s)) continue;
                existsCommandLineOutParam = true;
                break;
            }
            commandLine.addParameters(parse);
        }
        if (!StringUtil.isEmpty(outFile) && !existsCommandLineOutParam) {
            commandLine.addParameter("-out");
            commandLine.addParameter(FileUtilRt.toSystemDependentName(outFile));
        }
    }

    protected String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    private String getProjectPath() {
        String path = this.getRootDir().getCanonicalPath();
        assert (path != null);
        return "-projectPath=" + FileUtil.toSystemDependentName((String)path);
    }

    @Nullable
    protected GeneralCommandLine createCommandLine() throws Macro.ExecutionCancelledException {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        String interpreter = settings.getNodeInterpreter();
        if (interpreter == null) {
            File file = NodeDetectionUtil.findInterpreterInPath();
            if (file == null) {
                return null;
            }
            interpreter = file.getAbsolutePath();
        }
        if (StringUtil.isEmpty((String)interpreter)) {
            throw new RuntimeException("Node interpreter path is empty. Please check the TypeScript settings");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreter});
        File file = new File(this.getEntryPointFolder(), this.getEntryPointFile());
        if (!file.exists()) {
            throw new RuntimeException("Cannot find resource bridge.js: " + file.getAbsolutePath());
        }
        commandLine.withWorkDirectory(this.myProject.getBasePath());
        commandLine.addParameter(file.getAbsolutePath());
        commandLine.addParameter(this.getSessionIdParam());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Commandline " + commandLine.toString());
        }
        return commandLine;
    }

    protected File getEntryPointFolder() {
        return TypeScriptUtil.getTypeScriptCompilerFolderFile();
    }

    @NotNull
    protected abstract String getEntryPointFile();

    protected boolean waitingReadyNotification(OSProcessHandler processHandler, Runnable action) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Ref result = new Ref((Object)false);
        ProcessAdapter listener = new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                    String prefix;
                    LOGGER.debug("Starting language service output: " + event.getText());
                    String text = event.getText().trim();
                    if (TypeScriptServiceProtocolBase.this.toSystemCommand(TypeScriptServiceProtocolBase.ANSWER_READY).equals(text)) {
                        result.set((Object)true);
                        countDownLatch.countDown();
                    }
                    if (text.startsWith(prefix = TypeScriptServiceProtocolBase.this.toSystemCommand(TypeScriptServiceProtocolBase.ANSWER_ERROR))) {
                        LOGGER.debug("Error initialization " + text.substring(prefix.length()));
                        TypeScriptServiceProtocolBase.this.myInitializeError = text.substring(prefix.length());
                        countDownLatch.countDown();
                    }
                } else if (outputType == ProcessOutputTypes.STDERR) {
                    LOGGER.debug("Starting language service output error: " + event.getText());
                }
            }

            public void processTerminated(ProcessEvent event) {
                countDownLatch.countDown();
            }
        };
        processHandler.addProcessListener((ProcessListener)listener);
        action.run();
        try {
            LOGGER.debug("Start waiting for ready start");
            countDownLatch.await(30L, TimeUnit.SECONDS);
            LOGGER.debug("End waiting for process starting. Result " + result.get());
        }
        catch (InterruptedException e) {
            LOGGER.debug("Process interrupted while waiting ready state");
        }
        processHandler.removeProcessListener((ProcessListener)listener);
        return (Boolean)result.get();
    }

    @Nullable
    protected OSProcessHandler createProcessHandler(GeneralCommandLine line) throws ExecutionException {
        if (line == null) {
            LOGGER.debug("Cannot create command line for typescript compiler");
            return null;
        }
        OSProcessHandler processHandler = new OSProcessHandler(line){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                final BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                BaseOutputReader.Options options2 = new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return options.policy();
                    }

                    public boolean splitToLines() {
                        return options.splitToLines();
                    }

                    public boolean sendIncompleteLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
                if (options2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase$3", "readerOptions"));
                }
                return options2;
            }
        };
        if (!this.waitingReadyNotification(processHandler, () -> ((OSProcessHandler)processHandler).startNotify())) {
            processHandler.destroyProcess();
            return null;
        }
        return processHandler;
    }

    protected String getServicePath() {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        return TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(settings.getTypeScriptServiceDirectoryOrDefault()) + '/';
    }

    @NotNull
    protected String toSystemCommand(String command) {
        String string = this.mySessionId + " " + command;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase", "toSystemCommand"));
        }
        return string;
    }
}

