/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerEditorNotificationProvider
extends EditorNotifications.Provider {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"TypeScriptCompilerEditorNotificationProvider");
    private static final ExtensionPointName EDITOR_NOTIFICATION_EP = ExtensionPointName.create((String)"com.intellij.editorNotificationProvider");
    public static final String TS_SHOW_COMPILER_NOTIFICATION = "typescript-compiler-editor-notification";
    protected final Project myProject;
    protected final EditorNotifications myNotifications;

    @NotNull
    public Key getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "getKey"));
        }
        return key;
    }

    public TypeScriptCompilerEditorNotificationProvider(Project project, EditorNotifications notifications) {
        this.myProject = project;
        this.myNotifications = notifications;
    }

    @Nullable
    public JComponent createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "createNotificationPanel"));
        }
        if (this.hasOverride() || !this.showCompilerNotification(file)) {
            return null;
        }
        return new CompilerEditorNotificationPanel(file);
    }

    protected boolean hasOverride() {
        for (Object extension : EDITOR_NOTIFICATION_EP.getExtensions((AreaInstance)this.myProject)) {
            if (!(extension instanceof NotificationOverride)) continue;
            return true;
        }
        return false;
    }

    protected boolean showCompilerNotification(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "showCompilerNotification"));
        }
        return TypeScriptCompilerEditorNotificationProvider.isTypeScriptFile(file) && !JsbtUtil.hasBuildTool(this.myProject) && this.isCompilerDisabled() && !TypeScriptUtil.isDefinitionFile(file) && !this.isSuppressedByDismissButton() && this.isProjectFile(file);
    }

    private boolean isSuppressedByDismissButton() {
        return !PropertiesComponent.getInstance((Project)this.myProject).getBoolean(TS_SHOW_COMPILER_NOTIFICATION, true);
    }

    private boolean isCompilerDisabled() {
        return !TypeScriptCompilerSettings.getSettings(this.myProject).isCompilerEnabled();
    }

    private static boolean isTypeScriptFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "isTypeScriptFile"));
        }
        return TypeScriptCompilerSettings.acceptFileType(file.getFileType());
    }

    private boolean isProjectFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "isProjectFile"));
        }
        return GlobalSearchScope.projectScope((Project)this.myProject).accept(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableCompilerForFile(VirtualFile file) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        boolean hasConfigs = false;
        try {
            Collection<TypeScriptConfig> configs = TypeScriptConfigService.Provider.getConfigInclude(this.myProject, file);
            if (configs.size() > 0) {
                hasConfigs = true;
            }
        }
        finally {
            token.finish();
        }
        settings.setUseConfigForCompiler(hasConfigs);
        settings.setImmediateCompileEnabled(true);
        ApplicationManager.getApplication().saveAll();
        TypeScriptCompilerService.getService(this.myProject).restartService();
        this.myNotifications.updateAllNotifications();
    }

    @NotNull
    protected Runnable getDismissAction() {
        Runnable runnable = () -> {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(TS_SHOW_COMPILER_NOTIFICATION, Boolean.FALSE.toString());
            this.myNotifications.updateAllNotifications();
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "getDismissAction"));
        }
        return runnable;
    }

    protected Color getColor(EditorNotificationPanel panel) {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
        return color != null ? color : panel.getBackground();
    }

    @NotNull
    protected Runnable getConfigureAction() {
        Runnable runnable = () -> {
            ShowSettingsUtilImpl.showSettingsDialog((Project)this.myProject, (String)"settings.typescriptcompiler", (String)"");
            this.myNotifications.updateAllNotifications();
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider", "getConfigureAction"));
        }
        return runnable;
    }

    protected class CompilerEditorNotificationPanel
    extends EditorNotificationPanel {
        public CompilerEditorNotificationPanel(VirtualFile file) {
            this.setText(JSBundle.message((String)"typescript.compiler.name.enable.message", (Object[])new Object[0]));
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.enable", (Object[])new Object[0]), () -> UIUtil.invokeLaterIfNeeded(() -> TypeScriptCompilerEditorNotificationProvider.this.enableCompilerForFile(file)));
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.no", (Object[])new Object[0]), TypeScriptCompilerEditorNotificationProvider.this.getDismissAction());
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.configure", (Object[])new Object[0]), TypeScriptCompilerEditorNotificationProvider.this.getConfigureAction());
        }

        public Color getBackground() {
            return TypeScriptCompilerEditorNotificationProvider.this.getColor(this);
        }
    }

    public static interface NotificationOverride {
    }
}

