/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddImportStatementFix
extends LocalQuickFixOnPsiElement
implements HintAction,
HighPriorityAction {
    private final String myName;

    public TypeScriptAddImportStatementFix(String name, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "<init>"));
        }
        super(context);
        this.myName = name;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TypeScriptAutoImportUtil.getActionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "isAvailable"));
        }
        PsiElement element = this.getStartElement();
        Collection<JSQualifiedNamedElement> candidates = this.getCandidates(element);
        return !candidates.isEmpty();
    }

    private static boolean checkReferenceExpressionAcceptable(JSReferenceExpression referenceExpression) {
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult result : results) {
            if (!result.isValidResult()) continue;
            hasValidResult = true;
            break;
        }
        return !hasValidResult;
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getCandidates(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        if (element instanceof JSReferenceExpression && !TypeScriptAddImportStatementFix.checkReferenceExpressionAcceptable((JSReferenceExpression)element)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        String name = this.getNameElement();
        if (name == null) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        Project project = element.getProject();
        TypeScriptAutoImportUtil.JSReferencePlaceInfo info = new TypeScriptAutoImportUtil.JSReferencePlaceInfo(element);
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)name, project, TypeScriptAutoImportUtil.createSymbolToImportSearchScope(element, project), JSElement.class, element1 -> {
            if (TypeScriptAutoImportUtil.isAvailableForImport(element1, info, project)) {
                result.add((JSQualifiedNamedElement)element1);
            }
            return true;
        });
        if (DialectDetector.isJSX(element)) {
            for (TypeScriptModule module : TypeScriptUtil.getAllRegularExternalModules(element.getProject(), element)) {
                String moduleName = module.getName();
                if (moduleName == null || !StringUtil.unquoteString((String)moduleName).equalsIgnoreCase(name)) continue;
                result.add(module);
                break;
            }
        }
        Collection<JSQualifiedNamedElement> collection = TypeScriptAddImportStatementFix.filterByContext(element, result);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "getCandidates"));
        }
        return collection;
    }

    private static Collection<JSQualifiedNamedElement> filterByContext(PsiElement context, Collection<JSQualifiedNamedElement> result) {
        if (result.isEmpty()) {
            return result;
        }
        if (context.getNode().getElementType() == JSTokenTypes.XML_TAG_NAME) {
            List exactComponents = ContainerUtil.emptyList();
            return result.stream().filter(el -> ReactXmlExtension.isPossibleReactComponent((PsiElement)el, exactComponents)).collect(Collectors.toList());
        }
        return result;
    }

    private String getNameElement() {
        return this.myName;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        new ImportAction(editor).execute();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "invoke"));
        }
        Collection<JSQualifiedNamedElement> candidates = this.getCandidates(startElement);
        if (candidates.size() == 1) {
            TypeScriptAutoImportUtil.addImportStatement(this.myName, candidates.iterator().next(), startElement);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix", "showHint"));
        }
        if (!JSApplicationSettings.getInstance().isShowTypeScriptAutoImport()) {
            return false;
        }
        PsiElement element = this.getStartElement();
        Collection<JSQualifiedNamedElement> candidates = this.getCandidates(element);
        if (candidates.isEmpty()) {
            return true;
        }
        JSQualifiedNamedElement first = (JSQualifiedNamedElement)ContainerUtil.getFirstItem(candidates);
        assert (first != null);
        String nameToShow = new JSQualifiedNamedElementRenderer<JSQualifiedNamedElement>().getElementText(first) + " " + JSQualifiedNamedElementRenderer.getContainerText(first);
        String message = ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)nameToShow);
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), (QuestionAction)new ImportAction(editor));
        return true;
    }

    private class ImportAction
    implements QuestionAction {
        private final Editor myEditor;

        public ImportAction(Editor editor) {
            this.myEditor = editor;
        }

        public boolean execute() {
            PsiElement element = TypeScriptAddImportStatementFix.this.getStartElement();
            return this.importReference(element);
        }

        private boolean importReference(final @NotNull PsiElement referenceElement) {
            if (referenceElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction", "importReference"));
            }
            Collection candidates = TypeScriptAddImportStatementFix.this.getCandidates(referenceElement);
            if (candidates.isEmpty()) {
                return true;
            }
            if (candidates.size() == 1) {
                JSQualifiedNamedElement candidate = (JSQualifiedNamedElement)candidates.iterator().next();
                TypeScriptAutoImportUtil.addImportStatement(TypeScriptAddImportStatementFix.this.myName, candidate, referenceElement);
            } else {
                NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])candidates.toArray(new JSQualifiedNamedElement[candidates.size()])), new JSQualifiedNamedElementRenderer(), (String)JSBundle.message((String)"choose.class.to.import.title", (Object[])new Object[0]), (PsiElementProcessor)new PsiElementProcessor<JSQualifiedNamedElement>(){

                    public boolean execute(@NotNull JSQualifiedNamedElement element) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction$1", "execute"));
                        }
                        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction$1", "lambda$execute$0"));
                            }
                            if (referenceElement == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceElement", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAction$1", "lambda$execute$0"));
                            }
                            TypeScriptAutoImportUtil.addImportStatement(TypeScriptAddImportStatementFix.this.myName, element, referenceElement);
                        }, this.getClass().getName(), (Object)this);
                        return false;
                    }
                }).showInBestPositionFor(this.myEditor);
            }
            return true;
        }
    }
}

