/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingReference;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptFileModuleReference;
import com.intellij.lang.typescript.modules.TypeScriptModuleFileReferenceSet;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptPathMappingReferenceContributor
implements JSModuleReferenceContributor {
    public static PsiReference[] getReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        TextRange range;
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getReferences"));
        }
        boolean isRelative = unquotedRefText.startsWith(".");
        if (isRelative) {
            return PsiReference.EMPTY_ARRAY;
        }
        final Project project = host.getProject();
        PsiFile containingFile = host.getContainingFile();
        TypeScriptConfig configForFile = TypeScriptConfigUtil.getConfigForPsiFile(containingFile);
        if (configForFile == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        final VirtualFile url = configForFile.getBaseUrl();
        if (url == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Collection<JSModulePathSubstitution> paths = configForFile.getPaths();
        if (paths.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        Pair<JSModulePathSubstitution, String> matchedElement = JSPathMappingsUtil.findMaxElementByPaths(unquotedRefText, paths);
        if (matchedElement == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
        String matchedStar = (String)matchedElement.getSecond();
        ArrayList refs = ContainerUtil.newArrayList();
        String pattern = matchedPattern.getPattern();
        final Collection<String> forFileReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true);
        Collection<String> forExactReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false);
        if (!forFileReference.isEmpty()) {
            refs.addAll(ContainerUtil.newArrayList((Object[])new FileReferenceSet(matchedStar, host, offset + pattern.length() - 1, provider, false, true, TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY){

                public FileReference createFileReference(TextRange range, int index, String text) {
                    return new TypeScriptFileModuleReference(text, index, range, this);
                }

                @NotNull
                public Collection<PsiFileSystemItem> computeDefaultContexts() {
                    ArrayList contexts = ContainerUtil.newArrayList();
                    for (String mapping : forFileReference) {
                        PsiDirectory directory;
                        String pathToFolder = JSPathMappingsUtil.getStringPathRelativeBaseUrl(url, JSPathMappingsUtil.getPatternOrMappingWithoutStar(mapping));
                        String systemIndependentName = FileUtil.toSystemIndependentName((String)pathToFolder);
                        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                        if (path == null || (directory = this.getElement().getManager().findDirectory(path)) == null) continue;
                        contexts.add(directory);
                    }
                    ArrayList arrayList = contexts;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor$1", "computeDefaultContexts"));
                    }
                    return arrayList;
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return new TypeScriptModuleFileReferenceSet.TypeScriptModuleFilesFilter(this.getContainingFile());
                }
            }.getAllReferences()));
            String patternWithoutStar = JSPathMappingsUtil.getPatternOrMappingWithoutStar(pattern);
            range = new TextRange(offset, offset + patternWithoutStar.length());
            refs.add(new JSPathMappingReference(host, range, matchedPattern, patternWithoutStar));
        }
        if (!forExactReference.isEmpty()) {
            ArrayList elements = ContainerUtil.newArrayList();
            range = TextRange.create((int)offset, (int)(offset + unquotedRefText.length()));
            for (String mapping : forExactReference) {
                String currentEl = matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
                elements.add(JSPathMappingsUtil.getStringPathRelativeBaseUrl(url, currentEl));
            }
            refs.add(new JSExactFileReference(host, range, elements, TypeScriptUtil.TYPESCRIPT_EXTENSIONS){

                @Override
                protected NodeModuleDirectorySearchProcessor createNodeProcessor() {
                    return new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project);
                }
            });
        }
        return refs.toArray(new PsiReference[0]);
    }

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getCommonJSModuleReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = TypeScriptPathMappingReferenceContributor.getReferences(unquotedRefText, host, offset, provider);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/typescript/modules/TypeScriptPathMappingReferenceContributor", "isApplicable"));
        }
        return DialectDetector.isTypeScript(host);
    }
}

