/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptConfigImpl
implements TypeScriptConfig {
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Map<String, String> myOptions;
    @NotNull
    private final VirtualFile myConfigDirectory;
    @NotNull
    private final Collection<VirtualFile> myIncludedFiles;
    @NotNull
    private final Collection<VirtualFile> myExcludeFiles;
    @NotNull
    private final TypeScriptConfig.LanguageTarget myLanguageTarget;
    @NotNull
    private final Collection<String> myRootDirs;
    @NotNull
    private final Collection<JSModulePathSubstitution> myPaths;
    @Nullable
    private final String myBaseUrl;
    private final boolean myCompileOnSave;
    @NotNull
    private final Project myProject;
    private final boolean myHasErrors;
    private final boolean myDirectoryBased;
    @NotNull
    private final Collection<String> myTypeRoots;
    @NotNull
    private final Collection<String> myTypes;
    private final NotNullLazyValue<Collection<VirtualFile>> myTypeRootFiles;
    private final NullableLazyValue<VirtualFile> myBaseUrlFile;
    private final NotNullLazyValue<Collection<PsiFileSystemItem>> myRootDirPsiElements;
    private final NotNullLazyValue<Collection<VirtualFile>> myAllIncludedFiles;

    @Nullable
    public static TypeScriptConfig getConfig(@NotNull PsiFile rawFile) {
        if (rawFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getConfig"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!(rawFile instanceof JsonFile)) {
            return null;
        }
        Project project = rawFile.getProject();
        JsonFile file = (JsonFile)rawFile;
        VirtualFile configVirtualFile = rawFile.getVirtualFile();
        VirtualFile configFile = file.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDirectory = configFile.getParent();
        if (configDirectory == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        boolean hasErrors = PsiTreeUtil.hasErrorElements((PsiElement)file);
        return jsonObject == null ? new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, hasErrors) : new TypeScriptConfigImpl(project, configVirtualFile, configDirectory, jsonObject, hasErrors);
    }

    @NotNull
    private static Collection<VirtualFile> getFiles(@Nullable JsonProperty filesProperty) {
        if (filesProperty == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
            }
            return list;
        }
        JsonValue value = filesProperty.getValue();
        if (value == null || !(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
            }
            return list;
        }
        HashSet files = ContainerUtil.newHashSet();
        JsonArray arrayWithFiles = (JsonArray)value;
        for (JsonValue jsonValue : arrayWithFiles.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            for (PsiReference reference : jsonValue.getReferences()) {
                PsiElement resolve;
                if (reference instanceof FileReference && !((FileReference)reference).isLast() || !((resolve = reference.resolve()) instanceof PsiFileSystemItem)) continue;
                files.add(((PsiFileSystemItem)resolve).getVirtualFile());
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getFiles"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<String, String> getCompilerOptions(@Nullable JsonValue value) {
        HashMap result = ContainerUtil.newHashMap();
        if (!(value instanceof JsonObject)) {
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getCompilerOptions"));
            }
            return hashMap;
        }
        JsonObject jsonObject = (JsonObject)value;
        for (JsonProperty property : jsonObject.getPropertyList()) {
            String optionName = property.getName();
            JsonValue optionValue = property.getValue();
            if (optionValue == null) continue;
            result.put(StringUtil.unquoteString((String)optionName), optionValue.getText());
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getCompilerOptions"));
        }
        return hashMap;
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, boolean hasErrors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDirectory", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        this.myTypeRootFiles = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                if (TypeScriptConfigImpl.this.myTypeRoots.isEmpty()) {
                    VirtualFile defaultTypesDirectory = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath("node_modules/@types", TypeScriptConfigImpl.this.getConfigDirectory());
                    if (defaultTypesDirectory == null) {
                        List list = ContainerUtil.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$1", "compute"));
                        }
                        return list;
                    }
                    List list = ContainerUtil.createMaybeSingletonList((Object)defaultTypesDirectory);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$1", "compute"));
                    }
                    return list;
                }
                ArrayList results = ContainerUtil.newArrayList();
                for (String root : TypeScriptConfigImpl.this.myTypeRoots) {
                    VirtualFile path;
                    if (StringUtil.isEmpty((String)root) || (path = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(root, TypeScriptConfigImpl.this.getConfigDirectory())) == null) continue;
                    results.add(path);
                }
                ArrayList arrayList = results;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$1", "compute"));
                }
                return arrayList;
            }
        };
        this.myBaseUrlFile = new NullableLazyValue<VirtualFile>(){

            protected VirtualFile compute() {
                if (TypeScriptConfigImpl.this.myBaseUrl == null) {
                    return null;
                }
                return JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(TypeScriptConfigImpl.this.myBaseUrl, TypeScriptConfigImpl.this.getConfigDirectory());
            }
        };
        this.myRootDirPsiElements = new NotNullLazyValue<Collection<PsiFileSystemItem>>(){

            @NotNull
            protected Collection<PsiFileSystemItem> compute() {
                if (TypeScriptConfigImpl.this.myRootDirs.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$3", "compute"));
                    }
                    return list;
                }
                List list = ContainerUtil.mapNotNull((Collection)TypeScriptConfigImpl.this.myRootDirs, filePath -> {
                    VirtualFile path = JSPathMappingsUtil.getRelativeOrAbsoluteFilePath(filePath, TypeScriptConfigImpl.this.getConfigDirectory());
                    if (path != null) {
                        return PsiManager.getInstance((Project)TypeScriptConfigImpl.this.myProject).findDirectory(path);
                    }
                    return null;
                });
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$3", "compute"));
                }
                return list;
            }
        };
        this.myAllIncludedFiles = new NotNullLazyValue<Collection<VirtualFile>>(){

            @NotNull
            protected Collection<VirtualFile> compute() {
                Collection dirs = (Collection)TypeScriptConfigImpl.this.myRootDirPsiElements.getValue();
                if (dirs.isEmpty()) {
                    Collection collection = TypeScriptConfigImpl.this.myIncludedFiles;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$4", "compute"));
                    }
                    return collection;
                }
                ArrayList result = ContainerUtil.newArrayList((Iterable)TypeScriptConfigImpl.this.myIncludedFiles);
                result.addAll(ContainerUtil.map((Collection)dirs, PsiFileSystemItem::getVirtualFile));
                ArrayList arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$4", "compute"));
                }
                return arrayList;
            }
        };
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myOptions = ContainerUtil.newHashMap();
        this.myIncludedFiles = ContainerUtil.emptyList();
        this.myExcludeFiles = ContainerUtil.emptyList();
        this.myLanguageTarget = DEFAULT_LANGUAGE_TARGET;
        this.myRootDirs = ContainerUtil.emptyList();
        this.myPaths = ContainerUtil.emptyList();
        this.myBaseUrl = null;
        this.myProject = project;
        this.myHasErrors = hasErrors;
        this.myDirectoryBased = true;
        this.myCompileOnSave = true;
        this.myTypeRoots = ContainerUtil.emptyList();
        this.myTypes = ContainerUtil.emptyList();
    }

    private TypeScriptConfigImpl(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull VirtualFile configDirectory, @NotNull JsonObject jsonObject, boolean hasErrors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (configDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDirectory", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonObject", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "<init>"));
        }
        this.myTypeRootFiles = new /* invalid duplicate definition of identical inner class */;
        this.myBaseUrlFile = new /* invalid duplicate definition of identical inner class */;
        this.myRootDirPsiElements = new /* invalid duplicate definition of identical inner class */;
        this.myAllIncludedFiles = new /* invalid duplicate definition of identical inner class */;
        JsonProperty filesProperty = jsonObject.findProperty("files");
        JsonProperty excludeProperty = jsonObject.findProperty("exclude");
        JsonProperty compilerOptionsProperty = jsonObject.findProperty("compilerOptions");
        JsonProperty compileOnSave = jsonObject.findProperty("compileOnSave");
        JsonValue compilerOptionsValue = compilerOptionsProperty == null ? null : compilerOptionsProperty.getValue();
        Map<String, String> options = TypeScriptConfigImpl.getCompilerOptions(compilerOptionsValue);
        this.myConfigFile = configFile;
        this.myConfigDirectory = configDirectory;
        this.myProject = project;
        this.myOptions = options;
        this.myIncludedFiles = TypeScriptConfigImpl.getFiles(filesProperty);
        this.myDirectoryBased = filesProperty == null;
        this.myExcludeFiles = TypeScriptConfigImpl.getFiles(excludeProperty);
        this.myRootDirs = TypeScriptConfigImpl.getRootDirs(compilerOptionsValue);
        this.myPaths = TypeScriptConfigImpl.getPaths(compilerOptionsValue);
        this.myBaseUrl = TypeScriptConfigImpl.getBaseUrl(compilerOptionsValue);
        this.myTypeRoots = TypeScriptConfigImpl.getTypeRoots(compilerOptionsValue);
        this.myTypes = TypeScriptConfigImpl.getTypes(compilerOptionsValue);
        this.myHasErrors = hasErrors;
        JsonValue compileOnSaveValue = compileOnSave == null ? null : compileOnSave.getValue();
        this.myCompileOnSave = compileOnSaveValue == null ? true : Boolean.valueOf(compileOnSaveValue.getText());
        String optionValue = this.myOptions.get("target");
        this.myLanguageTarget = StringUtil.isEmpty((String)optionValue) ? DEFAULT_LANGUAGE_TARGET : TypeScriptConfigImpl.parseTarget(optionValue);
    }

    @Override
    public boolean isIncludeFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isIncludeFile"));
        }
        Collection included = (Collection)this.myAllIncludedFiles.getValue();
        return TypeScriptConfigImpl.containsFile(file, included, this.myDirectoryBased ? this.myConfigDirectory : null) && !TypeScriptConfigImpl.containsFile(file, this.myExcludeFiles, null) || this.isIncludeTypesFile(file);
    }

    private static boolean containsFile(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> files, @Nullable VirtualFile defaultDirectory) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "containsFile"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "containsFile"));
        }
        if (files.size() > 0) {
            for (VirtualFile includedFile : files) {
                if ((!includedFile.isDirectory() || !VfsUtilCore.isAncestor((VirtualFile)includedFile, (VirtualFile)file, (boolean)true)) && (includedFile.isDirectory() || !includedFile.equals(file))) continue;
                return true;
            }
            return false;
        }
        return defaultDirectory != null && VfsUtilCore.isAncestor((VirtualFile)defaultDirectory, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    private static String getBaseUrl(@Nullable JsonValue compilerOptions) {
        return TypeScriptConfigImpl.getStringOption(compilerOptions, "baseUrl");
    }

    @Nullable
    private static String getStringOption(@Nullable JsonValue compilerOptions, String name) {
        if (!(compilerOptions instanceof JsonObject)) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty(name);
        if (property == null) {
            return null;
        }
        JsonValue value = property.getValue();
        return value instanceof JsonStringLiteral ? ((JsonStringLiteral)value).getValue() : null;
    }

    @NotNull
    private static Collection<String> getRootDirs(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "rootDirs");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getRootDirs"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getTypes(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "types");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypes"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getTypeRoots(@Nullable JsonValue compilerOptions) {
        Collection<String> collection = TypeScriptConfigImpl.getPropertyList(compilerOptions, "typeRoots");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypeRoots"));
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getPropertyList(@Nullable JsonValue compilerOptions, String name) {
        if (!(compilerOptions instanceof JsonObject)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPropertyList"));
            }
            return list;
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty(name);
        if (property == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPropertyList"));
            }
            return list;
        }
        JsonValue value = property.getValue();
        if (!(value instanceof JsonArray)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPropertyList"));
            }
            return list;
        }
        JsonArray jsonArray = (JsonArray)value;
        ArrayList resultList = ContainerUtil.newArrayList();
        for (JsonValue jsonValue : jsonArray.getValueList()) {
            if (!(jsonValue instanceof JsonStringLiteral)) continue;
            resultList.add(((JsonStringLiteral)jsonValue).getValue());
        }
        ArrayList arrayList = resultList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPropertyList"));
        }
        return arrayList;
    }

    private static Collection<JSModulePathSubstitution> getPaths(@Nullable JsonValue compilerOptions) {
        if (!(compilerOptions instanceof JsonObject)) {
            return ContainerUtil.emptyList();
        }
        JsonObject jsonObject = (JsonObject)compilerOptions;
        JsonProperty property = jsonObject.findProperty("paths");
        if (property == null) {
            return ContainerUtil.emptyList();
        }
        JsonValue propertyValue = property.getValue();
        if (!(propertyValue instanceof JsonObject)) {
            return ContainerUtil.emptyList();
        }
        JsonObject paths = (JsonObject)propertyValue;
        ArrayList result = ContainerUtil.newArrayList();
        for (JsonProperty jsonProperty : paths.getPropertyList()) {
            final String name = jsonProperty.getName();
            JsonValue value = jsonProperty.getValue();
            final ArrayList substitutions = ContainerUtil.newArrayList();
            if (value instanceof JsonStringLiteral) {
                substitutions.add(((JsonStringLiteral)value).getValue());
            } else if (value instanceof JsonArray) {
                for (JsonValue jsonValue : ((JsonArray)value).getValueList()) {
                    if (!(jsonValue instanceof JsonStringLiteral)) continue;
                    substitutions.add(((JsonStringLiteral)jsonValue).getValue());
                }
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)compilerOptions.getProject());
            final SmartPsiElementPointer pointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsonProperty);
            result.add(new JSModulePathSubstitution(){

                @Override
                @NotNull
                public Collection<String> getMappings() {
                    Collection collection = substitutions;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$5", "getMappings"));
                    }
                    return collection;
                }

                @Override
                @NotNull
                public String getPattern() {
                    String string = name;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl$5", "getPattern"));
                    }
                    return string;
                }

                @Override
                public boolean canStartWith() {
                    return false;
                }

                @Override
                public PsiElement getElement() {
                    return pointer.getElement();
                }
            });
        }
        return result;
    }

    @Override
    public boolean isDirectoryBased() {
        return this.myDirectoryBased;
    }

    @Override
    @NotNull
    public VirtualFile getConfigFile() {
        VirtualFile virtualFile = this.myConfigFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getConfigFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDirectory;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getConfigDirectory"));
        }
        return virtualFile;
    }

    @Override
    public boolean hasErrors() {
        return this.myHasErrors;
    }

    @Override
    @NotNull
    public Collection<JSModulePathSubstitution> getPaths() {
        Collection<JSModulePathSubstitution> collection = this.myPaths;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getPaths"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRootDirs() {
        Collection collection = (Collection)this.myRootDirPsiElements.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getRootDirs"));
        }
        return collection;
    }

    @Override
    @NotNull
    public TypeScriptConfig.LanguageTarget getLanguageTarget() {
        TypeScriptConfig.LanguageTarget languageTarget = this.myLanguageTarget;
        if (languageTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getLanguageTarget"));
        }
        return languageTarget;
    }

    @Override
    @Nullable
    public VirtualFile getBaseUrl() {
        return (VirtualFile)this.myBaseUrlFile.getValue();
    }

    @Override
    @Nullable
    public String getOutDirectory() {
        VirtualFile baseDirectory = this.getConfigDirectory();
        String quotedString = this.myOptions.get("outDir");
        if (quotedString == null) {
            return null;
        }
        String directoryPath = StringUtil.unquoteString((String)quotedString);
        return TypeScriptConfigUtil.getOutDirectory(baseDirectory, directoryPath);
    }

    public String toString() {
        return "TypeScriptConfigImpl{myConfigFile=" + this.myConfigFile + ", myOptions=" + this.myOptions + ", myConfigDirectory=" + this.myConfigDirectory + ", myIncludedFiles=" + this.myIncludedFiles + '}';
    }

    public static TypeScriptConfig.LanguageTarget parseTarget(String value) {
        String lowerCaseValue = StringUtil.unquoteString((String)StringUtil.toLowerCase((String)value.trim()));
        if ("es3".equals(lowerCaseValue)) {
            return TypeScriptConfig.LanguageTarget.ES3;
        }
        if ("es6".equals(lowerCaseValue) || "es2015".equals(lowerCaseValue) || "es2016".equals(lowerCaseValue) || "es7".equals(lowerCaseValue) || "latest".equals(lowerCaseValue)) {
            return TypeScriptConfig.LanguageTarget.ES6;
        }
        return DEFAULT_LANGUAGE_TARGET;
    }

    @Override
    public boolean isCompileOnSave() {
        return this.myCompileOnSave;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getTypeRoots() {
        Collection collection = (Collection)this.myTypeRootFiles.getValue();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypeRoots"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getTypes() {
        Collection<String> collection = this.myTypes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "getTypes"));
        }
        return collection;
    }

    @Override
    public boolean isIncludeTypesFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigImpl", "isIncludeTypesFile"));
        }
        Collection<String> types = this.getTypes();
        boolean isEmptyTypes = types.isEmpty();
        for (VirtualFile virtualFile : this.getTypeRoots()) {
            if (isEmptyTypes) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)true)) continue;
                return true;
            }
            for (VirtualFile child : virtualFile.getChildren()) {
                if (!child.isDirectory()) continue;
                for (String type : types) {
                    if (!type.equals(child.getName()) || !VfsUtilCore.isAncestor((VirtualFile)child, (VirtualFile)file, (boolean)true)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

