/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigServiceImpl
implements TypeScriptConfigService {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptConfigService.class);
    private static final Function<PsiFile, TypeScriptConfig> MAP_TO_CONFIG = file -> {
        if (JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile())) {
            return null;
        }
        return TypeScriptConfigImpl.getConfig(file);
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<Collection<TypeScriptConfig>> myConfigs;
    private final CachedValue<ConcurrentMap<VirtualFile, Map<VirtualFile, Boolean>>> myFilesMappings;
    private final CachedValue<ConcurrentMap<VirtualFile, Collection<TypeScriptConfig>>> myFileConfigsInclude;
    private final SimpleModificationTracker myTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;

    public TypeScriptConfigServiceImpl(@NotNull Project project, @Nullable TypeScriptConfigLibraryUpdater updater) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "<init>"));
        }
        this.myTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myUpdater = updater;
        CachedValueProvider configsProvider = () -> {
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            this.update();
            try {
                Object[] files = FilenameIndex.getFilesByName((Project)this.myProject, (String)"tsconfig.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
                List configs = ContainerUtil.mapNotNull((Object[])files, MAP_TO_CONFIG);
                ArrayList depends = ContainerUtil.newArrayList((Object[])files);
                depends.add(JSProjectUtil.FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER);
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)configs, (Collection)depends);
                return result;
            }
            finally {
                token.finish();
            }
        };
        this.myConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(configsProvider, false);
        this.myFilesMappings = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
        this.myFileConfigsInclude = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    private void update() {
        this.myTracker.incModificationCount();
        if (this.myUpdater != null) {
            this.myUpdater.queueToUpdate();
        }
    }

    public boolean isEnabled() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null) {
            return false;
        }
        return settings.isEnabledConfig();
    }

    public boolean isCheckReferencePaths() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null) {
            return false;
        }
        return settings.isCheckReferencePaths();
    }

    @Override
    public boolean isAccessible(VirtualFile scope, VirtualFile referenced) {
        Boolean value;
        Map prevValue;
        if (scope.equals(referenced)) {
            return true;
        }
        if (!this.isEnabled()) {
            return true;
        }
        ConcurrentMap filesRefsMap = (ConcurrentMap)this.myFilesMappings.getValue();
        Map scopeFileMap = (Map)filesRefsMap.get(scope);
        if (scopeFileMap == null && (prevValue = filesRefsMap.putIfAbsent(scope, scopeFileMap = ContainerUtil.newConcurrentMap())) != null) {
            scopeFileMap = prevValue;
        }
        if ((value = (Boolean)scopeFileMap.get(referenced)) == null) {
            value = this.isAccessibleImpl(scope, referenced);
            scopeFileMap.put(referenced, value);
        }
        return value;
    }

    private boolean isAccessibleImpl(@NotNull VirtualFile scope, @NotNull VirtualFile file) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isAccessibleImpl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isAccessibleImpl"));
        }
        String fileName = file.getName();
        boolean isStandardLib = JavaScriptIndex.LIBS_D_TS.contains(fileName);
        if (isStandardLib && (JSCorePredefinedLibrariesProvider.getTypeScriptPredefinedLibraryFiles().contains(file) || JSCorePredefinedLibrariesProvider.getTypeScriptES6PredefinedLibraryFiles().contains(file))) {
            return true;
        }
        Collection<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            return true;
        }
        boolean firstInclude = false;
        boolean bothIncludes = false;
        Collection<TypeScriptConfig> includesFirst = this.getConfigInclude(scope);
        for (TypeScriptConfig config : includesFirst) {
            firstInclude = true;
            if (!config.isIncludeFile(file)) continue;
            bothIncludes = true;
            break;
        }
        if (bothIncludes) {
            return true;
        }
        if (TypeScriptUtil.isUnderNodeModules(file, this.myProject)) {
            if (!isStandardLib && !JavaScriptIndex.CORE_LIBS_D_TS.contains(fileName) && TypeScriptUtil.isDefinitionFile(fileName)) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (psiFile instanceof JSFile && ((JSFile)psiFile).isCommonJSModule()) {
                    return true;
                }
                if (!firstInclude && !TypeScriptUtil.isUnderNodeModules(scope, this.myProject)) {
                    return true;
                }
            }
        } else if (!firstInclude) {
            return true;
        }
        return this.checkReferencePaths(file, includesFirst);
    }

    private boolean checkReferencePaths(@NotNull VirtualFile startFile, @Nullable Collection<TypeScriptConfig> configs) {
        if (startFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkReferencePaths"));
        }
        if (!this.isCheckReferencePaths() || !startFile.isValid() || DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        if (configs == null) {
            return false;
        }
        HashSet visited = ContainerUtil.newHashSet();
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>();
        toCheck.add(startFile);
        visited.add(startFile);
        while (!toCheck.isEmpty()) {
            ProgressIndicatorProvider.checkCanceled();
            VirtualFile fileToCheck = (VirtualFile)toCheck.pop();
            VirtualFile[] files = FileIncludeManager.getManager((Project)this.myProject).getIncludingFiles(fileToCheck, false);
            if (files == null || files.length == 0) continue;
            if (TypeScriptConfigServiceImpl.checkPlainIncludeFiles(configs, files)) {
                return true;
            }
            for (VirtualFile file : files) {
                if (!visited.add(file)) continue;
                toCheck.add(file);
            }
        }
        return false;
    }

    private static boolean checkPlainIncludeFiles(@NotNull Collection<TypeScriptConfig> configs, VirtualFile[] files) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkPlainIncludeFiles"));
        }
        for (VirtualFile virtualFile : files) {
            for (TypeScriptConfig config : configs) {
                if (!config.isIncludeFile(virtualFile)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<TypeScriptConfig> getConfigIncludeImpl(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigIncludeImpl"));
        }
        Collection<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (TypeScriptConfig config : files) {
            if (!this.isConfigInclude(scopeFile, config)) continue;
            result.add(config);
        }
        return result;
    }

    @Override
    @NotNull
    public Collection<TypeScriptConfig> getConfigInclude(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
        }
        ConcurrentMap fileConfigsIncludeCache = (ConcurrentMap)this.myFileConfigsInclude.getValue();
        if (fileConfigsIncludeCache.containsKey(scopeFile)) {
            Collection collection = (Collection)fileConfigsIncludeCache.get(scopeFile);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
            }
            return collection;
        }
        Collection<TypeScriptConfig> includedConfigs = this.getConfigIncludeImpl(scopeFile);
        fileConfigsIncludeCache.put(scopeFile, includedConfigs);
        Collection<TypeScriptConfig> collection = includedConfigs;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
        }
        return collection;
    }

    @Override
    public boolean isConfigInclude(@NotNull VirtualFile scopeFile, @NotNull TypeScriptConfig config) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isConfigInclude"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isConfigInclude"));
        }
        return config.isIncludeFile(scopeFile) || this.checkReferencePaths(scopeFile, ContainerUtil.createMaybeSingletonList((Object)config));
    }

    @Override
    public ModificationTracker getTracker() {
        return this.myTracker;
    }

    @Override
    @NotNull
    public Collection<TypeScriptConfig> getConfigFiles() {
        Collection value = (Collection)this.myConfigs.getValue();
        Collection collection = value == null ? ContainerUtil.emptyList() : value;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigFiles"));
        }
        return collection;
    }
}

