/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigUtil {
    private static final Key<ParameterizedCachedValue<TypeScriptConfig, PsiFile>> CACHE_KEY = Key.create((String)"TypeScript.PsiFile.To.Config");
    private static final ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile> CACHED_CONFIG_PROVIDER = new ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<TypeScriptConfig> compute(PsiFile param) {
            VirtualFile file = param.getOriginalFile().getVirtualFile();
            Project project = param.getProject();
            TypeScriptConfig config = file == null ? null : TypeScriptConfigUtil.getConfigForFile(project, file);
            return CachedValueProvider.Result.create((Object)config, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };

    @Nullable
    private static JsonProperty getFilesProperty(Project project, TypeScriptConfig config) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config.getConfigFile());
        return TypeScriptConfigUtil.getFilesProperty(file);
    }

    @Nullable
    private static JsonProperty getFilesProperty(PsiFile file) {
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.findProperty("files");
    }

    public static boolean addVirtualFileToConfigFiles(Project project, VirtualFile file, TypeScriptConfig config) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (!config.isDirectoryBased());
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(project, config);
        if (property == null) {
            return false;
        }
        JsonArray value = (JsonArray)property.getValue();
        if (value == null) {
            return false;
        }
        List list = value.getValueList();
        if (list.isEmpty()) {
            return false;
        }
        String text = value.getText();
        StringBuilder builder = new StringBuilder(text);
        String path = VfsUtil.getPath((VirtualFile)config.getConfigFile(), (VirtualFile)file, (char)(text.indexOf("/") > 0 ? (char)'/' : (char)File.separatorChar));
        int i = text.lastIndexOf("]");
        builder.insert(i, ",\"" + path + "\"");
        value.replace((PsiElement)TypeScriptConfigUtil.createJSONAndGetPropertyValue(project, builder.toString()));
        return true;
    }

    private static JsonValue createJSONAndGetPropertyValue(Project project, String propertyValue) {
        String json = String.format("{ \"files\":%s }", propertyValue);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)json);
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(psiFile);
        assert (property != null);
        return property.getValue();
    }

    public static String getOutDirectory(VirtualFile baseFile, String relativeOrAbsolutePath) {
        if (StringUtil.isEmpty((String)relativeOrAbsolutePath)) {
            return null;
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsolutePath)) {
            return relativeOrAbsolutePath;
        }
        VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseFile, (String[])ArrayUtil.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)relativeOrAbsolutePath))));
        return file == null ? null : file.getCanonicalPath();
    }

    public static TypeScriptConfig getConfigForPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getConfigForPsiFile"));
        }
        return (TypeScriptConfig)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, CACHE_KEY, CACHED_CONFIG_PROVIDER, false, (Object)file);
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getConfigForFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<TypeScriptConfig> filteredConfigs = TypeScriptConfigService.Provider.getConfigInclude(project, file);
        if (filteredConfigs.isEmpty()) {
            return null;
        }
        assert (project != null);
        if (1 == filteredConfigs.size() || filteredConfigs.isEmpty()) {
            return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
        }
        Map configToDirectory = ContainerUtil.newMapFromKeys(filteredConfigs.iterator(), (Convertor)new Convertor<TypeScriptConfig, VirtualFile>(){

            public VirtualFile convert(TypeScriptConfig o) {
                return o.getConfigFile().getParent();
            }
        });
        for (VirtualFile toSearch = file.getParent(); toSearch != null; toSearch = toSearch.getParent()) {
            for (Map.Entry entry : configToDirectory.entrySet()) {
                VirtualFile configDirectory = (VirtualFile)entry.getValue();
                if (!configDirectory.equals(toSearch)) continue;
                return (TypeScriptConfig)entry.getKey();
            }
        }
        return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
    }
}

