/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import com.sixrr.inspectjs.utils.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public class TrivialConditionalJSInspection
extends JavaScriptInspection {
    private final TrivialConditionalFix fix = new TrivialConditionalFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("redundant.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialConditionalJSInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialConditionalJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSConditionalExpression exp = (JSConditionalExpression)args[0];
        return InspectionJSBundle.message("trivial.conditional.error.string", exp.getText(), TrivialConditionalJSInspection.calculateReplacementExpression(exp));
    }

    private static String calculateReplacementExpression(JSConditionalExpression exp) {
        JSExpression thenExpression = exp.getThen();
        JSExpression elseExpression = exp.getElse();
        JSExpression condition = exp.getCondition();
        if (TrivialConditionalJSInspection.isFalse(thenExpression) && TrivialConditionalJSInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return ConditionalUtils.castToBoolean(condition);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static boolean isFalse(JSExpression expression) {
        String text = expression.getText();
        return "false".equals(text);
    }

    private static boolean isTrue(JSExpression expression) {
        String text = expression.getText();
        return "true".equals(text);
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        public void visitJSConditionalExpression(JSConditionalExpression exp) {
            super.visitJSConditionalExpression(exp);
            JSExpression thenExpression = exp.getThen();
            if (thenExpression == null) {
                return;
            }
            JSExpression elseExpression = exp.getElse();
            if (elseExpression == null) {
                return;
            }
            if ((TrivialConditionalJSInspection.isFalse(thenExpression) && TrivialConditionalJSInspection.isTrue(elseExpression) || TrivialConditionalJSInspection.isTrue(thenExpression) && TrivialConditionalJSInspection.isFalse(elseExpression)) && "Boolean".equals(JSResolveUtil.getExpressionType(exp.getCondition(), exp.getContainingFile()))) {
                this.registerError((PsiElement)exp);
            }
        }
    }

    private static class TrivialConditionalFix
    extends InspectionJSFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialConditionalJSInspection$TrivialConditionalFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor.getPsiElement();
            String newExpression = TrivialConditionalJSInspection.calculateReplacementExpression(expression);
            TrivialConditionalFix.replaceExpression((JSExpression)expression, newExpression);
        }
    }
}

