/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.j2ee.web.WebUtilImpl;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.struts.facet.StrutsFacet;
import com.intellij.struts.facet.StrutsFacetConfiguration;
import com.intellij.struts.facet.ui.MultipleStrutsFacetEditor;
import com.intellij.struts.facet.ui.StrutsFacetDefaultSettingsEditor;
import com.intellij.util.indexing.FileContent;
import icons.StrutsApiIcons;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsFacetType
extends FacetType<StrutsFacet, StrutsFacetConfiguration> {
    public static final FacetTypeId<StrutsFacet> ID = new FacetTypeId("struts");

    StrutsFacetType() {
        super(ID, "struts", "Struts", WebFacet.ID);
    }

    public static StrutsFacetType getInstance() {
        return (StrutsFacetType)StrutsFacetType.findInstance(StrutsFacetType.class);
    }

    public StrutsFacetConfiguration createDefaultConfiguration() {
        return new StrutsFacetConfiguration();
    }

    public StrutsFacet createFacet(@NotNull Module module, String name, @NotNull StrutsFacetConfiguration configuration, @Nullable Facet underlyingFacet) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/facet/StrutsFacetType", "createFacet"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/struts/facet/StrutsFacetType", "createFacet"));
        }
        return new StrutsFacet(this, module, name, configuration, underlyingFacet);
    }

    public Icon getIcon() {
        return StrutsApiIcons.ActionMapping;
    }

    public String getHelpTopic() {
        return "reference.settings.project.structure.facets.struts.facet";
    }

    public boolean isSuitableModuleType(ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    public DefaultFacetSettingsEditor createDefaultConfigurationEditor(@NotNull Project project, @NotNull StrutsFacetConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts/facet/StrutsFacetType", "createDefaultConfigurationEditor"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/struts/facet/StrutsFacetType", "createDefaultConfigurationEditor"));
        }
        return new StrutsFacetDefaultSettingsEditor(configuration.getValidationConfiguration());
    }

    public MultipleFacetSettingsEditor createMultipleConfigurationsEditor(@NotNull Project project, @NotNull FacetEditor[] editors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/struts/facet/StrutsFacetType", "createMultipleConfigurationsEditor"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/struts/facet/StrutsFacetType", "createMultipleConfigurationsEditor"));
        }
        return new MultipleStrutsFacetEditor(editors);
    }

    public static class StrutsFrameworkDetector
    extends FacetBasedFrameworkDetector<StrutsFacet, StrutsFacetConfiguration> {
        public StrutsFrameworkDetector() {
            super("struts");
        }

        public FacetType<StrutsFacet, StrutsFacetConfiguration> getFacetType() {
            return StrutsFacetType.getInstance();
        }

        @NotNull
        public FileType getFileType() {
            LanguageFileType languageFileType = StdFileTypes.XML;
            if (languageFileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/facet/StrutsFacetType$StrutsFrameworkDetector", "getFileType"));
            }
            return languageFileType;
        }

        @NotNull
        public ElementPattern<FileContent> createSuitableFilePattern() {
            FileContentPattern fileContentPattern = FileContentPattern.fileContent().withName("struts-config.xml").xmlWithRootTag("struts-config");
            if (fileContentPattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/facet/StrutsFacetType$StrutsFrameworkDetector", "createSuitableFilePattern"));
            }
            return fileContentPattern;
        }

        public boolean isSuitableUnderlyingFacetConfiguration(FacetConfiguration underlying, StrutsFacetConfiguration configuration, Set<VirtualFile> files) {
            return WebUtilImpl.isWebFacetConfigurationContainingFiles((FacetConfiguration)underlying, files);
        }
    }
}

