/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.highlighting.syntax;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import com.intellij.struts.dom.tiles.Add;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts.dom.tiles.Put;
import com.intellij.struts.dom.tiles.TilesDefinitions;
import com.intellij.struts.highlighting.syntax.DomAnnotatorComponentBase;
import com.intellij.struts.highlighting.syntax.DomAnnotatorVisitor;

public class TilesSyntaxAnnotator
extends DomAnnotatorComponentBase<TilesDefinitions> {
    public TilesSyntaxAnnotator() {
        super(TilesDefinitions.class);
    }

    @Override
    protected DomAnnotatorVisitor buildVisitor(final AnnotationHolder holder) {
        return new DomAnnotatorVisitor(holder){

            public void visitAdd(Add add) {
                this.checkDeprecatedAttribute(add.getContent(), add.getAttributeValue(), null);
                this.checkDeprecatedAttribute(add.getDirect(), add.getType(), "string");
                this.checkMutuallyExclusiveAttributes(add.getContent(), add.getAttributeValue());
            }

            public void visitDefinition(Definition definition) {
                this.checkDeprecatedAttribute(definition.getPath(), definition.getTemplate(), null);
                this.checkMutuallyExclusiveAttributes(definition.getControllerClass(), definition.getControllerUrl());
                this.checkMutuallyExclusiveAttributes(definition.getPage(), definition.getPath());
                Definition extendingDefinition = (Definition)definition.getExtends().getValue();
                if (extendingDefinition != null && extendingDefinition.ensureTagExists() == definition.getXmlTag()) {
                    holder.createErrorAnnotation((PsiElement)definition.ensureTagExists(), "Definition cannot extend itself");
                }
            }

            public void visitPut(Put put) {
                this.checkDeprecatedAttribute(put.getContent(), put.getAttributeValue(), null);
                this.checkDeprecatedAttribute(put.getDirect(), put.getType(), "string");
                this.checkMutuallyExclusiveAttributes(put.getContent(), put.getAttributeValue());
            }
        };
    }
}

