/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ReferenceProviderUtils {
    public static final ElementFilter TAG_CLASS_FILTER = XmlTagFilter.INSTANCE;

    public static void registerAttributes(PsiReferenceRegistrar psiReferenceRegistrar, PsiReferenceProvider provider, @NonNls String tagName, NamespaceFilter namespaceFilter, String ... attributeNames) {
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)psiReferenceRegistrar, (String[])attributeNames, (ElementFilter)ReferenceProviderUtils.andTagNames((ElementFilter)namespaceFilter, tagName), (PsiReferenceProvider)provider);
    }

    public static void registerTags(PsiReferenceRegistrar psiReferenceRegistrar, PsiReferenceProvider provider, @NonNls String attributeName, NamespaceFilter namespaceFilter, String ... tagNames) {
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)psiReferenceRegistrar, (String[])new String[]{attributeName}, (ElementFilter)ReferenceProviderUtils.andTagNames((ElementFilter)namespaceFilter, tagNames), (PsiReferenceProvider)provider);
    }

    public static void registerSubclass(PsiReferenceRegistrar psiReferenceRegistrar, NamespaceFilter namespaceFilter, @NonNls String tagName, @NonNls String attributeName) {
        ReferenceProviderUtils.registerTags(psiReferenceRegistrar, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/reference/ReferenceProviderUtils$1", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/struts/inplace/reference/ReferenceProviderUtils$1", "getReferencesByElement"));
                }
                JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
                PsiReference[] psiReferenceArray = provider.getReferencesByElement(psiElement, processingContext);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/ReferenceProviderUtils$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, attributeName, namespaceFilter, tagName);
    }

    public static void registerSubclass(PsiReferenceRegistrar psiReferenceRegistrar, NamespaceFilter namespaceFilter, @NonNls String tagName, @NonNls String attributeName, final String ... classes) {
        ReferenceProviderUtils.registerTags(psiReferenceRegistrar, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/reference/ReferenceProviderUtils$2", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/struts/inplace/reference/ReferenceProviderUtils$2", "getReferencesByElement"));
                }
                JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
                provider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, (Object)classes);
                provider.setOption(JavaClassReferenceProvider.INSTANTIATABLE, (Object)Boolean.TRUE);
                PsiReference[] psiReferenceArray = provider.getReferencesByElement(psiElement, processingContext);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/ReferenceProviderUtils$2", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, attributeName, namespaceFilter, tagName);
    }

    private static ScopeFilter andTagNames(ElementFilter namespace, String ... tagNames) {
        return new ScopeFilter((ElementFilter)new ParentElementFilter((ElementFilter)new AndFilter(new ElementFilter[]{namespace, TAG_CLASS_FILTER, new TextFilter(tagNames)}), 2));
    }
}

