/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPsiTreeChangeProcessor
extends PsiTreeChangePreprocessorBase {
    public static final SimpleModificationTracker CSS_MODIFICATION_TRACKER = new SimpleModificationTracker();

    public CssPsiTreeChangeProcessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "<init>"));
        }
        super(project);
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/css/CssPsiTreeChangeProcessor", "treeChanged"));
        }
        if (event.getFile() instanceof StylesheetFile || CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)event.getFile())) {
            if (event.getParent() instanceof PsiFileSystemItem) {
                CSS_MODIFICATION_TRACKER.incModificationCount();
            } else {
                PsiElement child = event.getChild();
                if (child != null && !(child instanceof SyntheticElement) && CssPsiUtil.getStylesheetLanguage((PsiElement)child) != null) {
                    CSS_MODIFICATION_TRACKER.incModificationCount();
                }
            }
            super.treeChanged(event);
        }
    }

    public boolean isInsideCodeBlock(@Nullable PsiElement element) {
        boolean inSelector;
        if (element instanceof PsiFileSystemItem) {
            return false;
        }
        if (CssPsiUtil.getStylesheetLanguage((PsiElement)element) == null) {
            return true;
        }
        boolean bl = inSelector = PsiTreeUtil.getParentOfType((PsiElement)element, CssSelectorList.class, (boolean)false) != null;
        if (inSelector) {
            return false;
        }
        CssBlock parentBlock = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class, (boolean)false);
        return parentBlock != null && PsiTreeUtil.getParentOfType((PsiElement)parentBlock, CssBlock.class, (boolean)true) == null;
    }
}

