/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.ruleset;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StyleCreator {
    @NotNull
    private final String myName;
    @NotNull
    protected final PsiFile myContextFile;

    protected StyleCreator(@NotNull String name, @NotNull PsiFile contextFile) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/actions/ruleset/StyleCreator", "<init>"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/psi/css/actions/ruleset/StyleCreator", "<init>"));
        }
        this.myName = name;
        this.myContextFile = contextFile;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ruleset/StyleCreator", "getName"));
        }
        return string;
    }

    @Nullable
    protected static CssRuleset createStyleInCssFile(@NotNull CssFile file, @NotNull String selector, CssDeclaration ... declarations) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/actions/ruleset/StyleCreator", "createStyleInCssFile"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/psi/css/actions/ruleset/StyleCreator", "createStyleInCssFile"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ruleset/StyleCreator", "createStyleInCssFile"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!FileModificationService.getInstance().prepareFileForWrite((PsiFile)file)) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        CssRuleset newRuleset = CssElementFactory.getInstance((Project)file.getProject()).createRuleset(selector, declarations, file.getLanguage());
        CssStylesheet stylesheet = file.getStylesheet();
        if (stylesheet == null) {
            stylesheet = CssElementFactory.getInstance((Project)file.getProject()).createStylesheet("", file.getLanguage());
            stylesheet = (CssStylesheet)file.add((PsiElement)stylesheet);
        }
        if (stylesheet != null) {
            CssRuleset result = stylesheet.addRuleset(newRuleset);
            if (result != null) {
                CodeEditUtil.markToReformat((ASTNode)result.getNode(), (boolean)true);
            }
            return StyleCreator.postProcessAndRestoreElement((PsiFile)file, result, PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file));
        }
        return null;
    }

    @Nullable
    public abstract CssRuleset createStyleDeclaration(@NotNull String var1, CssDeclaration ... var2);

    @Nullable
    public CssRuleset createStyleDeclaration(@NotNull HtmlCssClassOrIdReference classOrIdReference, CssDeclaration ... declarations) {
        if (classOrIdReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrIdReference", "com/intellij/psi/css/actions/ruleset/StyleCreator", "createStyleDeclaration"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/psi/css/actions/ruleset/StyleCreator", "createStyleDeclaration"));
        }
        return this.createStyleDeclaration(StyleCreator.getSelectorForReference(classOrIdReference), declarations);
    }

    public abstract void createStyleDeclarationInteractively(@NotNull Editor var1, @NotNull String var2, @NotNull Collection<String> var3, @Nullable CreateStyleCallback var4, CssDeclaration ... var5);

    @NotNull
    private static String getSelectorForReference(@NotNull HtmlCssClassOrIdReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/css/actions/ruleset/StyleCreator", "getSelectorForReference"));
        }
        PsiElement referenceElement = reference.getElement();
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, XmlAttribute.class);
        assert (attribute != null);
        String string = ("id".equals(attribute.getName()) ? "#" : ".") + reference.getRangeInElement().substring(referenceElement.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/ruleset/StyleCreator", "getSelectorForReference"));
        }
        return string;
    }

    @Nullable
    protected static CssRuleset postProcessAndRestoreElement(@NotNull PsiFile containingFile, @Nullable CssRuleset element, @Nullable Document document) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/css/actions/ruleset/StyleCreator", "postProcessAndRestoreElement"));
        }
        if (element == null || document == null) {
            return null;
        }
        Project project = containingFile.getProject();
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)element, containingFile);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        return (CssRuleset)smartPsiElementPointer.getElement();
    }
}

