/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssSelectorSuffixListImpl;
import com.intellij.psi.css.impl.stubs.CssSimpleSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssSimpleSelectorImpl
extends CssStubElement<CssSimpleSelectorStub>
implements CssSimpleSelector {
    public CssSimpleSelectorImpl(@NotNull CssSimpleSelectorStub stub, @NotNull CssStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "<init>"));
        }
        super(stub, nodeType);
    }

    public CssSimpleSelectorImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "<init>"));
        }
        super(node);
    }

    @Nullable
    public String getNamespaceName() {
        CssSimpleSelectorStub stub = (CssSimpleSelectorStub)this.getStub();
        if (stub != null) {
            return stub.getNamespaceName();
        }
        return (String)this.getElementData().first;
    }

    @NotNull
    public String getElementName() {
        CssSimpleSelectorStub stub = (CssSimpleSelectorStub)this.getStub();
        if (stub != null) {
            String string = stub.getElementName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "getElementName"));
            }
            return string;
        }
        String string = (String)this.getElementData().second;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "getElementName"));
        }
        return string;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return (PsiElement)this.getElementData().third;
    }

    @NotNull
    public CssSelectorSuffix[] getSelectorSuffixes() {
        CssSimpleSelectorStub stub = (CssSimpleSelectorStub)this.getStub();
        if (stub != null) {
            CssSelectorSuffix[] cssSelectorSuffixArray = (CssSelectorSuffix[])ContainerUtil.findAllAsArray((Collection)ContainerUtil.map((Collection)stub.getChildrenStubs(), element -> element.getPsi()), CssSelectorSuffix.class);
            if (cssSelectorSuffixArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "getSelectorSuffixes"));
            }
            return cssSelectorSuffixArray;
        }
        CssSelectorSuffix[] cssSelectorSuffixArray = (CssSelectorSuffix[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            CssSelectorSuffixListImpl suffixList = (CssSelectorSuffixListImpl)((Object)((Object)this.findChildByClass(CssSelectorSuffixListImpl.class)));
            if (suffixList == null) {
                return CachedValueProvider.Result.create((Object)CssSelectorSuffix.EMPTY_ARRAY, (Object[])new Object[]{this});
            }
            return CachedValueProvider.Result.create((Object)ContainerUtil.findAllAsArray((Object[])suffixList.getChildren(), CssSelectorSuffix.class), (Object[])new Object[]{this});
        });
        if (cssSelectorSuffixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "getSelectorSuffixes"));
        }
        return cssSelectorSuffixArray;
    }

    public boolean isUniversalSelector() {
        String elementName = this.getElementName();
        return elementName.isEmpty() || "*".equals(elementName);
    }

    public boolean isMatch(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "isMatch"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "isMatch"));
        }
        boolean nameMatch = this.isTagNameMatch(tag.getLocalName());
        return nameMatch && CssSimpleSelectorImpl.isMatch(tag, this.getSelectorSuffixes(), resolver);
    }

    public boolean isTagNameMatch(String tagName) {
        return this.isUniversalSelector() || this.elementNameMatches(tagName);
    }

    public String getPresentableText() {
        StringBuilder result = new StringBuilder();
        String namespaceName = this.getNamespaceName();
        if (StringUtil.isNotEmpty((String)namespaceName)) {
            result.append(namespaceName).append('|');
        }
        result.append(this.getElementName());
        for (CssSelectorSuffix suffix : this.getSelectorSuffixes()) {
            ItemPresentation presentation = suffix.getPresentation();
            if (presentation == null) continue;
            result.append(presentation.getPresentableText());
        }
        return result.toString();
    }

    private static boolean isMatch(@NotNull XmlTag tag, @NotNull CssSelectorSuffix[] selectorSuffixes, @NotNull CssResolver resolver) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "isMatch"));
        }
        if (selectorSuffixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorSuffixes", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "isMatch"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "isMatch"));
        }
        for (int i = selectorSuffixes.length - 1; i >= 0; --i) {
            CssSelectorSuffix selectorSuffix = selectorSuffixes[i];
            if (selectorSuffix.isMatch(tag, resolver)) continue;
            return false;
        }
        return true;
    }

    private Trinity<String, String, PsiElement> getElementData() {
        return (Trinity)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            String elementName;
            PsiElement nameIdentifier;
            PsiElement nameChild = this.getFirstChild();
            PsiElement nsChild = null;
            if (nameChild instanceof XmlToken) {
                PsiElement secondChild = nameChild.getNextSibling();
                if (((XmlToken)nameChild).getTokenType() == CssElementTypes.CSS_PIPE) {
                    nameChild = secondChild;
                } else if (secondChild instanceof XmlToken && ((XmlToken)secondChild).getTokenType() == CssElementTypes.CSS_PIPE) {
                    nsChild = nameChild;
                    nameChild = secondChild.getNextSibling();
                }
            }
            if (nameChild instanceof XmlToken) {
                nameIdentifier = nameChild;
                StringBuilder elementNameStringBuilder = new StringBuilder(nameChild.getText());
                while ((nameChild = nameChild.getNextSibling()) != null && nameChild.getNode().getElementType() != CssElementTypes.CSS_SELECTOR_SUFFIX_LIST) {
                    nameIdentifier = null;
                    elementNameStringBuilder.append(nameChild.getText());
                }
                elementName = elementNameStringBuilder.toString();
            } else {
                elementName = "";
                nameIdentifier = null;
            }
            String namespaceName = nsChild != null ? nsChild.getText() : null;
            return CachedValueProvider.Result.create((Object)Trinity.create((Object)namespaceName, (Object)elementName, (Object)nameIdentifier), (Object[])new Object[]{this});
        });
    }

    private boolean elementNameMatches(String name) {
        return this.getElementName().equalsIgnoreCase(name);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssSimpleSelectorImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssSimpleSelector((CssSimpleSelector)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

