/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.value;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssExpression;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssOperation;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssDecibelValue;
import com.intellij.psi.css.impl.descriptor.value.CssExpressionValue;
import com.intellij.psi.css.impl.descriptor.value.CssFrequencyValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssIdValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssJavaScriptValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.impl.descriptor.value.CssPositionValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssResolutionValue;
import com.intellij.psi.css.impl.descriptor.value.CssSelectorValue;
import com.intellij.psi.css.impl.descriptor.value.CssSemitonesValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssTimeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrangeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrlValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueValidatorImpl
implements CssValueValidator {
    @NotNull
    private final CssElementDescriptorProvider myElementDescriptorProvider;

    public CssValueValidatorImpl(@NotNull CssElementDescriptorProvider elementDescriptorProvider) {
        if (elementDescriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementDescriptorProvider", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl", "<init>"));
        }
        this.myElementDescriptorProvider = elementDescriptorProvider;
    }

    private static boolean isIntegerType(@NotNull CssTermType termType) {
        if (termType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termType", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl", "isIntegerType"));
        }
        return termType == CssTermTypes.NEGATIVE_NUMBER || termType == CssTermTypes.NUMBER || termType == CssTermTypes.INTEGER;
    }

    public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl", "isValid"));
        }
        Ref result = Ref.create((Object)true);
        CssValueValidatingDescriptorVisitor visitor = new CssValueValidatingDescriptorVisitor((Ref<Boolean>)result, term);
        valueDescriptor.accept((CssValueDescriptorVisitor)visitor);
        return (Boolean)result.get();
    }

    private class CssValueValidatingDescriptorVisitor
    extends CssValueDescriptorVisitorImpl {
        private final Ref<Boolean> myResult;
        private final PsiElement myTerm;

        public CssValueValidatingDescriptorVisitor(Ref<Boolean> result, PsiElement term) {
            this.myResult = result;
            this.myTerm = term;
        }

        @Override
        public void visitGroupValue(@NotNull CssGroupValue groupValue) {
            if (groupValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitGroupValue"));
            }
            this.myResult.set((Object)(this.myTerm != null ? 1 : 0));
            super.visitGroupValue(groupValue);
        }

        @Override
        public void visitAnyValue(@NotNull CssAnyValue anyValue) {
            if (anyValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anyValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitAnyValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && !StringUtil.isEmptyOrSpaces((String)this.myTerm.getText()) ? 1 : 0));
            super.visitAnyValue(anyValue);
        }

        @Override
        public void visitAngleValue(@NotNull CssAngleValue angleValue) {
            if (angleValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "angleValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitAngleValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.ANGLE || this.getTermType() == CssTermTypes.NEGATIVE_ANGLE ? 1 : 0));
            super.visitAngleValue(angleValue);
        }

        @Override
        public void visitColorValue(@NotNull CssColorValue colorValue) {
            if (colorValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitColorValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && (this.getTermType() == CssTermTypes.COLOR || this.myTerm instanceof CssTerm && CssValueValidatorImpl.this.myElementDescriptorProvider.isColorTerm((CssTerm)this.myTerm)) ? 1 : 0));
            super.visitColorValue(colorValue);
        }

        @Override
        public void visitFrequencyValue(@NotNull CssFrequencyValue frequencyValue) {
            if (frequencyValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frequencyValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitFrequencyValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.FREQUENCY ? 1 : 0));
            super.visitFrequencyValue(frequencyValue);
        }

        @Override
        public void visitFunctionValue(@NotNull CssFunctionInvocationValue functionValue) {
            if (functionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitFunctionValue"));
            }
            PsiElement firstChild = this.myTerm.getFirstChild();
            PsiElement lastChild = this.myTerm.getLastChild();
            String functionName = functionValue.getFunctionName();
            boolean functionMatched = false;
            if (firstChild != null && firstChild == lastChild && firstChild instanceof CssFunction) {
                boolean bl = functionMatched = functionName.equalsIgnoreCase(((CssFunction)firstChild).getName()) || functionName.equalsIgnoreCase(CssPropertyUtil.getElementNameWithoutVendorPrefix(((CssFunction)firstChild).getName()));
            }
            if (!functionMatched && "url".equalsIgnoreCase(functionName)) {
                functionMatched = firstChild != null && firstChild == lastChild && StringUtil.startsWith((CharSequence)firstChild.getText(), (CharSequence)"url(");
            }
            this.myResult.set((Object)functionMatched);
            super.visitFunctionValue(functionValue);
        }

        @Override
        public void visitIdValue(@NotNull CssIdValue idValue) {
            if (idValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitIdValue"));
            }
            if (this.myTerm == null) {
                this.myResult.set((Object)false);
            } else {
                PsiElement firstChild = this.myTerm.getFirstChild();
                this.myResult.set((Object)(firstChild != null && firstChild.getNode().getElementType() == CssElementTypes.CSS_HASH ? 1 : 0));
            }
            super.visitIdValue(idValue);
        }

        @Override
        public void visitInlineValue(@NotNull CssInlineValue inlineValue) {
            if (inlineValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlineValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitInlineValue"));
            }
            Collection inlineValues = CssValueValidatorImpl.this.myElementDescriptorProvider.getNamedValueDescriptors(inlineValue.getRefId(), null);
            for (CssValueDescriptor cssValueDescriptor : inlineValues) {
                if (!this.createMapper().mapValue(cssValueDescriptor).isMatched() || !((Boolean)this.myResult.get()).booleanValue()) continue;
                return;
            }
            this.myResult.set((Object)false);
            super.visitInlineValue(inlineValue);
        }

        @Override
        public void visitIntegerValue(@NotNull CssIntegerValue integerValue) {
            if (integerValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "integerValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitIntegerValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && CssValueValidatorImpl.isIntegerType(this.getTermType()) ? 1 : 0));
            super.visitIntegerValue(integerValue);
        }

        @Override
        public void visitExpressionValue(@NotNull CssExpressionValue expressionValue) {
            if (expressionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitExpressionValue"));
            }
            if (this.myTerm instanceof CssOperation) {
                this.myResult.set((Object)true);
            } else if (this.isLength() || CssValueValidatorImpl.isIntegerType(this.getTermType())) {
                PsiElement parent = this.myTerm.getParent();
                this.myResult.set((Object)(parent != null && parent instanceof CssTermList && ((CssTermList)parent).getTerms().length == 1 ? 1 : 0));
            }
            super.visitExpressionValue(expressionValue);
        }

        @Override
        public void visitJavaScriptValue(@NotNull CssJavaScriptValue javaScriptValue) {
            if (javaScriptValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaScriptValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitJavaScriptValue"));
            }
            this.myResult.set((Object)(this.myTerm instanceof CssExpression));
            super.visitJavaScriptValue(javaScriptValue);
        }

        @Override
        public void visitLengthValue(@NotNull CssLengthValue lengthValue) {
            if (lengthValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lengthValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitLengthValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.isLength() ? 1 : 0));
            super.visitLengthValue(lengthValue);
        }

        private boolean isLength() {
            return this.getTermType() == CssTermTypes.LENGTH || this.getTermType() == CssTermTypes.NEGATIVE_LENGTH || CssValueValidatorImpl.isIntegerType(this.getTermType()) && (this.myTerm.textMatches((CharSequence)"0") || this.myTerm.textMatches((CharSequence)"-0"));
        }

        @Override
        public void visitNameValue(@NotNull CssNameValue nameValue) {
            if (nameValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitNameValue"));
            }
            String expectedValue = nameValue.getValue();
            CssTermType termType = this.getTermType();
            this.myResult.set((Object)(this.myTerm != null && this.myTerm.getNode().getElementType() != CssElementTypes.CSS_HASH && (termType == CssTermTypes.IDENT || termType == CssTermTypes.COLOR) && this.termMatches(nameValue, expectedValue, this.myTerm.getText()) ? 1 : 0));
            super.visitNameValue(nameValue);
        }

        private boolean termMatches(@NotNull CssNameValue nameValue, @Nullable String expectedValue, @NotNull String termText) {
            if (nameValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "termMatches"));
            }
            if (termText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termText", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "termMatches"));
            }
            return expectedValue == null && !StringUtil.startsWithChar((CharSequence)termText, (char)'#') || Comparing.strEqual((String)termText, (String)expectedValue, (boolean)nameValue.isCaseSensitive());
        }

        @Override
        public void visitNumberValue(@NotNull CssNumberValue numberValue) {
            if (numberValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "numberValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitNumberValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && (this.getTermType() == CssTermTypes.NUMBER || this.getTermType() == CssTermTypes.NEGATIVE_NUMBER) ? 1 : 0));
            super.visitNumberValue(numberValue);
        }

        @Override
        public void visitPercentageValue(@NotNull CssPercentageValue percentageValue) {
            if (percentageValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "percentageValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitPercentageValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && (this.getTermType() == CssTermTypes.PERCENTAGE || this.getTermType() == CssTermTypes.NEGATIVE_PERCENTAGE) ? 1 : 0));
            super.visitPercentageValue(percentageValue);
        }

        @Override
        public void visitResolutionValue(@NotNull CssResolutionValue resolutionValue) {
            if (resolutionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitResolutionValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.RESOLUTION ? 1 : 0));
            super.visitResolutionValue(resolutionValue);
        }

        @Override
        public void visitPositionValue(@NotNull CssPositionValue positionValue) {
            if (positionValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positionValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitPositionValue"));
            }
            this.visitInlineValue(positionValue);
        }

        @Override
        public void visitPropertyReferenceValue(@NotNull CssPropertyReferenceValue propertyReferenceValue) {
            if (propertyReferenceValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyReferenceValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitPropertyReferenceValue"));
            }
            Collection propertyDescriptors = CssValueValidatorImpl.this.myElementDescriptorProvider.findPropertyDescriptors(propertyReferenceValue.getPropertyName(), this.myTerm);
            for (CssPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                if (!this.createMapper().mapValue(propertyDescriptor.getValueDescriptor()).isMatched() || !((Boolean)this.myResult.get()).booleanValue()) continue;
                return;
            }
            this.myResult.set((Object)false);
            super.visitPropertyReferenceValue(propertyReferenceValue);
        }

        @Override
        public void visitSelectorValue(@NotNull CssSelectorValue selectorValue) {
            if (selectorValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitSelectorValue"));
            }
            super.visitSelectorValue(selectorValue);
        }

        @Override
        public void visitStringValue(@NotNull CssStringValue stringValue) {
            if (stringValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitStringValue"));
            }
            String value = stringValue.getValue();
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.STRING && (value == null || this.myTerm.textMatches((CharSequence)("'" + value + "'")) || this.myTerm.textMatches((CharSequence)("\"" + value + "\"")) || this.myTerm.textMatches((CharSequence)"value")) ? 1 : 0));
            super.visitStringValue(stringValue);
        }

        @Override
        public void visitTextValue(@NotNull CssTextValue textValue) {
            if (textValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitTextValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && textValue.getValue().equalsIgnoreCase(this.myTerm.getText()) ? 1 : 0));
            super.visitTextValue(textValue);
        }

        @Override
        public void visitTimeValue(@NotNull CssTimeValue timeValue) {
            if (timeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitTimeValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.TIME ? 1 : 0));
            super.visitTimeValue(timeValue);
        }

        @Override
        public void visitUrangeValue(@NotNull CssUrangeValue urangeValue) {
            if (urangeValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urangeValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitUrangeValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.UNICODE_RANGE ? 1 : 0));
            super.visitUrangeValue(urangeValue);
        }

        @Override
        public void visitUrlValue(@NotNull CssUrlValue urlValue) {
            if (urlValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitUrlValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.URI ? 1 : 0));
            super.visitUrlValue(urlValue);
        }

        @Override
        public void visitDecibelValue(@NotNull CssDecibelValue decibelValue) {
            if (decibelValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decibelValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitDecibelValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.DECIBEL ? 1 : 0));
            super.visitDecibelValue(decibelValue);
        }

        @Override
        public void visitSemitonesValue(@NotNull CssSemitonesValue semitoneValue) {
            if (semitoneValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semitoneValue", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitSemitonesValue"));
            }
            this.myResult.set((Object)(this.myTerm != null && this.getTermType() == CssTermTypes.SEMITONES ? 1 : 0));
            super.visitSemitonesValue(semitoneValue);
        }

        @Override
        public void visitValue(@NotNull CssValueDescriptor value) {
            String functionName;
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "visitValue"));
            }
            ProgressIndicatorProvider.checkCanceled();
            CssValueDescriptor exclusion = value.getExclusion();
            if (exclusion != null && this.createMapper().mapValue(exclusion).isMatched()) {
                this.myResult.set((Object)false);
                return;
            }
            PsiElement firstChild = this.myTerm.getFirstChild();
            PsiElement lastChild = this.myTerm.getLastChild();
            if (firstChild != null && firstChild == lastChild && firstChild instanceof CssFunction && (functionName = ((CssFunction)firstChild).getName()).equalsIgnoreCase("var")) {
                this.myResult.set((Object)true);
            }
        }

        @NotNull
        private CssTermType getTermType() {
            CssTermType cssTermType = this.myTerm instanceof CssTerm ? ((CssTerm)this.myTerm).getTermType() : CssTermType.UNKNOWN;
            if (cssTermType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "getTermType"));
            }
            return cssTermType;
        }

        @NotNull
        private CssValueDescriptorMapper createMapper() {
            CssTermList value = (CssTermList)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myTerm, (Class[])new Class[]{CssTermList.class});
            CssValueDescriptorMapper cssValueDescriptorMapper = new CssValueDescriptorMapper(this.myTerm, CssPsiUtil.getLastDeepestTerm((PsiElement)value));
            if (cssValueDescriptorMapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/value/CssValueValidatorImpl$CssValueValidatingDescriptorVisitor", "createMapper"));
            }
            return cssValueDescriptorMapper;
        }
    }
}

