/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import org.jetbrains.annotations.NotNull;

public class CssHighlightingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "annotate"));
        }
        if (holder.isBatchMode()) {
            return;
        }
        if (element instanceof CssSimpleSelector) {
            PsiElement identifier = ((CssSimpleSelector)element).getNameIdentifier();
            String elementName = ((CssSimpleSelector)element).getElementName();
            if (identifier != null && CssDescriptorsUtil.isPossibleSelector((String)elementName, (PsiElement)element)) {
                String annotationMessage = ApplicationManager.getApplication().isUnitTestMode() ? "TAG_NAME" : null;
                Annotation annotation = holder.createInfoAnnotation(identifier, annotationMessage);
                annotation.setTextAttributes(CssHighlighter.CSS_TAG_NAME);
            }
        }
        if (element.getNode().getElementType() == CssElementTypes.CSS_ATKEYWORD) {
            String annotationMessage = ApplicationManager.getApplication().isUnitTestMode() ? "AT_RULE_KEYWORD" : null;
            holder.createInfoAnnotation(element, annotationMessage).setTextAttributes(CssHighlighter.CSS_KEYWORD);
        }
    }
}

