/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPsiColorUtil {
    /*
     * Exception decompiling
     */
    @Nullable
    private static Color getColorInClassicCss(@NotNull PsiElement element) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 19[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static Color getColor(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)element);
        CssTerm term = CssPsiColorUtil.getColorTerm(element);
        if (term != null) {
            PsiElement firstChild = term.getFirstChild();
            if (firstChild != null) {
                Color color = CssPsiColorUtil.getColorInClassicCss(firstChild);
                if (color != null) {
                    return color;
                }
                String value = firstChild.getText();
                if (value != null && descriptorProvider != null) {
                    return descriptorProvider.getColorByValue(value);
                }
            }
        } else {
            Color color = CssPsiColorUtil.getColorInClassicCss(element);
            if (color != null) {
                return color;
            }
            String value = element.getText();
            if (value != null && descriptorProvider != null) {
                return descriptorProvider.getColorByValue(value);
            }
        }
        return null;
    }

    @Nullable
    public static CssTerm getColorTerm(@Nullable PsiElement element) {
        CssTerm term = null;
        if (element instanceof CssTermList) {
            PsiElement[] children = element.getChildren();
            if (children.length > 0 && children[0] instanceof CssTerm) {
                term = (CssTerm)children[0];
            }
        } else {
            term = CssUtil.getEnclosingTerm(element);
        }
        if (term == null || !term.isValid()) {
            return null;
        }
        if (CssTermTypes.COLOR == term.getTermType()) {
            return term;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)element);
        if (descriptorProvider != null && descriptorProvider.isColorTerm(term)) {
            return term;
        }
        return null;
    }

    private static Color createColor(int r, int g, int b) {
        return new Color(Math.min(Math.max(r, 0), 255), Math.min(Math.max(g, 0), 255), Math.min(Math.max(b, 0), 255));
    }

    private static Color createColor(float r, float g, float b) {
        return new Color(Math.min(Math.max(r, 0.0f), 1.0f), Math.min(Math.max(g, 0.0f), 1.0f), Math.min(Math.max(b, 0.0f), 1.0f));
    }

    private static Color createColor(int r, int g, int b, int a) {
        return new Color(Math.min(Math.max(r, 0), 255), Math.min(Math.max(g, 0), 255), Math.min(Math.max(b, 0), 255), Math.min(Math.max(a, 0), 255));
    }

    private static Color createColor(float r, float g, float b, float a) {
        return new Color(Math.min(Math.max(r, 0.0f), 1.0f), Math.min(Math.max(g, 0.0f), 1.0f), Math.min(Math.max(b, 0.0f), 1.0f), Math.min(Math.max(a, 0.0f), 1.0f));
    }

    @NotNull
    public static String toRgbColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toRgbColor"));
        }
        if (color.getAlpha() < 255) {
            String string = "rgba(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + CssPsiColorUtil.getAlphaString(color) + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toRgbColor"));
            }
            return string;
        }
        String string = "rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ')';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toRgbColor"));
        }
        return string;
    }

    @NotNull
    private static String getAlphaString(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getAlphaString"));
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));
        String string = color.getAlpha() == 0 ? "0" : decimalFormat.format((double)color.getAlpha() / 255.0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "getAlphaString"));
        }
        return string;
    }

    @NotNull
    public static String toHexColor(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHexColor"));
        }
        StringBuilder sb = new StringBuilder("#");
        for (int i = 0; i < 3; ++i) {
            String s = Integer.toHexString(i == 0 ? color.getRed() : (i == 1 ? color.getGreen() : color.getBlue()));
            if (s.length() < 2) {
                sb.append('0');
            }
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHexColor"));
        }
        return string;
    }

    public static boolean isColorTerm(@NotNull CssTerm term) {
        if (term == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "term", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "isColorTerm"));
        }
        if (term.getTermType() == CssTermTypes.COLOR) {
            return true;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)term);
        return descriptorProvider != null && descriptorProvider.isColorTerm(term);
    }

    @NotNull
    public static String toHslColor(@NotNull Color color) {
        float S;
        float var_Max;
        float var_Min;
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHslColor"));
        }
        float var_R = (float)color.getRed() / 255.0f;
        float var_G = (float)color.getGreen() / 255.0f;
        float var_B = (float)color.getBlue() / 255.0f;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        float del_Max = var_Max - var_Min;
        float H = 0.0f;
        float L = (var_Max + var_Min) / 2.0f;
        if (del_Max == 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = (double)L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
            float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
            if (var_R == var_Max) {
                H = del_B - del_G;
            } else if (var_G == var_Max) {
                H = 0.33333334f + del_R - del_B;
            } else if (var_B == var_Max) {
                H = 0.6666667f + del_G - del_R;
            }
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        StringBuilder b = new StringBuilder();
        if (color.getAlpha() < 255) {
            b.append("hsla(").append((int)(360.0f * H)).append(',').append((int)(S * 100.0f)).append("%,").append((int)(L * 100.0f)).append("%,").append(CssPsiColorUtil.getAlphaString(color)).append(')');
        } else {
            b.append("hsl(").append((int)(360.0f * H)).append(',').append((int)(S * 100.0f)).append("%,").append((int)(L * 100.0f)).append("%)");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toHslColor"));
        }
        return string;
    }

    public static String convertTo(@NotNull ColorDeclarationType declarationType, @NotNull Color color) {
        if (declarationType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationType", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "convertTo"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "convertTo"));
        }
        switch (declarationType) {
            case RGB: 
            case RGBA: {
                return CssPsiColorUtil.toRgbColor(color);
            }
            case HSL: 
            case HSLA: {
                return CssPsiColorUtil.toHslColor(color);
            }
        }
        return color.getAlpha() < 255 ? CssPsiColorUtil.toRgbColor(color) : CssPsiColorUtil.toHexColor(color);
    }

    @NotNull
    public static String toShortHexColor(@NotNull String colorInLongNotation) {
        int shift;
        if (colorInLongNotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorInLongNotation", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toShortHexColor"));
        }
        int n = shift = StringUtil.startsWithChar((CharSequence)colorInLongNotation, (char)'#') ? 1 : 0;
        if (colorInLongNotation.length() - shift == 6 && colorInLongNotation.charAt(shift) == colorInLongNotation.charAt(1 + shift) && colorInLongNotation.charAt(2 + shift) == colorInLongNotation.charAt(3 + shift) && colorInLongNotation.charAt(4 + shift) == colorInLongNotation.charAt(5 + shift)) {
            colorInLongNotation = "#" + colorInLongNotation.charAt(shift) + colorInLongNotation.charAt(2 + shift) + colorInLongNotation.charAt(4 + shift);
        }
        String string = colorInLongNotation;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "toShortHexColor"));
        }
        return string;
    }

    @NotNull
    public static String normalizeHexColor(@NotNull String colorText) {
        if (colorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorText", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
        }
        if (StringUtil.startsWithChar((CharSequence)colorText, (char)'#')) {
            colorText = colorText.substring(1);
        }
        switch (colorText.length()) {
            case 0: {
                String string = colorText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 1: {
                String string = '#' + StringUtil.repeat((String)colorText, (int)6);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 2: {
                String string = '#' + StringUtil.repeat((String)colorText, (int)3);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 3: {
                String string = "#" + colorText.charAt(0) + colorText.charAt(0) + colorText.charAt(1) + colorText.charAt(1) + colorText.charAt(2) + colorText.charAt(2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 4: {
                String string = '#' + colorText + colorText.substring(0, 2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
            case 5: {
                String string = '#' + colorText + colorText.charAt(0);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
                }
                return string;
            }
        }
        String string = '#' + colorText.substring(0, 6);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/CssPsiColorUtil", "normalizeHexColor"));
        }
        return string;
    }
}

