/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssCompositeElementDescriptor;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssNavigableDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import com.intellij.psi.css.impl.util.completion.handler.CssPropertyValueInsertHandler;
import com.intellij.psi.css.impl.util.table.CssColorValue;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.UserColorLookup;
import icons.ImagesIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompletionUtil {
    public static final int CSS_VALUE_BASE_PRIORITY = 100;
    public static final int CSS_CUSTOM_PROPERTY_PRIORITY = 110;
    private static final int CSS_COLOR_VALUE_PRIORITY = 80;
    private static final int CSS_POPULAR_COLOR_VALUE_PRIORITY = 81;
    private static final int CSS_USER_COLOR_LOOKUP_PRIORITY = 90;
    private static final int CSS_IMAGE_SIZE_PRIORITY = 110;
    public static final int CSS_COMMON_FUNCTIONS_PRIORITY = 95;
    public static final int CSS_PROPERTY_NAME_PRIORITY = 10;
    public static final int CSS_CUSTOM_PROPERTY_DECLARATION_PRIORITY = 9;
    public static final int CSS_PSEUDO_SELECTOR_PRIORITY = 10;
    public static final int CSS_MEDIA_FEATURE_PRIORITY = 10;
    private static final Function<Color, String> COLOR_TO_STRING_CONVERTER = color -> color.getAlpha() < 255 ? CssPsiColorUtil.toRgbColor(color) : CssPsiColorUtil.toHexColor(color);

    @NotNull
    public static Collection<LookupElement> lookupItemsForDescriptors(@NotNull Collection<? extends CssElementDescriptor> descriptors, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        Collection<LookupElement> collection = CssCompletionUtil.lookupItemsForDescriptors(descriptors, insertHandler, (NotNullFunction<CssElementDescriptor, String>)CssDescriptorsUtil.GET_DESCRIPTOR_ID_FUNCTION, priority);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        return collection;
    }

    @NotNull
    public static Collection<LookupElement> lookupItemsForDescriptors(@NotNull Collection<? extends CssElementDescriptor> descriptors, @Nullable InsertHandler<LookupElement> insertHandler, @NotNull NotNullFunction<CssElementDescriptor, String> extractLookupStringFunction, int priority) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        if (extractLookupStringFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extractLookupStringFunction", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        MultiMap map = MultiMap.create();
        for (CssElementDescriptor cssElementDescriptor : descriptors) {
            map.putValue((Object)cssElementDescriptor.getId(), (Object)cssElementDescriptor);
        }
        for (Map.Entry entry : map.entrySet()) {
            CssElementDescriptor descriptor = CssCompositeElementDescriptor.create((Collection)((Collection)entry.getValue()));
            if (descriptor == null) continue;
            result.add(CssCompletionUtil.lookupItemForDescriptor((String)extractLookupStringFunction.fun((Object)descriptor), descriptor, insertHandler, priority));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemsForDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public static LookupElement lookupItemForDescriptor(@NotNull CssElementDescriptor descriptor, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        LookupElement lookupElement = CssCompletionUtil.lookupItemForDescriptor(descriptor.getId(), descriptor, insertHandler, priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupItemForDescriptor(@NotNull String lookupString, @NotNull CssElementDescriptor descriptor, @Nullable InsertHandler<LookupElement> insertHandler, int priority) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        CssElementDescriptor.CssVersion version = descriptor.getCssVersion();
        Icon browsersIcon = CssCompletionUtil.getBrowsersIcon(lookupString, descriptor);
        if (browsersIcon != null) {
            browsersIcon = IconLoader.getTransparentIcon((Icon)browsersIcon, (float)0.6f);
        }
        PsiElement lookupObject = descriptor instanceof CssNavigableDescriptor ? ((CssNavigableDescriptor)descriptor).getElement() : null;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)ObjectUtils.notNull((Object)lookupObject, (Object)descriptor), (String)lookupString).withIcon(descriptor.getIcon()).withTailText(CssCompletionUtil.descriptorTailText(descriptor), true).withTypeText(version != CssElementDescriptor.CssVersion.UNKNOWN ? version.getPresentableName() : "", browsersIcon, true).withInsertHandler(insertHandler);
        if (CssPropertyUtil.isVendorSpecificElement(descriptor.getId()) || version == CssElementDescriptor.CssVersion.UNKNOWN) {
            --priority;
        }
        if (descriptor.getId().startsWith("mso-")) {
            priority -= 2;
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElementBuilder, (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForDescriptor"));
        }
        return lookupElement;
    }

    private static String descriptorTailText(@NotNull CssElementDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "descriptorTailText"));
        }
        if (descriptor instanceof CssFunctionDescriptor) {
            CssParameterInfoValueDescriptorsVisitor messageBuilder = new CssParameterInfoValueDescriptorsVisitor(null, true, false);
            ((CssFunctionDescriptor)descriptor).getValueDescriptor().accept((CssValueDescriptorVisitor)messageBuilder);
            return "(" + StringUtil.unescapeXml((String)messageBuilder.getParameterInfo()) + ")";
        }
        return null;
    }

    @NotNull
    public static LookupElement lookupItemForImageSize(int size, @Nullable PsiFile imageFile) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)String.valueOf(size + "px")).withIcon(ImagesIcons.ImagesFileType);
        lookupElementBuilder = imageFile != null ? lookupElementBuilder.withTypeText(SymbolPresentationUtil.getFilePathPresentation((PsiFile)imageFile), true) : lookupElementBuilder;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElementBuilder, (double)110.0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForImageSize"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupItemForValue(String value) {
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)value).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE), (double)100.0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForValue"));
        }
        return lookupElement;
    }

    public static LookupElement valueLookupElement(Object o) {
        LookupElement lookupElement = null;
        if (o instanceof LookupElement) {
            lookupElement = (LookupElement)o;
        } else if (o instanceof String) {
            lookupElement = LookupElementBuilder.create((Object)o).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE);
        } else if (o instanceof CssUserLookupBase) {
            lookupElement = ((CssUserLookupBase)o).lookup();
        } else if (o instanceof ColorSampleLookupValue) {
            lookupElement = LookupElementDecorator.withInsertHandler((LookupElement)CompletionData.objectToLookupItem((Object)o), CssPropertyValueInsertHandler.INSTANCE);
        }
        return lookupElement != null ? PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)CssCompletionUtil.priority(o)) : null;
    }

    private CssCompletionUtil() {
    }

    private static int priority(Object o) {
        int priority = o instanceof CssColorValue.MyPopularColorLookupValue ? 81 + ((ColorSampleLookupValue)o).getPriority() : (o instanceof ColorSampleLookupValue ? 80 + ((ColorSampleLookupValue)o).getPriority() : (o instanceof LookupValueWithPriority ? 100 + ((LookupValueWithPriority)o).getPriority() : 100));
        return priority;
    }

    public static UserColorLookup lookupForUserColorLookup() {
        return new UserColorLookup(COLOR_TO_STRING_CONVERTER, 90);
    }

    @Nullable
    private static Icon getBrowsersIcon(@NotNull String lookupString, @NotNull CssElementDescriptor descriptor) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "getBrowsersIcon"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "getBrowsersIcon"));
        }
        BrowserVersion[] browsers = descriptor.getBrowsers();
        if (browsers.length > 0 && browsers.length < BrowserVersion.Browser.values().length) {
            RowIcon icon = new RowIcon(browsers.length);
            for (int i = 0; i < browsers.length; ++i) {
                icon.setIcon(browsers[i].getBrowser().getIcon(), i);
            }
            return icon;
        }
        if (lookupString.startsWith("-ms-") || lookupString.startsWith("mso-")) {
            return BrowserVersion.Browser.IE.getIcon();
        }
        if (lookupString.startsWith("-moz-")) {
            return BrowserVersion.Browser.FIREFOX.getIcon();
        }
        if (lookupString.startsWith("-webkit-")) {
            RowIcon icon = new RowIcon(2);
            icon.setIcon(BrowserVersion.Browser.CHROME.getIcon(), 0);
            icon.setIcon(BrowserVersion.Browser.SAFARI.getIcon(), 1);
            return icon;
        }
        if (lookupString.startsWith("-o-")) {
            return BrowserVersion.Browser.OPERA.getIcon();
        }
        return null;
    }

    @NotNull
    public static LookupElement lookupForCustomProperty(@NotNull String name, @NotNull CssDeclaration declaration, @Nullable PsiFile contextFile, int priority, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupForCustomProperty"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupForCustomProperty"));
        }
        PsiFile containingFile = declaration.getContainingFile();
        if (contextFile == containingFile) {
            ++priority;
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        assert (itemPresentation != null);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)declaration).withPresentableText((String)ObjectUtils.notNull((Object)itemPresentation.getPresentableText(), (Object)name)).withCaseSensitivity(true).withIcon(itemPresentation.getIcon(false)).withTypeText(itemPresentation.getLocationString(), true).withInsertHandler(insertHandler), (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupForCustomProperty"));
        }
        return lookupElement;
    }
}

