/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.handler;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssColorUtil;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssPropertyValueInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new CssPropertyValueInsertHandler();

    public void handleInsert(InsertionContext context, LookupElement item) {
        CssDeclaration declaration;
        CssPropertyDescriptor propertyValueDescriptor;
        PsiElement elementAtCaret = context.getFile().findElementAt(context.getStartOffset());
        CssTerm cssTerm = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssTerm.class, (boolean)false);
        if (cssTerm != null && cssTerm.getTermType() == CssTermTypes.COLOR) {
            CssPropertyValueInsertHandler.completeCssColor(cssTerm, context.getProject(), context.getDocument());
        }
        CssPropertyDescriptor cssPropertyDescriptor = propertyValueDescriptor = (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssDeclaration.class)) != null ? declaration.getDescriptor() : null;
        if (propertyValueDescriptor == null) {
            return;
        }
        CssCompletionContext cssCompletionContext = CssPropertyDescriptorImpl.buildFullContext(declaration);
        Editor editor = context.getEditor();
        int offset = editor.getCaretModel().getOffset();
        String declarationsTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)elementAtCaret);
        String elementTerminator = null;
        CssPropertyValue value = propertyValueDescriptor.getValue();
        boolean statementIsCompleted = PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssFunction.class) == null && PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, CssUri.class) == null && cssCompletionContext != null && value != null && value.isCompleted(cssCompletionContext);
        Document document = editor.getDocument();
        String afterDeclarationText = null;
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
        if (document.getTextLength() >= offset) {
            afterDeclarationText = document.getText(TextRange.create((int)offset, (int)lineEndOffset)).trim();
        }
        if (StringUtil.isEmpty(afterDeclarationText)) {
            elementTerminator = declarationsTerminator;
        } else if (statementIsCompleted && declarationsTerminator.equals(afterDeclarationText)) {
            if (declarationsTerminator.isEmpty()) {
                offset = lineEndOffset;
            } else {
                CharSequence sequence = document.getCharsSequence();
                while (offset < lineEndOffset && sequence.charAt(offset) != declarationsTerminator.charAt(0)) {
                    ++offset;
                }
                ++offset;
            }
            elementTerminator = "";
        }
        if (offset <= document.getTextLength() && elementTerminator != null) {
            document.insertString(offset, (CharSequence)elementTerminator);
            if (statementIsCompleted) {
                editor.getCaretModel().moveToOffset(offset + elementTerminator.length());
            }
        }
    }

    private static int completeCssColor(@NotNull CssTerm cssTerm, @NotNull Project project, @NotNull Document document) {
        if (cssTerm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssTerm", "com/intellij/psi/css/impl/util/completion/handler/CssPropertyValueInsertHandler", "completeCssColor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/impl/util/completion/handler/CssPropertyValueInsertHandler", "completeCssColor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/css/impl/util/completion/handler/CssPropertyValueInsertHandler", "completeCssColor"));
        }
        String text = cssTerm.getText();
        if (StringUtil.startsWithChar((CharSequence)text, (char)'#')) {
            String newColorText = CssColorUtil.formatHexColorAccordingToCodeStyle(text, project);
            TextRange range = cssTerm.getTextRange();
            document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newColorText);
            return newColorText.length() - text.length();
        }
        return 0;
    }
}

