/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssAtKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider", "addCompletions"));
        }
        boolean indentBased = CssPsiUtil.isIndentBasedCssLanguage((PsiElement)parameters.getPosition());
        String declarationsTerminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)parameters.getPosition());
        AddSpaceWithBracesInsertHandler addSpaceWithBracesInsertHandler = new AddSpaceWithBracesInsertHandler(indentBased);
        AddBracesInsertHandler addBracesInsertHandler = new AddBracesInsertHandler(indentBased);
        AddQuotesInsertHandler addQuotesInsertHandler = new AddQuotesInsertHandler(declarationsTerminator);
        CssAtKeywordsCompletionProvider.addKeywords(result, addSpaceWithBracesInsertHandler, "@page", "@supports", "@media", "@region", "@counter-style", "@-webkit-region", "@keyframes", "@-o-keyframes", "@-moz-keyframes", "@-ms-keyframes", "@-webkit-keyframes", "@-khtml-keyframes", "@scope", "@document", "@-moz-document");
        CssAtKeywordsCompletionProvider.addKeywords(result, addBracesInsertHandler, "@viewport", "@-o-viewport", "@-ms-viewport", "@font-face");
        CssAtKeywordsCompletionProvider.addKeywords(result, addQuotesInsertHandler, "@import", "@charset");
        CssAtKeywordsCompletionProvider.addKeywords(result, (InsertHandler<LookupElement>)ParenthesesInsertHandler.getInstance((boolean)true), "@apply");
        CssElement parentRuleset = (CssElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), (Class[])new Class[]{CssRuleset.class, CssAtRule.class});
        if (parentRuleset instanceof CssAtRule && ((CssAtRule)parentRuleset).getType() == CssContextType.UNKNOWN) {
            parentRuleset = (CssElement)PsiTreeUtil.getParentOfType((PsiElement)parentRuleset, (Class[])new Class[]{CssRuleset.class, CssAtRule.class});
        }
        if (parentRuleset instanceof CssAtRule && ((CssAtRule)parentRuleset).getType() == CssContextType.PAGE) {
            CssAtKeywordsCompletionProvider.addKeywords(result, addBracesInsertHandler, CssContextType.PAGE_MARGIN_RULES);
        }
    }

    private static void addKeywords(@NotNull CompletionResultSet result, @Nullable InsertHandler<LookupElement> insertHandler, String ... lookupStrings) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider", "addKeywords"));
        }
        if (lookupStrings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupStrings", "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider", "addKeywords"));
        }
        for (String lookupString : lookupStrings) {
            result.addElement(CssCompletionUtil.lookupForKeyword(lookupString, insertHandler));
        }
    }

    private static int skipWhiteSpaces(Editor editor, int offset) {
        CharSequence sequence = editor.getDocument().getCharsSequence();
        while (offset < sequence.length() && StringUtil.isWhiteSpace((char)sequence.charAt(offset))) {
            ++offset;
        }
        return Math.min(sequence.length() - 1, offset);
    }

    private static void typeOrMove(@NotNull Editor editor, char ch) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider", "typeOrMove"));
        }
        if (!CssAtKeywordsCompletionProvider.isCaretAtChar(editor, ch)) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)String.valueOf(ch));
        } else {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        }
    }

    private static boolean isCaretAtChar(Editor editor, char ch) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ch;
    }

    private static String getIndentString(InsertionContext context) {
        int indentSize = CodeStyleSettingsManager.getSettings((Project)context.getProject()).getIndentSize(context.getFile().getFileType());
        return StringUtil.repeat((String)" ", (int)indentSize);
    }

    public static class AddQuotesInsertHandler
    implements InsertHandler<LookupElement> {
        @NotNull
        private final String myDeclarationsTerminator;

        public AddQuotesInsertHandler(@NotNull String declarationsTerminator) {
            if (declarationsTerminator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationsTerminator", "com/intellij/psi/css/impl/util/completion/provider/CssAtKeywordsCompletionProvider$AddQuotesInsertHandler", "<init>"));
            }
            this.myDeclarationsTerminator = declarationsTerminator;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            CssAtKeywordsCompletionProvider.typeOrMove(editor, ' ');
            CharSequence sequence = editor.getDocument().getCharsSequence();
            int offset = CssAtKeywordsCompletionProvider.skipWhiteSpaces(editor, editor.getCaretModel().getOffset());
            if (sequence.charAt(offset) != '\"') {
                String quotes = "\"\"";
                if (!(this.myDeclarationsTerminator.isEmpty() || sequence.length() >= offset + this.myDeclarationsTerminator.length() && sequence.subSequence(offset, offset + this.myDeclarationsTerminator.length()).toString().equals(this.myDeclarationsTerminator))) {
                    quotes = quotes + this.myDeclarationsTerminator;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)quotes, (boolean)false, (boolean)false);
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            } else {
                editor.getCaretModel().moveToOffset(offset + 1);
            }
            AutoPopupController.getInstance((Project)editor.getProject()).autoPopupMemberLookup(editor, null);
        }
    }

    private static class AddBracesInsertHandler
    implements InsertHandler<LookupElement> {
        private final boolean myIndentBased;

        public AddBracesInsertHandler(boolean indentBased) {
            this.myIndentBased = indentBased;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Editor editor = context.getEditor();
            if (this.myIndentBased) {
                String indentString = CssAtKeywordsCompletionProvider.getIndentString(context);
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + indentString));
            } else {
                int offset = CssAtKeywordsCompletionProvider.skipWhiteSpaces(editor, editor.getCaretModel().getOffset());
                if (editor.getDocument().getCharsSequence().charAt(offset) != '{') {
                    Project project = editor.getProject();
                    Template template = TemplateManager.getInstance((Project)project).createTemplate("css_insert_handler_template", "css", " {\n$END$\n}");
                    template.setToReformat(true);
                    TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                }
            }
        }
    }

    private static class AddSpaceWithBracesInsertHandler
    implements InsertHandler<LookupElement> {
        private final boolean myIndentBased;

        private AddSpaceWithBracesInsertHandler(boolean indentBased) {
            this.myIndentBased = indentBased;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            context.setAddCompletionChar(false);
            Editor editor = context.getEditor();
            if (this.myIndentBased) {
                CssAtKeywordsCompletionProvider.typeOrMove(editor, ' ');
                AutoPopupController.getInstance((Project)editor.getProject()).autoPopupMemberLookup(editor, null);
            } else {
                int offset = CssAtKeywordsCompletionProvider.skipWhiteSpaces(editor, editor.getCaretModel().getOffset());
                if (editor.getDocument().getCharsSequence().charAt(offset) != '{') {
                    Project project = editor.getProject();
                    Template template = TemplateManager.getInstance((Project)project).createTemplate("css_insert_handler_template", "css", " $VAR0$ {\n$END$\n}");
                    template.addVariable("VAR0", (Expression)new MacroCallNode((Macro)new CompleteMacro()), true);
                    template.setToReformat(true);
                    TemplateManager.getInstance((Project)project).startTemplate(editor, template);
                } else {
                    CssAtKeywordsCompletionProvider.typeOrMove(editor, ' ');
                    AutoPopupController.getInstance((Project)editor.getProject()).autoPopupMemberLookup(editor, null);
                }
            }
        }
    }
}

