/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.editor;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSupportsCondition;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermImpl;
import com.intellij.psi.css.impl.parsing.CssMathParser;
import com.intellij.psi.css.impl.util.CssStyleSheetElementType;
import com.intellij.psi.css.impl.util.completion.TimeUserLookup;
import com.intellij.psi.css.impl.util.editor.CssFormattingElementVisitor;
import com.intellij.psi.css.impl.util.editor.CssFormattingModel;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        CssCodeStyleSettings customSettings = (CssCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)element.getProject()).getCustomSettings(CssCodeStyleSettings.class);
        PsiFile psiFile = element.getContainingFile();
        PsiElement rootElement = psiFile instanceof XmlFile ? element : psiFile;
        final int[] maxPropertyName = new int[]{0};
        if (customSettings.VALUE_ALIGNMENT == 2 || customSettings.VALUE_ALIGNMENT == 1) {
            rootElement.acceptChildren((PsiElementVisitor)new CssElementVisitor(){

                public void visitCssDeclaration(CssDeclaration declaration) {
                    super.visitCssDeclaration(declaration);
                    maxPropertyName[0] = Math.max(maxPropertyName[0], declaration.getPropertyName().length());
                }

                public void visitElement(PsiElement element) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            });
        }
        CssFormattingExtension extension = this.createExtension();
        CssRootBlock root = extension.createRootBlock(rootElement.getNode(), customSettings, maxPropertyName[0], extension);
        CssFormattingModel cssFormattingModel = new CssFormattingModel(psiFile, customSettings, (Block)root);
        if (cssFormattingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder", "createModel"));
        }
        return cssFormattingModel;
    }

    protected CssFormattingExtension createExtension() {
        return new CssFormattingExtension();
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    public static class CssFormattingExtension {
        public boolean isComment(IElementType elementType) {
            return elementType == CssElementTypes.CSS_COMMENT;
        }

        public boolean addXmlBlock(XmlToken token) {
            return false;
        }

        public boolean isLineComment(IElementType elementType) {
            return false;
        }

        public boolean addSubBlocks(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
            return false;
        }

        public Indent getTokenIndent(XmlToken token, CssCodeStyleSettings settings, IElementType type) {
            if (this.isComment(token.getTokenType()) && !(type instanceof IFileElementType) && !(type instanceof CssStyleSheetElementType)) {
                if (this.isLineComment(token.getTokenType()) && type == CssElementTypes.CSS_DECLARATION) {
                    return Indent.getContinuationIndent();
                }
                if (type != CssElementTypes.CSS_IMPORT_LIST && type != CssElementTypes.CSS_RULESET_LIST) {
                    return Indent.getNormalIndent();
                }
            }
            if (token.getTokenType() == CssElementTypes.CSS_RBRACE && settings.ALIGN_CLOSING_BRACE_WITH_PROPERTIES) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, CssCodeStyleSettings settings, int maxPropertyLength, List<Block> result) {
            return false;
        }

        public CssRootBlock createRootBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingExtension extension) {
            return new CssRootBlock(_node, settings, maxPropertyLength, extension);
        }

        public CssRulesetBlock createRulesetBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension, Alignment alignment) {
            return new CssRulesetBlock(_node, settings, indent, maxPropertyLength, extension, alignment);
        }

        public CssPropertyBlock createPropertyBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension, int nameLength, @Nullable Alignment alignment, Alignment childAlignment) {
            return new CssPropertyBlock(_node, settings, indent, maxPropertyLength, extension, nameLength, alignment, childAlignment);
        }

        public CssPropertyBlock createPropertyBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingExtension extension, int nameLength, @Nullable Alignment alignment, Alignment childAlignment) {
            Indent indent = PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), CssBlock.class) == null ? Indent.getNoneIndent() : Indent.getNormalIndent();
            return this.createPropertyBlock(_node, settings, indent, maxPropertyLength, extension, nameLength, alignment, childAlignment);
        }

        public CssSelectorBlock createSelectorBlock(ASTNode node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingExtension extension) {
            return new CssSelectorBlock(node, settings, Indent.getNoneIndent(), maxPropertyLength, extension);
        }

        public CssFormatterBlock createMediaBlock(ASTNode node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            return new CssMediaBlock(node, settings, indent, maxPropertyLength, extension);
        }

        public CssFormatterBlock createSupportsBlock(ASTNode node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            return new CssSupportsBlock(node, settings, indent, maxPropertyLength, extension);
        }

        public CssTermListBlock createTermListBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, int nameLength, Alignment alignment, boolean shouldIndentContent) {
            return new CssTermListBlock(_node, settings, indent, maxPropertyLength, this, nameLength, alignment, shouldIndentContent);
        }
    }

    protected static class LeafBlock
    implements ASTBlock {
        private static final ArrayList<Block> EMPTY_SUB_BLOCKS = new ArrayList();
        private final ASTNode myNode;
        private final Indent myIndent;

        public LeafBlock(ASTNode node, Indent indent) {
            this.myNode = node;
            this.myIndent = indent;
        }

        public ASTNode getNode() {
            return this.myNode;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myNode.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$LeafBlock", "getTextRange"));
            }
            return textRange;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            ArrayList<Block> arrayList = EMPTY_SUB_BLOCKS;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$LeafBlock", "getSubBlocks"));
            }
            return arrayList;
        }

        public Wrap getWrap() {
            return null;
        }

        public Indent getIndent() {
            return this.myIndent;
        }

        public Alignment getAlignment() {
            return null;
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$LeafBlock", "getSpacing"));
            }
            return null;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(this.getIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$LeafBlock", "getChildAttributes"));
            }
            return childAttributes;
        }

        public boolean isIncomplete() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    public static abstract class CssFormatterBlock
    implements ASTBlock {
        protected final ASTNode myNode;
        protected final CssCodeStyleSettings mySettings;
        private final Alignment myAlignment;
        protected final Alignment myChildAlignment;
        final Indent myIndent;
        protected List<Block> mySubBlocks;
        public final IElementType myType;
        protected final int myMaxPropertyLength;
        protected final CssFormattingExtension myExtension;

        protected CssFormatterBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension, @Nullable Alignment alignment, @Nullable Alignment childAlignment) {
            this.myNode = _node;
            this.mySettings = settings;
            this.myIndent = indent;
            this.myMaxPropertyLength = maxPropertyLength;
            this.myExtension = extension;
            this.myType = this.myNode.getElementType();
            this.myAlignment = alignment;
            this.myChildAlignment = childAlignment;
        }

        protected CssFormatterBlock(ASTNode _node, CssCodeStyleSettings settings, @Nullable Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            this(_node, settings, indent, maxPropertyLength, extension, null, null);
        }

        public CssCodeStyleSettings getSettings() {
            return this.mySettings;
        }

        public String toString() {
            return this.myNode != null ? this.myNode.getText() : super.toString();
        }

        public boolean shouldIndentContent() {
            return false;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myNode.getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFormatterBlock", "getTextRange"));
            }
            return textRange;
        }

        public ASTNode getNode() {
            return this.myNode;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            if (this.mySubBlocks == null) {
                this.mySubBlocks = new ArrayList<Block>(0);
                Alignment alignment = this.mySettings.VALUE_ALIGNMENT == 2 || this.mySettings.VALUE_ALIGNMENT == 1 ? Alignment.createAlignment((boolean)true) : null;
                this.myNode.getPsi().acceptChildren((PsiElementVisitor)new CssFormattingElementVisitor(this.mySubBlocks, this.mySettings, this.myMaxPropertyLength, this.myExtension, alignment, this.myChildAlignment, this.myType, this.shouldIndentContent()));
            }
            List<Block> list = this.mySubBlocks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFormatterBlock", "getSubBlocks"));
            }
            return list;
        }

        protected Spacing getSpacingBeforeLBrace() {
            CssCodeStyleSettings settings = this.getSettings();
            int linefeeds = settings.BRACE_PLACEMENT == 1 ? 1 : 0;
            int spaces = settings.SPACE_BEFORE_OPENING_BRACE ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)linefeeds, (boolean)false, (int)0);
        }

        @Nullable
        public Wrap getWrap() {
            return null;
        }

        @Nullable
        public Indent getIndent() {
            return this.myIndent;
        }

        @Nullable
        public Alignment getAlignment() {
            return this.myAlignment;
        }

        public boolean isIncomplete() {
            return false;
        }

        public boolean isLeaf() {
            return this.myNode instanceof LeafElement;
        }
    }

    public static class CssRootBlock
    extends CssFormatterBlock {
        public CssRootBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, null, maxPropertyLength, extension);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRootBlock", "getSpacing"));
            }
            if (child1 == null) {
                return null;
            }
            if (child1 instanceof ASTBlock && child2 instanceof ASTBlock) {
                ASTNode node1 = ((ASTBlock)child1).getNode();
                ASTNode node2 = ((ASTBlock)child2).getNode();
                IElementType type1 = node1.getElementType();
                IElementType type2 = node2.getElementType();
                ASTNode parentNode = node1.getTreeParent();
                if (type1 == CssElementTypes.CSS_BAD_AT_RULE) {
                    return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)1);
                }
                IElementType parentType = null;
                if (parentNode != null) {
                    parentType = parentNode.getElementType();
                }
                if (parentType == CssElementTypes.CSS_NAMESPACE) {
                    if (type2 == CssElementTypes.CSS_NAMESPACE_SYM) {
                        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)1);
                    }
                    if (type1 == CssElementTypes.CSS_IDENT || type2 == CssElementTypes.CSS_IDENT || type2 == CssElementTypes.CSS_STRING) {
                        return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
                    }
                    if (type2 == CssElementTypes.CSS_SEMICOLON) {
                        return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                    }
                }
                if (this.myExtension.isLineComment(type1)) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)1);
                }
                if (!(child1 instanceof CssRulesetBlock) && this.myExtension.isComment(type2) && node2.getText().indexOf(10) == -1) {
                    return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)1);
                }
            }
            if (child1 instanceof CssPropertyBlock || child1 instanceof CssSimpleBlock) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)1);
            }
            int minLineFeeds = this.getSettings().BLANK_LINES_BETWEEN_BLOCKS + 1;
            return Spacing.createSpacing((int)2, (int)2, (int)minLineFeeds, (boolean)true, (int)(minLineFeeds - 1));
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            Block prevBlock;
            if (newChildIndex != 0 && (prevBlock = this.getSubBlocks().get(newChildIndex - 1)) instanceof CssRulesetBlock) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), prevBlock.getAlignment());
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRootBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRootBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    static class NamespaceListBlock
    extends ImportListBlock {
        NamespaceListBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, maxPropertyLength, extension);
        }
    }

    static class ImportListBlock
    extends CssFormatterBlock {
        ImportListBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, Indent.getNoneIndent(), maxPropertyLength, extension);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$ImportListBlock", "getSpacing"));
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock2.myType == CssElementTypes.CSS_SEMICOLON) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)false, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$ImportListBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    public static class CssTermListBlock
    extends CssPropertyBlock {
        private final boolean myShouldIndentContent;

        public CssTermListBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension, int nameLength, Alignment alignment, boolean shouldIndentContent) {
            super(_node, settings, indent, maxPropertyLength, extension, nameLength, alignment, null);
            this.myShouldIndentContent = shouldIndentContent;
        }

        @Override
        public boolean shouldIndentContent() {
            return this.myShouldIndentContent;
        }

        @Override
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssTermListBlock", "getSpacing"));
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock.myType == CssElementTypes.CSS_COLON || formatterBlock2.myType == CssElementTypes.CSS_COLON || formatterBlock.myType == CssElementTypes.CSS_EQ || formatterBlock2.myType == CssElementTypes.CSS_EQ || formatterBlock.myType == CssElementTypes.CSS_PERIOD || formatterBlock2.myType == CssElementTypes.CSS_PERIOD) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_SLASH || formatterBlock2.myType == CssElementTypes.CSS_SLASH || formatterBlock.myNode instanceof OuterLanguageElement || formatterBlock2.myNode instanceof OuterLanguageElement) {
                return Spacing.getReadOnlySpacing();
            }
            return super.getSpacing(child1, child2);
        }
    }

    public static class CssMediaBlock
    extends CssRulesetBlock {
        CssMediaBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension, null);
        }

        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_MEDIA_SYM;
        }

        @Override
        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssMediaBlock", "getSpacing"));
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock2.myType == CssElementTypes.CSS_LBRACE) {
                return this.getSpacingBeforeLBrace();
            }
            if (formatterBlock.myType == this.getAtKeywordElementType()) {
                return formatterBlock2.myType == CssElementTypes.CSS_DECLARATION || formatterBlock2 instanceof CssRulesetBlock ? Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)1) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_COMMA && formatterBlock2.myType == CssElementTypes.CSS_IDENT) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_LBRACE) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)1);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_RBRACE) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)1);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_DECLARATION && formatterBlock.myType == CssElementTypes.CSS_SEMICOLON) {
                return Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)1);
            }
            if (this.myExtension.isComment(formatterBlock.myType)) {
                return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_RULESET || formatterBlock.myType == CssElementTypes.CSS_PAGE) {
                int minLineFeeds = this.getSettings().BLANK_LINES_BETWEEN_BLOCKS + 1;
                return Spacing.createSpacing((int)2, (int)2, (int)minLineFeeds, (boolean)true, (int)(minLineFeeds - 1));
            }
            return null;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            Block prevBlock;
            if (newChildIndex != 0 && (prevBlock = this.getSubBlocks().get(newChildIndex - 1)) instanceof CssRulesetBlock) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), prevBlock.getAlignment());
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssMediaBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssMediaBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    static class CssPageBlock
    extends CssMediaBlock {
        CssPageBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_PAGE_SYM;
        }

        @Override
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssPageBlock", "getSpacing"));
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock.myType == CssElementTypes.CSS_COLON && formatterBlock2.myType == CssElementTypes.CSS_IDENT) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return super.getSpacing(child1, child2);
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssPageBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    static class CssSupportsBlock
    extends CssMediaBlock {
        CssSupportsBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_SUPPORTS_SYM;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            PsiElement elementBefore;
            Block prevSubBlock;
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex - 1 < subBlocks.size() && (prevSubBlock = subBlocks.get(newChildIndex - 1)) instanceof CssFormatterBlock && (elementBefore = ((CssFormatterBlock)prevSubBlock).myNode.getPsi()) != null && elementBefore.getParent() instanceof CssSupportsCondition) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSupportsBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSupportsBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    static class CssViewPortBlock
    extends CssMediaBlock {
        CssViewPortBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_VIEWPORT_SYM;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssViewPortBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    static class CssFontFaceBlock
    extends CssMediaBlock {
        CssFontFaceBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_FONTFACE_SYM;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssFontFaceBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    static class CssBadAtRuleBlock
    extends CssMediaBlock {
        CssBadAtRuleBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension);
        }

        @Override
        protected IElementType getAtKeywordElementType() {
            return CssElementTypes.CSS_ATKEYWORD;
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssBadAtRuleBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    public static class CssRulesetBlock
    extends CssFormatterBlock {
        public CssRulesetBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension, @Nullable Alignment alignment) {
            super(_node, settings, indent, maxPropertyLength, extension, alignment, null);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRulesetBlock", "getSpacing"));
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            if (formatterBlock2.myType == CssElementTypes.CSS_COLON) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_RULESET || formatterBlock.myType == CssElementTypes.CSS_RULESET) {
                return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)1);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_SEMICOLON || formatterBlock2.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (!(child1 instanceof CssRulesetBlock) && this.myExtension.isComment(formatterBlock2.myType) && formatterBlock2.myNode.getText().indexOf(10) == -1) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)1);
            }
            if (this.myExtension.isLineComment(formatterBlock.myType)) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)1);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_LBRACE || formatterBlock.myType == CssElementTypes.CSS_SEMICOLON || this.myExtension.isComment(formatterBlock.myType) || formatterBlock2.myType == CssElementTypes.CSS_RBRACE || formatterBlock instanceof CssPropertyBlock && formatterBlock2 instanceof CssPropertyBlock) {
                return this.getSettings().KEEP_SINGLE_LINE_BLOCKS ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0) : Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)1);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_LBRACE) {
                return this.getSpacingBeforeLBrace();
            }
            if (formatterBlock2.myType == XmlTokenType.XML_COMMENT_CHARACTERS || formatterBlock2.myType == XmlTokenType.XML_COMMENT_START) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_LPAREN || formatterBlock2.myType == CssElementTypes.CSS_LPAREN || formatterBlock2.myType == CssElementTypes.CSS_RPAREN || formatterBlock.myType == CssElementTypes.CSS_RPAREN && formatterBlock2.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock instanceof CssPropertyBlock && formatterBlock2.getNode() instanceof OuterLanguageElement) {
                CssTermList value;
                PsiElement psi = formatterBlock.getNode().getPsi();
                CssCodeStyleSettings settings = this.getSettings();
                if (psi instanceof CssDeclaration && ((value = ((CssDeclaration)psi).getValue()) == null || value.getTextLength() == 0)) {
                    return settings.SPACE_AFTER_COLON ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0) : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                }
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            if ((formatterBlock instanceof CssSimpleBlock || formatterBlock instanceof CssSelectorBlock) && formatterBlock2.getNode() instanceof OuterLanguageElement) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            PsiElement elementBefore;
            Block prevSubBlock;
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex - 1 < subBlocks.size() && (prevSubBlock = subBlocks.get(newChildIndex - 1)) instanceof CssFormatterBlock && (elementBefore = ((CssFormatterBlock)prevSubBlock).myNode.getPsi()) instanceof XmlToken && ((XmlToken)elementBefore).getTokenType() == CssElementTypes.CSS_COMMA) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRulesetBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssRulesetBlock", "getChildAttributes"));
            }
            return childAttributes;
        }

        @Override
        public boolean shouldIndentContent() {
            return true;
        }
    }

    public static class CssPropertyBlock
    extends CssFormatterBlock {
        private final int myNameLength;

        public CssPropertyBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension, int nameLength, Alignment alignment, @Nullable Alignment childAlignment) {
            super(_node, settings, indent, maxPropertyLength, extension, alignment, childAlignment);
            this.myNameLength = nameLength;
        }

        @Override
        public boolean shouldIndentContent() {
            return true;
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssPropertyBlock", "getSpacing"));
            }
            if (!(child1 instanceof CssFormatterBlock) || !(child2 instanceof CssFormatterBlock)) {
                return null;
            }
            CssFormatterBlock formatterBlock = (CssFormatterBlock)child1;
            CssFormatterBlock formatterBlock2 = (CssFormatterBlock)child2;
            CssCodeStyleSettings settings = this.getSettings();
            if (settings.VALUE_ALIGNMENT == 1 && formatterBlock2.myType == CssElementTypes.CSS_COLON && this.myNameLength != -1) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (this.myExtension.isLineComment(formatterBlock.myType)) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)1);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_LPAREN || formatterBlock2.myType == CssElementTypes.CSS_RPAREN) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_LPAREN && this.getNode().getElementType() == CssElementTypes.CSS_IMPORT) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            String textOfFormatterBlock2 = formatterBlock2.myNode.getText().toLowerCase(Locale.US);
            if (formatterBlock.myType == CssElementTypes.CSS_MINUS || formatterBlock.myType == CssElementTypes.CSS_ASTERISK || formatterBlock.myType == CssElementTypes.CSS_PLUS && formatterBlock2.myType == CssElementTypes.CSS_NUMBER || formatterBlock.myType == CssElementTypes.CSS_PLUS && formatterBlock2.myType == CssElementTypes.CSS_COLON || formatterBlock.myType == CssElementTypes.CSS_IDENT && formatterBlock2.myType == CssElementTypes.CSS_PLUS || formatterBlock.myType == CssElementTypes.CSS_PLUS && formatterBlock2.myType == CssElementTypes.CSS_IDENT || formatterBlock2.myType == CssElementTypes.CSS_COLON || formatterBlock2.myType == CssElementTypes.CSS_SEMICOLON || formatterBlock2.myType == CssElementTypes.CSS_COMMA || formatterBlock.myType != CssElementTypes.CSS_COMMA && formatterBlock2.myType == CssElementTypes.CSS_PERCENT || (formatterBlock.myType == CssElementTypes.CSS_NUMBER || formatterBlock.myType == XmlTokenType.XML_COMMENT_START) && formatterBlock2.myType == CssElementTypes.CSS_IDENT && (CssTermImpl.getTypeBySuffix(textOfFormatterBlock2) != CssTermType.UNKNOWN || "n".equals(textOfFormatterBlock2) || "x".equals(textOfFormatterBlock2) || TimeUserLookup.isTimeSuffix(textOfFormatterBlock2))) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock2.myType == CssElementTypes.CSS_LPAREN) {
                return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_COLON) {
                return settings.SPACE_AFTER_COLON ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0) : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssPropertyBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    public static class CssSelectorBlock
    extends CssFormatterBlock {
        public CssSelectorBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, indent, maxPropertyLength, extension);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSelectorBlock", "getSpacing"));
            }
            if (child2 instanceof CssFormatterBlock && ((CssFormatterBlock)child2).myType == CssElementTypes.CSS_PERCENT) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSelectorBlock", "getChildAttributes"));
            }
            return childAttributes;
        }

        @Override
        public String toString() {
            return this.myNode.getText();
        }
    }

    public static class CssOperationBlock
    extends CssFormatterBlock {
        public CssOperationBlock(ASTNode _node, CssCodeStyleSettings settings, int maxPropertyLength, CssFormattingExtension extension) {
            super(_node, settings, Indent.getNoneIndent(), maxPropertyLength, extension);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssOperationBlock", "getSpacing"));
            }
            if (this.myNode.getElementType() == CssElementTypes.CSS_BINARY_OPERATION && (child1 instanceof CssFormatterBlock && CssMathParser.OPERATORS.contains(((CssFormatterBlock)child1).myType) || child2 instanceof CssFormatterBlock && CssMathParser.OPERATORS.contains(((CssFormatterBlock)child2).myType))) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssOperationBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
    }

    protected static class CssSimpleBlock
    extends CssFormatterBlock {
        public CssSimpleBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension) {
            this(_node, settings, indent, maxPropertyLength, extension, null);
        }

        public CssSimpleBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingExtension extension, @Nullable Alignment alignment) {
            super(_node, settings, indent, maxPropertyLength, extension, alignment, null);
        }

        @Nullable
        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSimpleBlock", "getSpacing"));
            }
            return null;
        }

        @Override
        @NotNull
        public List<Block> getSubBlocks() {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSimpleBlock", "getSubBlocks"));
            }
            return list;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/editor/CssFormattingModelBuilder$CssSimpleBlock", "getChildAttributes"));
            }
            return childAttributes;
        }

        @Override
        public String toString() {
            return this.myNode.getText();
        }
    }
}

