/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.css.util.CssConstants;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.value.CssNullValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.util.completion.CssSuffixUserLookup;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssReferencePropertyValue;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCssPropertyDescriptor
implements CssPropertyDescriptor {
    @NonNls
    private static final String EMPTY_STRING = "";
    private Object[] myCachedVariants;

    public boolean isInherited() {
        return this.getInherited();
    }

    @NotNull
    public CssMediaGroup[] getMediaGroups() {
        if (CssConstants.DEFAULT_MEDIA_GROUPS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getMediaGroups"));
        }
        return CssConstants.DEFAULT_MEDIA_GROUPS;
    }

    @Nullable
    public String getInitialValue() {
        return EMPTY_STRING;
    }

    @NotNull
    public String getPercentageValue() {
        if (EMPTY_STRING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getPercentageValue"));
        }
        return EMPTY_STRING;
    }

    @NotNull
    public String getAppliesToValue() {
        if (EMPTY_STRING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getAppliesToValue"));
        }
        return EMPTY_STRING;
    }

    @NotNull
    public String getDescription() {
        if (EMPTY_STRING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getDescription"));
        }
        return EMPTY_STRING;
    }

    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "isValidValue"));
        }
        return this.getValue().isValueBelongs(element);
    }

    @NotNull
    public BrowserVersion[] getBrowsers() {
        if (BrowserVersion.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getBrowsers"));
        }
        return BrowserVersion.EMPTY_ARRAY;
    }

    public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "isAllowedInContextType"));
        }
        return true;
    }

    @NotNull
    public String getId() {
        String string = this.getPropertyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getId"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public CssElementDescriptor.CssVersion getCssVersion() {
        CssElementDescriptor.CssVersion cssVersion = CssElementDescriptor.CssVersion.UNKNOWN;
        if (cssVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getCssVersion"));
        }
        return cssVersion;
    }

    @NotNull
    public abstract CssPropertyValue getValue();

    @NotNull
    public PsiElement[] getDeclarations(PsiElement context) {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getDeclarations"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean is4ValueProperty() {
        final boolean[] result = new boolean[]{false};
        this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive(){

            public void visitValue(@NotNull CssTableValue value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$1", "visitValue"));
                }
                if (4 == value.getMaxCount()) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    public CssPropertyValue getReferencedPropertyValue(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getReferencedPropertyValue"));
        }
        final CssPropertyValue[] result = new CssPropertyValue[]{null};
        this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive<CssPropertyValueImpl>(){

            public void visitValue(@NotNull CssPropertyValueImpl value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$2", "visitValue"));
                }
                String refName = value.getRefName();
                if (refName != null && refName.equals(name)) {
                    result[0] = value;
                }
            }
        });
        return result[0];
    }

    public boolean allowsIntegerWithoutSuffix() {
        Object[] variants = this.getAllVariants();
        boolean containsValuesWithSuffix = false;
        for (Object each : variants) {
            if (each instanceof CssSuffixUserLookup) {
                containsValuesWithSuffix = true;
                continue;
            }
            if (!(each instanceof CssUserLookupBase)) continue;
            if (StringUtil.isNotEmpty((String)((CssUserLookupBase)each).getSuffix())) {
                containsValuesWithSuffix = true;
                continue;
            }
            return true;
        }
        return !containsValuesWithSuffix;
    }

    public Object[] getAllVariants() {
        if (this.myCachedVariants == null) {
            final ArrayList result = new ArrayList();
            this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor.Recursive(){

                void visitValue(@NotNull CssTableValue value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$3", "visitValue"));
                    }
                    Object v = value.getValue();
                    if (!value.isGroup() && v != null && !result.contains(v)) {
                        result.add(v);
                    }
                }
            });
            this.myCachedVariants = ArrayUtil.toObjectArray(result);
        }
        return this.myCachedVariants;
    }

    @Nullable
    public String[] getRefNames() {
        final HashSet result = new HashSet();
        this.getValue().accept((CssTableValueVisitor)new CssTableValueVisitor<CssPropertyValueImpl>(){

            public void visit(@NotNull CssPropertyValueImpl value) {
                String refName;
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$4", "visit"));
                }
                if (value.isGroup() && !(value instanceof CssReferencePropertyValue)) {
                    for (CssPropertyValue each : value.getChildren()) {
                        each.accept((CssTableValueVisitor)this);
                    }
                }
                if (value instanceof CssReferencePropertyValue && (refName = value.getRefName()) != null) {
                    result.add(refName);
                }
            }
        });
        return result.isEmpty() ? null : ArrayUtil.toStringArray(result);
    }

    @NotNull
    public Object[] getVariants(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getVariants"));
        }
        List<PsiElement> elements = AbstractCssPropertyDescriptor.buildContextPath(contextElement, false);
        List<CssPropertyValue> variants = Collections.singletonList(this.getValue());
        CssCompletionContext c = null;
        int currentElementOffset = contextElement.getTextOffset();
        PsiElement position = contextElement.getContainingFile().getOriginalFile().findElementAt(currentElementOffset);
        if (position == null && currentElementOffset > 0) {
            position = contextElement.getContainingFile().getOriginalFile().findElementAt(currentElementOffset - 1);
        }
        if (position == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        for (PsiElement element : elements) {
            ArrayList<CssPropertyValue> tempVariants = new ArrayList<CssPropertyValue>();
            boolean current = element == position.getParent();
            c = CssCompletionContext.createContext((PsiElement)element, c, (boolean)current);
            if (!this.getValue().isCompleted(c)) {
                for (CssPropertyValue each : variants) {
                    tempVariants.addAll(each.getVariants(c, contextElement));
                }
                if (tempVariants.isEmpty()) {
                    tempVariants.addAll(this.getValue().getVariants(c, contextElement));
                }
            }
            variants = tempVariants;
            if (!current) continue;
            break;
        }
        Object[] objectArray = AbstractCssPropertyDescriptor.gatherVariants(contextElement, variants.toArray(new CssPropertyValueImpl[variants.size()]));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getVariants"));
        }
        return objectArray;
    }

    protected static Object[] gatherVariants(final PsiElement context, CssPropertyValueImpl ... variants) {
        final HashSet result = new HashSet();
        CssTableValueVisitor<CssPropertyValueImpl> visitor = new CssTableValueVisitor<CssPropertyValueImpl>(){

            public void visit(@NotNull CssPropertyValueImpl value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor$5", "visit"));
                }
                if (value.isComplete()) {
                    if (value instanceof CssReferencePropertyValue) {
                        CssPropertyDescriptor descriptor = ((CssReferencePropertyValue)value).getRefDescriptor();
                        result.addAll(Arrays.asList(descriptor.getVariants(context)));
                    } else if (value.isGroup()) {
                        if (!AbstractCssPropertyDescriptor.addDynamicVariants(value, result, context)) {
                            for (CssPropertyValue each : value.getChildren()) {
                                each.accept((CssTableValueVisitor)this);
                            }
                        }
                    } else if (!AbstractCssPropertyDescriptor.addDynamicVariants(value, result, context) && value.getValue() != null) {
                        result.add(value.getValue());
                    }
                }
            }
        };
        for (CssPropertyValueImpl variant : variants) {
            variant.accept((CssTableValueVisitor)visitor);
        }
        return ArrayUtil.toObjectArray(result);
    }

    private static boolean addDynamicVariants(CssPropertyValueImpl value, Set<Object> result, PsiElement context) {
        List<? extends CssPropertyValue> dynamicVariants = value.getDynamicVariants(context);
        for (CssPropertyValue cssPropertyValue : dynamicVariants) {
            result.add(cssPropertyValue.getValue());
        }
        return !dynamicVariants.isEmpty();
    }

    protected static List<PsiElement> buildContextPath(@NotNull PsiElement context, boolean strict) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "buildContextPath"));
        }
        PsiElement psi = context.getParent() instanceof CssTerm ? context.getParent() : context;
        PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)psi);
        CssTermList termList = AbstractCssPropertyDescriptor.extractCssTermList(context);
        LinkedList<PsiElement> result = new LinkedList<PsiElement>();
        if (termList != null) {
            for (PsiElement each : termList.getChildren()) {
                if (!(each instanceof CssTerm) || originalElement == each) continue;
                result.add(each);
            }
        }
        if (!strict) {
            result.add(null);
        }
        return result;
    }

    @Nullable
    protected static CssTermList extractCssTermList(PsiElement context) {
        PsiElement originalElement = PsiUtilCore.getOriginalElement((PsiElement)context, PsiElement.class);
        PsiElement declaration = PsiTreeUtil.getParentOfType((PsiElement)originalElement, CssDeclaration.class, (boolean)false);
        if (declaration == null) {
            while (originalElement != null && !(originalElement instanceof CssDeclaration)) {
                originalElement = originalElement.getPrevSibling();
            }
            declaration = originalElement;
        }
        if (declaration != null) {
            return (CssTermList)PsiTreeUtil.getChildOfType((PsiElement)declaration, CssTermList.class);
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Css.Property;
    }

    public String toString() {
        return this.getPropertyName();
    }

    @NotNull
    public String[] expand(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "expand"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "expand"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public PsiElement[] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
        if (decl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decl", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getShorthandPsiValue"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getShorthandPsiValue"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public CssPropertyInfo[] getInfos() {
        if (CssPropertyInfo.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getInfos"));
        }
        return CssPropertyInfo.EMPTY_ARRAY;
    }

    @NotNull
    public String toCanonicalName(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "toCanonicalName"));
        }
        String string = propertyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "toCanonicalName"));
        }
        return string;
    }

    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        return null;
    }

    @NotNull
    public String getElementTypeName() {
        String string = CssBundle.message((String)"css.property.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getElementTypeName"));
        }
        return string;
    }

    @Nullable
    public String getSpecificationUrl() {
        return null;
    }

    @NotNull
    public CssContextType[] getAllowedContextTypes() {
        if (CssContextType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getAllowedContextTypes"));
        }
        return CssContextType.EMPTY_ARRAY;
    }

    @NotNull
    public CssValueDescriptor getValueDescriptor() {
        CssNullValue cssNullValue = new CssNullValue();
        if (cssNullValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/AbstractCssPropertyDescriptor", "getValueDescriptor"));
        }
        return cssNullValue;
    }
}

