/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class RemoveUnusedSymbolIntentionAction
implements LocalQuickFix {
    private final String myElement;

    public RemoveUnusedSymbolIntentionAction(@NotNull String element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/RemoveUnusedSymbolIntentionAction", "<init>"));
        }
        this.myElement = element;
    }

    @NotNull
    public String getName() {
        String string = CssBundle.message((String)"css.inspections.unused.symbol.intention", (Object[])new Object[]{this.myElement});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/RemoveUnusedSymbolIntentionAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/RemoveUnusedSymbolIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/RemoveUnusedSymbolIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/RemoveUnusedSymbolIntentionAction", "applyFix"));
        }
        final CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), CssRuleset.class);
        if (ruleset != null && ruleset.isValid()) {
            new WriteCommandAction(project, new PsiFile[]{ruleset.getContainingFile()}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/inspections/RemoveUnusedSymbolIntentionAction$1", "run"));
                    }
                    ruleset.delete();
                }
            }.execute();
        }
    }
}

