/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.reference.TemplateCssClassOrIdReference;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssResolveUtil {
    private CssResolveUtil() {
    }

    @NotNull
    public static List<String> consumeClassNames(@NotNull String attributeValue, @NotNull PsiElement element, @Nullable PairConsumer<String, TextRange> consumer) {
        XmlAttribute attr;
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeValue", "com/intellij/psi/css/util/CssResolveUtil", "consumeClassNames"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/util/CssResolveUtil", "consumeClassNames"));
        }
        String delimiters = " \t";
        if (element.getParent() instanceof XmlAttribute && (attr = (XmlAttribute)element.getParent()).getName().endsWith("Classes")) {
            delimiters = " \t,";
        }
        StringTokenizer st = new StringTokenizer(attributeValue, delimiters);
        ArrayList<String> names = new ArrayList<String>();
        int offset = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            names.add(token);
            offset = attributeValue.indexOf(token, offset);
            if (consumer != null) {
                consumer.consume((Object)token, (Object)TextRange.create((int)offset, (int)(offset + token.length())));
            }
            offset += token.length();
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssResolveUtil", "consumeClassNames"));
        }
        return arrayList;
    }

    public static boolean checkTagForMatching(@NotNull XmlTag tag, String attrNameToCheck, @Nullable String selectorName, @NotNull CssResolver resolver) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/util/CssResolveUtil", "checkTagForMatching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/util/CssResolveUtil", "checkTagForMatching"));
        }
        if (selectorName == null) {
            return false;
        }
        if (!resolver.isCareAboutClasses()) {
            return true;
        }
        boolean caseInsensitive = tag instanceof HtmlTag;
        String attributeValue = tag.getAttributeValue(attrNameToCheck);
        if (attributeValue == null) {
            for (String work : CssResolveUtil.findAppropriateClassOrIdAttributeValues(tag, attrNameToCheck, resolver)) {
                if (!CssResolveUtil.containsWord(caseInsensitive, work, selectorName)) continue;
                return true;
            }
        } else {
            return CssResolveUtil.containsWord(caseInsensitive, attributeValue, selectorName);
        }
        return false;
    }

    private static boolean containsWord(boolean caseInsensitive, String text, String word) {
        for (String styleName : StringUtil.tokenize((String)text, (String)"\t ")) {
            if (!(caseInsensitive ? styleName.equalsIgnoreCase(word) : styleName.equals(word))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<String> findAppropriateClassOrIdAttributeValues(@NotNull XmlTag tag, String attrNameToCheck, @NotNull CssResolver resolver) {
        XmlAttribute attrValue;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/psi/css/util/CssResolveUtil", "findAppropriateClassOrIdAttributeValues"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/psi/css/util/CssResolveUtil", "findAppropriateClassOrIdAttributeValues"));
        }
        String attrName = resolver.getResolvedAttrName();
        XmlAttribute xmlAttribute = attrValue = attrName != null ? tag.getAttribute(attrName) : null;
        if (attrValue != null) {
            XmlAttributeValue value = attrValue.getValueElement();
            List<String> list = value != null ? CssResolveUtil.consumeClassNames(value.getValue(), (PsiElement)value, null) : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssResolveUtil", "findAppropriateClassOrIdAttributeValues"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (XmlAttribute attribute : tag.getAttributes()) {
            String value;
            Object[] references;
            XmlAttributeValue xmlAttributeValue;
            if (!StringUtil.containsIgnoreCase((String)attribute.getName(), (String)attrNameToCheck) || (xmlAttributeValue = attribute.getValueElement()) == null || ContainerUtil.findInstance((Object[])(references = xmlAttributeValue.getReferences()), TemplateCssClassOrIdReference.class) == null || (value = attribute.getValue()) == null) continue;
            result.addAll(CssResolveUtil.consumeClassNames(value, (PsiElement)xmlAttributeValue, null));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/util/CssResolveUtil", "findAppropriateClassOrIdAttributeValues"));
        }
        return arrayList;
    }
}

