/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EndpointValueConverter
extends SpringBeanResolveConverter
implements GenericDomValueConvertersRegistry.Provider,
Condition<Pair<PsiType, GenericDomValue>> {
    @NotNull
    public List<PsiClassType> getRequiredClasses(ConvertContext context) {
        JavaPsiFacade facade;
        PsiClass payloadEndpointClass;
        Module module = context.getModule();
        if (module != null && (payloadEndpointClass = (facade = JavaPsiFacade.getInstance((Project)module.getProject())).findClass("org.springframework.ws.server.endpoint.PayloadEndpoint", GlobalSearchScope.allScope((Project)module.getProject()))) != null) {
            List<PsiClassType> list = Collections.singletonList(facade.getElementFactory().createType(payloadEndpointClass));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/EndpointValueConverter", "getRequiredClasses"));
            }
            return list;
        }
        List list = super.getRequiredClasses(context);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/EndpointValueConverter", "getRequiredClasses"));
        }
        return list;
    }

    public Converter getConverter() {
        return this;
    }

    public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
        return this;
    }

    public boolean value(Pair<PsiType, GenericDomValue> pair) {
        GenericDomValue value = (GenericDomValue)pair.getSecond();
        if (value instanceof Prop) {
            return SpringWebServicesUtil.isEndpointMappingProperty(value);
        }
        return false;
    }
}

