/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.inspections;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.gutter.DomElementListCellRenderer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.webflow.config.model.xml.version1_0.Registry;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowRegistry;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowConfigUtil;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.spring.webflow.util.WebflowVersionDetector;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebflowSetupInspection
extends BasicDomElementsInspection<Flow> {
    public WebflowSetupInspection() {
        super(Flow.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Flow> domFileElement, DomElementAnnotationHolder holder) {
        ArrayList<Object> configurationBeans;
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Flow flow = (Flow)domFileElement.getRootElement();
        XmlFile psiElement = WebflowUtil.resolveFlow(flow);
        if (psiElement != null) {
            return;
        }
        if (WebflowVersionDetector.detect(module).isAtLeast(WebflowVersion.Webflow_2_0)) {
            configurationBeans = new ArrayList<FlowRegistry>(WebflowConfigUtil.getFlowRegistries(module));
        } else {
            configurationBeans = new ArrayList<Registry>(WebflowConfigUtil.getFlowRegistries10(module));
            List<SpringProperty> additionalConfigProperties = WebflowConfigUtil.getAdditionalConfigProperties(module);
            configurationBeans.addAll(ContainerUtil.map(additionalConfigProperties, SpringElementsHolder::getBean));
        }
        if (configurationBeans.isEmpty()) {
            holder.createProblem(domFileElement, WebflowBundle.message("setup.inspection.no.flow.registry", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        holder.createProblem(domFileElement, WebflowBundle.message("setup.inspection.flow.not.configured", new Object[0]), new LocalQuickFix[]{new OpenFlowRegistryFix(configurationBeans)});
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("WebflowSetupInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/inspections/WebflowSetupInspection", "getShortName"));
        }
        return "WebflowSetupInspection";
    }

    private static class OpenFlowRegistryFix
    implements LocalQuickFix {
        private final List<DomSpringBean> myConfigurations;

        private OpenFlowRegistryFix(List<DomSpringBean> configurationBeans) {
            this.myConfigurations = configurationBeans;
        }

        @NotNull
        public String getName() {
            String string = WebflowBundle.message("setup.inspection.quickfix.open.flow.registry", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/inspections/WebflowSetupInspection$OpenFlowRegistryFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/inspections/WebflowSetupInspection$OpenFlowRegistryFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/webflow/inspections/WebflowSetupInspection$OpenFlowRegistryFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/webflow/inspections/WebflowSetupInspection$OpenFlowRegistryFix", "applyFix"));
            }
            if (this.myConfigurations.size() == 1) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)this.myConfigurations.get(0).getXmlTag());
                return;
            }
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])ContainerUtil.map2Array(this.myConfigurations, PsiElement.class, registry -> {
                PsiElement identifyingPsiElement = registry.getIdentifyingPsiElement();
                return identifyingPsiElement != null ? identifyingPsiElement : registry.getXmlTag();
            })), (PsiElementListCellRenderer)new DomElementListCellRenderer(""), (String)WebflowBundle.message("setup.inspection.quickfix.open.flow.registry.popup.title", new Object[0]));
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }
}

