/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.SpringInspectionsRegistry;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SpringBootAdditionalFilesContributor
extends SpringInspectionsRegistry.AdditionalFilesContributor {
    @NotNull
    protected abstract Set<VirtualFilePointer> getRelevantFileCandidates(SpringFileSet var1);

    protected abstract boolean isRelevantFile(PsiFile var1);

    public Collection<VirtualFile> getAdditionalFilesToProcess(Project project, CompileContext context) {
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
            return Collections.emptyList();
        }
        HashSet additionalFiles = new HashSet();
        for (Module module : context.getCompileScope().getAffectedModules()) {
            SpringFacet facet = SpringFacet.getInstance((Module)module);
            if (facet == null) continue;
            Set sets = SpringFileSetService.getInstance().getAllSets(facet);
            for (SpringFileSet fileSet : sets) {
                Set<VirtualFilePointer> candidates = this.getRelevantFileCandidates(fileSet);
                for (VirtualFilePointer filePointer : candidates) {
                    PsiFile psiFile;
                    VirtualFile file = filePointer.getFile();
                    if (file == null || !this.isRelevantFile(psiFile = PsiManager.getInstance((Project)project).findFile(file))) continue;
                    additionalFiles.add(file);
                }
            }
        }
        return additionalFiles;
    }

    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile psiFile) {
        if (!this.isRelevantFile(psiFile)) {
            return super.checkAdditionally(psiFile);
        }
        InspectionManager manager = InspectionManager.getInstance((Project)psiFile.getProject());
        LinkedHashMap map = new LinkedHashMap();
        for (Pair pair : DefaultHighlightVisitorBasedInspection.runGeneralHighlighting((PsiFile)psiFile, (boolean)true, (boolean)true, (boolean)false)) {
            HighlightInfo info = (HighlightInfo)pair.second;
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)pair.first, new TextRange(info.startOffset, info.endOffset), info.getDescription(), HighlightInfo.convertType((HighlightInfoType)info.type), false, new LocalQuickFix[0]);
            map.put((Object)descriptor, (Object)(info.type == HighlightInfoType.ERROR ? HighlightDisplayLevel.ERROR : HighlightDisplayLevel.WARNING));
        }
        return map;
    }
}

