/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyLookupElementBuilder;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyImpl
implements SpringBootApplicationMetaConfigKey {
    private final PsiElement myDeclaration;
    private final String myName;
    private final SpringBootApplicationMetaConfigKey.DescriptionText myDescriptionText;
    private final String myDefaultValue;
    private final SpringBootApplicationMetaConfigKey.Deprecation myDeprecation;
    private final PsiType myType;
    private final SpringBootApplicationMetaConfigKey.ItemHint myItemHint;
    private final SpringBootApplicationMetaConfigKey.ItemHint myKeyItemHint;
    private final SpringBootApplicationMetaConfigKey.AccessType myAccessType;
    private final PsiClass myEffectiveValueClass;
    @Nullable
    private final PsiClass myMapKeyType;
    @Nullable
    private final PsiClassType myMapValueType;
    private final Map<String, RelaxedNames> myCachedRelaxedNames;

    public SpringBootApplicationMetaConfigKeyImpl(@NotNull PsiElement declaration, @NotNull String name, @NotNull SpringBootApplicationMetaConfigKey.DescriptionText descriptionText, @Nullable String defaultValue, @NotNull SpringBootApplicationMetaConfigKey.Deprecation deprecation, @Nullable PsiType type, @NotNull SpringBootApplicationMetaConfigKey.AccessType accessType, @NotNull SpringBootApplicationMetaConfigKey.ItemHint itemHint, @NotNull SpringBootApplicationMetaConfigKey.ItemHint keyItemHint) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (descriptionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionText", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (deprecation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deprecation", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (accessType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessType", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (itemHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemHint", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        if (keyItemHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyItemHint", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "<init>"));
        }
        this.myCachedRelaxedNames = new ConcurrentFactoryMap<String, RelaxedNames>(){

            @Nullable
            protected RelaxedNames create(String key) {
                return new RelaxedNames(key);
            }
        };
        this.myDeclaration = declaration;
        assert (!name.isEmpty());
        this.myName = name;
        this.myDescriptionText = descriptionText;
        this.myDefaultValue = defaultValue;
        this.myDeprecation = deprecation;
        this.myType = type;
        this.myItemHint = itemHint;
        this.myKeyItemHint = keyItemHint;
        this.myAccessType = accessType;
        this.myMapKeyType = this.getTypeParameterPsiClass(0);
        this.myMapValueType = this.getTypeParameter(1);
        this.myEffectiveValueClass = this.calcEffectiveValueClass();
    }

    @Nullable
    private PsiClass calcEffectiveValueClass() {
        if (this.myAccessType == SpringBootApplicationMetaConfigKey.AccessType.INDEXED) {
            if (this.myType instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)this.myType;
                return PsiTypesUtil.getPsiClass((PsiType)arrayType.getComponentType());
            }
            PsiType parameter = this.getParameter(0);
            return PsiTypesUtil.getPsiClass((PsiType)parameter);
        }
        if (this.myAccessType == SpringBootApplicationMetaConfigKey.AccessType.MAP) {
            return PsiTypesUtil.getPsiClass((PsiType)this.getMapValueType());
        }
        return PsiTypesUtil.getPsiClass((PsiType)this.myType);
    }

    public LookupElementBuilder getLookupElement() {
        return this.getLookupElement(this.getName());
    }

    public LookupElementBuilder getLookupElement(String lookupString) {
        return SpringBootApplicationMetaConfigKeyLookupElementBuilder.create(this, lookupString);
    }

    public LookupElement tuneLookupElement(LookupElement lookupElement) {
        if (this.isDeprecated()) {
            return PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-1.0);
        }
        return lookupElement;
    }

    @Nullable
    private PsiClass getTypeParameterPsiClass(int index) {
        PsiType parameterType = this.getMapParameter(index);
        return PsiTypesUtil.getPsiClass((PsiType)parameterType);
    }

    @Nullable
    private PsiClassType getTypeParameter(int index) {
        PsiType parameterType = this.getMapParameter(index);
        if (!(parameterType instanceof PsiClassType)) {
            return null;
        }
        return (PsiClassType)parameterType;
    }

    @Nullable
    private PsiType getMapParameter(int index) {
        if (!this.isMapType()) {
            return null;
        }
        return this.getParameter(index);
    }

    @Nullable
    private PsiType getParameter(int index) {
        PsiType[] parameters = ((PsiClassType)this.myType).getParameters();
        if (parameters.length < index + 1) {
            return null;
        }
        return parameters[index];
    }

    @NotNull
    public PsiElement getDeclaration() {
        PsiElement psiElement = this.myDeclaration;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getDeclaration"));
        }
        return psiElement;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getName"));
        }
        return string;
    }

    public boolean isDeprecated() {
        return this.myDeprecation != SpringBootApplicationMetaConfigKey.Deprecation.NOT_DEPRECATED;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.Deprecation getDeprecation() {
        SpringBootApplicationMetaConfigKey.Deprecation deprecation = this.myDeprecation;
        if (deprecation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getDeprecation"));
        }
        return deprecation;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.DescriptionText getDescriptionText() {
        SpringBootApplicationMetaConfigKey.DescriptionText descriptionText = this.myDescriptionText;
        if (descriptionText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getDescriptionText"));
        }
        return descriptionText;
    }

    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    @Nullable
    public PsiClass getEffectiveValueClass() {
        return this.myEffectiveValueClass;
    }

    public boolean isMapType() {
        return this.myAccessType == SpringBootApplicationMetaConfigKey.AccessType.MAP;
    }

    public boolean isEnumMapType() {
        PsiClass type = this.getMapKeyType();
        return this.isMapType() && type != null && type.isEnum();
    }

    @Nullable
    public PsiClass getMapKeyType() {
        return this.myMapKeyType;
    }

    @Nullable
    public PsiClassType getMapValueType() {
        return this.myMapValueType;
    }

    public boolean isIndexedType() {
        return this.myAccessType == SpringBootApplicationMetaConfigKey.AccessType.INDEXED;
    }

    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.ItemHint getItemHint() {
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = this.myItemHint;
        if (itemHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getItemHint"));
        }
        return itemHint;
    }

    @NotNull
    public SpringBootApplicationMetaConfigKey.ItemHint getKeyItemHint() {
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = this.myKeyItemHint;
        if (itemHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "getKeyItemHint"));
        }
        return itemHint;
    }

    public boolean matches(@NotNull String configKey) {
        if (configKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "matches"));
        }
        if (!this.matchesFirstChar(configKey)) {
            return false;
        }
        if (this.myName.equalsIgnoreCase(configKey)) {
            return true;
        }
        if (this.isMapType()) {
            return this.matchesMapType(configKey);
        }
        if (this.isIndexedType()) {
            return this.matchesIndexedType(configKey);
        }
        return this.matchesRelaxed(configKey);
    }

    public boolean matchesPrefix(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "matchesPrefix"));
        }
        if (!this.matchesFirstChar(prefix)) {
            return false;
        }
        if (StringUtil.startsWith((CharSequence)this.myName, (CharSequence)prefix)) {
            return true;
        }
        List myNameSplit = StringUtil.split((String)this.myName, (String)".");
        List prefixSplit = StringUtil.split((String)prefix, (String)".");
        if (myNameSplit.size() <= prefixSplit.size()) {
            return false;
        }
        for (int i = 0; i < Math.min(myNameSplit.size() - 1, prefixSplit.size()); ++i) {
            RelaxedNames configRelax = this.myCachedRelaxedNames.get(myNameSplit.get(i));
            if (configRelax.getValues().contains(prefixSplit.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesFirstChar(@NotNull String configKey) {
        if (configKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyImpl", "matchesFirstChar"));
        }
        return !configKey.isEmpty() && StringUtil.charsEqualIgnoreCase((char)this.myName.charAt(0), (char)configKey.charAt(0));
    }

    private boolean matchesMapType(String configKey) {
        int mapKeyIndex = configKey.lastIndexOf(46);
        if (mapKeyIndex == -1) {
            return false;
        }
        String mapPropertyName = configKey.substring(0, mapKeyIndex);
        if (this.myName.equalsIgnoreCase(mapPropertyName) || this.matchesRelaxed(mapPropertyName)) {
            return true;
        }
        String multiDotKey = configKey.substring(0, StringUtil.commonPrefixLength((CharSequence)this.myName, (CharSequence)configKey));
        return this.myName.equals(multiDotKey);
    }

    private boolean matchesIndexedType(String configKey) {
        int indexKeyIndex = configKey.indexOf(91);
        String propertyName = indexKeyIndex != -1 ? configKey.substring(0, indexKeyIndex) : configKey;
        return this.myName.equalsIgnoreCase(propertyName) || this.matchesRelaxed(propertyName);
    }

    private boolean matchesRelaxed(String configKey) {
        RelaxedNames keyRelaxedNames = new RelaxedNames(configKey);
        RelaxedNames myRelaxedNames = this.myCachedRelaxedNames.get(this.myName);
        return ContainerUtil.intersects(keyRelaxedNames.getValues(), myRelaxedNames.getValues());
    }

    public String toString() {
        return "SpringBootApplicationMetaConfigKey{myName='" + this.myName + '\'' + ", myDescriptionText='" + this.myDescriptionText + '\'' + ", myDefaultValue='" + this.myDefaultValue + '\'' + ", myDeprecation=" + this.myDeprecation + ", myType=" + this.myType + ", myAccessType=" + this.myAccessType + ", myMapKeyType=" + this.myMapKeyType + ", myMapValueType=" + this.myMapValueType + ", myItemHint=" + this.myItemHint + ", myKeyItemHint=" + this.myKeyItemHint + '}';
    }
}

