/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefineLocalMetaConfigKeyFix
implements LocalQuickFix {
    private final String myKeyName;

    public DefineLocalMetaConfigKeyFix(String keyName) {
        this.myKeyName = keyName;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = "Define configuration key '" + this.myKeyName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Define configuration key" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix", "getFamilyName"));
        }
        return "Define configuration key";
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        String moduleName = module.getName();
        SpringBootAdditionalConfigUtils additionalConfigUtils = new SpringBootAdditionalConfigUtils(module);
        if (!additionalConfigUtils.hasResourceRoots()) {
            Messages.showWarningDialog((Project)project, (String)("No resources roots found in module '" + moduleName + "'"), (String)"Spring Boot");
            return;
        }
        Processor addKeyToExistingProcessor = jsonFile -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix", "lambda$applyFix$0"));
            }
            this.addKey(project, (JsonFile)jsonFile);
            return false;
        };
        if (!additionalConfigUtils.processAdditionalMetadataFiles((Processor<JsonFile>)addKeyToExistingProcessor)) {
            return;
        }
        int createNewFile = Messages.showYesNoDialog((Project)project, (String)("Could not locate META-INF/additional-spring-configuration-metadata.json in any of resources roots in module '" + module.getName() + "'." + "\n\n" + "Do you want to create new file for storing additional meta-data?"), (String)"Spring Boot", null);
        if (createNewFile == 1) {
            return;
        }
        JBList list = new JBList(additionalConfigUtils.getResourceRoots());
        list.setCellRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                VirtualFile virtualFile = (VirtualFile)value;
                this.setText(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                this.setIcon(AllIcons.Modules.ResourcesRoot);
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Select Resources Root").setItemChoosenCallback(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix", "lambda$applyFix$1"));
            }
            final VirtualFile selectedRoot = (VirtualFile)list.getSelectedValue();
            if (selectedRoot == null) {
                return;
            }
            new WriteCommandAction<Void>(project, new PsiFile[0]){

                protected void run(@NotNull Result<Void> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix$2", "run"));
                    }
                    VirtualFile metaInf = VfsUtil.createDirectoryIfMissing((VirtualFile)selectedRoot, (String)"META-INF");
                    VirtualFile addVf = metaInf.createChildData((Object)project, "additional-spring-configuration-metadata.json");
                    VfsUtil.saveText((VirtualFile)addVf, (String)"{ \"properties\": [ ] }");
                    JsonFile jsonFile = (JsonFile)PsiManager.getInstance((Project)project).findFile(addVf);
                    DefineLocalMetaConfigKeyFix.this.addKey(project, jsonFile);
                }
            }.execute().throwException();
        }).createPopup().showCenteredInCurrentWindow(project);
    }

    private void addKey(@NotNull Project project, JsonFile additionalJson) {
        boolean hasValues;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/metadata/additional/DefineLocalMetaConfigKeyFix", "addKey"));
        }
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{additionalJson.getVirtualFile()})) {
            return;
        }
        JsonElementGenerator generator = new JsonElementGenerator(project);
        JsonArray propertiesArray = DefineLocalMetaConfigKeyFix.findOrCreatePropertiesArray(generator, additionalJson);
        if (propertiesArray == null) {
            Messages.showWarningDialog((Project)project, (String)("Invalid JSON structure in " + additionalJson.getVirtualFile().getPath()), (String)"Spring Boot");
            return;
        }
        JsonObject value = (JsonObject)generator.createValue("{\n  \"name\": \"" + this.myKeyName + "\",\n" + "  \"" + "type" + "\": \"java.lang.String\",\n" + "  \"" + "description" + "\": \"Description for " + this.myKeyName + ".\"" + "}");
        boolean bl = hasValues = !propertiesArray.getValueList().isEmpty();
        if (hasValues) {
            propertiesArray.addBefore(generator.createComma(), propertiesArray.getLastChild());
        }
        JsonObject added = (JsonObject)propertiesArray.addBefore((PsiElement)value, propertiesArray.getLastChild());
        CodeStyleManager.getInstance((Project)project).reformatText((PsiFile)additionalJson, 0, additionalJson.getTextLength());
        added.navigate(true);
        UsageTrigger.trigger((String)"spring.SpringBoot.DefineLocalMetaConfigKeyFix");
    }

    @Nullable
    private static JsonArray findOrCreatePropertiesArray(JsonElementGenerator generator, JsonFile additionalJson) {
        JsonObject rootObject = (JsonObject)ObjectUtils.tryCast((Object)additionalJson.getTopLevelValue(), JsonObject.class);
        if (rootObject == null) {
            return null;
        }
        JsonProperty propertiesRoot = rootObject.findProperty("properties");
        if (propertiesRoot == null) {
            JsonProperty propertiesProperty = generator.createProperty("properties", "[]");
            if (!rootObject.getPropertyList().isEmpty()) {
                rootObject.addBefore(generator.createComma(), rootObject.getLastChild());
            }
            JsonProperty propertiesAdded = (JsonProperty)rootObject.addBefore((PsiElement)propertiesProperty, rootObject.getLastChild());
            return (JsonArray)propertiesAdded.getValue();
        }
        return (JsonArray)ObjectUtils.tryCast((Object)propertiesRoot.getValue(), JsonArray.class);
    }
}

