/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.banner.SpringBootBannerReferenceContributor;
import org.jetbrains.annotations.NotNull;

public class SpringBootBannerAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/banner/SpringBootBannerAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/boot/banner/SpringBootBannerAnnotator", "annotate"));
        }
        if (!(element instanceof PsiPlainTextFile)) {
            return;
        }
        if (!SpringBootBannerReferenceContributor.PATTERN.accepts((Object)element)) {
            return;
        }
        for (PsiReference reference : element.getReferences()) {
            TextRange referenceTextRange = reference.getRangeInElement().shiftRight(element.getTextOffset());
            if (reference.resolve() == null) {
                holder.createWarningAnnotation(referenceTextRange, "Cannot resolve property '" + reference.getCanonicalText() + "'").setHighlightType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                continue;
            }
            holder.createInfoAnnotation(referenceTextRange, null).setTextAttributes(PropertiesHighlighter.PROPERTY_KEY);
        }
    }
}

