/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.exports.ExportsNode;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteStructure;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFileByTestNameIndex
extends FileBasedIndexExtension<String, Void> {
    private static final String QUNIT_PREFIX = "Q\u0000";
    private static final String JASMINE_PREFIX = "J\u0000";
    private static final String DELIMITER = "\u0000";
    private static final ID<String, Void> KEY = ID.create((String)"js.test.names");

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = KEY;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$1", "map"));
                }
                if (!(inputData.getPsiFile() instanceof JSFile)) {
                    Map<String, Void> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$1", "map"));
                    }
                    return map;
                }
                JSIndexContent content = JSIndexContent.indexFile((FileContent)inputData);
                JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)JsTestFileByTestNameIndex.getStructure(content, JasmineFileStructureBuilder.getInstance());
                QUnitFileStructure qunitFileStructure = (QUnitFileStructure)JsTestFileByTestNameIndex.getStructure(content, QUnitFileStructureBuilder.getInstance());
                if (jasmineFileStructure.isEmpty() && qunitFileStructure.isEmpty()) {
                    Map<String, Void> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$1", "map"));
                    }
                    return map;
                }
                HashMap testNames = new HashMap();
                for (JasmineSuiteStructure suiteStructure : jasmineFileStructure.getSuites()) {
                    JsTestFileByTestNameIndex.addJasmineDescendantSuites((Map)testNames, suiteStructure, "J");
                }
                DefaultQUnitModuleStructure defaultQUnitModuleStructure = qunitFileStructure.getDefaultModuleStructure();
                for (QUnitTestMethodStructure testMethodStructure : defaultQUnitModuleStructure.getTestMethodStructures()) {
                    testNames.put(JsTestFileByTestNameIndex.createQUnitKeyForTest(testMethodStructure), null);
                }
                for (QUnitModuleStructure moduleStructure : qunitFileStructure.getNonDefaultModuleStructures()) {
                    testNames.put(JsTestFileByTestNameIndex.createQUnitKeyForModule(moduleStructure), null);
                    for (QUnitTestMethodStructure testMethodStructure : moduleStructure.getTestMethodStructures()) {
                        testNames.put(JsTestFileByTestNameIndex.createQUnitKeyForTest(testMethodStructure), null);
                    }
                }
                HashMap hashMap = testNames;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    private static <T extends AbstractTestFileStructure> T getStructure(@NotNull JSIndexContent content, @NotNull AbstractTestFileStructureBuilder<T> structureBuilder) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getStructure"));
        }
        if (structureBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structureBuilder", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getStructure"));
        }
        AbstractTestFileStructure abstractTestFileStructure = (AbstractTestFileStructure)ObjectUtils.assertNotNull((Object)content.getAdditionalData(structureBuilder.KEY));
        if (abstractTestFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getStructure"));
        }
        return (T)abstractTestFileStructure;
    }

    @NotNull
    public static String createJasmineKey(@NotNull List<String> suiteNames) {
        if (suiteNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteNames", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createJasmineKey"));
        }
        String string = JASMINE_PREFIX + StringUtil.join(suiteNames, (String)DELIMITER);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createJasmineKey"));
        }
        return string;
    }

    @NotNull
    public static String createQUnitKey(@NotNull String moduleName, @Nullable String testName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKey"));
        }
        if (testName != null) {
            String string = QUNIT_PREFIX + moduleName + DELIMITER + testName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKey"));
            }
            return string;
        }
        String string = QUNIT_PREFIX + moduleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKey"));
        }
        return string;
    }

    @NotNull
    private static String createQUnitKeyForModule(@NotNull QUnitModuleStructure moduleStructure) {
        if (moduleStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleStructure", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKeyForModule"));
        }
        String string = JsTestFileByTestNameIndex.createQUnitKey(moduleStructure.getName(), null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKeyForModule"));
        }
        return string;
    }

    @NotNull
    private static String createQUnitKeyForTest(@NotNull QUnitTestMethodStructure testMethodStructure) {
        if (testMethodStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testMethodStructure", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKeyForTest"));
        }
        String string = JsTestFileByTestNameIndex.createQUnitKey(testMethodStructure.getModuleStructure().getName(), testMethodStructure.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKeyForTest"));
        }
        return string;
    }

    @NotNull
    public static String createQUnitKeyForTestFromDefaultModule(@NotNull String testMethodName) {
        if (testMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testMethodName", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKeyForTestFromDefaultModule"));
        }
        String string = JsTestFileByTestNameIndex.createQUnitKey("Default Module", testMethodName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "createQUnitKeyForTestFromDefaultModule"));
        }
        return string;
    }

    private static void addJasmineDescendantSuites(@NotNull Map<String, Void> testNames, @NotNull JasmineSuiteStructure suite, @NotNull String prefix) {
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "addJasmineDescendantSuites"));
        }
        if (suite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suite", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "addJasmineDescendantSuites"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "addJasmineDescendantSuites"));
        }
        String nextPrefix = prefix + DELIMITER + suite.getName();
        testNames.put(nextPrefix, null);
        for (JasmineSuiteStructure childSuite : suite.getSuites()) {
            JsTestFileByTestNameIndex.addJasmineDescendantSuites(testNames, childSuite, nextPrefix);
        }
    }

    private static void addExportsNodes(@NotNull Map<String, Void> testNames, @NotNull ExportsNode node, @NotNull StringBuilder prefix) {
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "addExportsNodes"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "addExportsNodes"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "addExportsNodes"));
        }
        int oldLength = prefix.length();
        prefix.append(DELIMITER).append(node.getName());
        testNames.put(prefix.toString(), null);
        for (ExportsNode child : node.getChildren()) {
            JsTestFileByTestNameIndex.addExportsNodes(testNames, child, prefix);
        }
        prefix.setLength(oldLength);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        DataExternalizer dataExternalizer = ScalarIndexExtension.VOID_DATA_EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.FileTypeSpecificInputFilter fileTypeSpecificInputFilter = new FileBasedIndex.FileTypeSpecificInputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$2", "acceptInput"));
                }
                if (!file.isInLocalFileSystem()) {
                    return false;
                }
                if (file.getLength() > 0x100000L) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)file);
            }

            public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
                if (fileTypeSink == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex$2", "registerFileTypesUsedForIndexing"));
                }
                List fileTypes = JavaScriptFileType.getFileTypesCompilableToJavaScript();
                for (FileType type : fileTypes) {
                    fileTypeSink.consume((Object)type);
                }
            }
        };
        if (fileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "getInputFilter"));
        }
        return fileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 10;
    }

    @NotNull
    public static List<VirtualFile> findJsTestFilesByNameInScope(@NotNull String suiteKey, @NotNull GlobalSearchScope scope) {
        if (suiteKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteKey", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
        }
        List<VirtualFile> list = JsTestFileByTestNameIndex.findJsTestFilesByNameInScope(suiteKey, scope, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> findJsTestFilesByNameInScope(@NotNull String suiteKey, @NotNull GlobalSearchScope scope, @Nullable VirtualFile executedFile) {
        if (suiteKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteKey", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
        }
        Project project = scope.getProject();
        if (project != null) {
            if (project.isDisposed()) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
                }
                return list;
            }
            if (DumbService.isDumb((Project)project)) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
                }
                return list;
            }
        }
        SmartList result = new SmartList();
        FileBasedIndex.getInstance().processValues(KEY, (Object)suiteKey, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public boolean process(VirtualFile file, Void value) {
                if (file != null && file.isValid()) {
                    this.val$result.add(file);
                }
                return true;
            }
        }, scope);
        if (result.isEmpty()) {
            List list = ContainerUtil.createMaybeSingletonList((Object)executedFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
            }
            return list;
        }
        List<VirtualFile> sortedResult = JsTestFileByTestNameIndex.lowerJsFileTypesRelevance((List<VirtualFile>)result);
        if (executedFile != null) {
            JsTestFileByTestNameIndex.liftExecutedFileAmongSameExtFiles(sortedResult, executedFile);
        }
        List<VirtualFile> list = sortedResult;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "findJsTestFilesByNameInScope"));
        }
        return list;
    }

    private static void liftExecutedFileAmongSameExtFiles(@NotNull List<VirtualFile> result, @NotNull VirtualFile executedFile) {
        String executedFileExtension;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "liftExecutedFileAmongSameExtFiles"));
        }
        if (executedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executedFile", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "liftExecutedFileAmongSameExtFiles"));
        }
        int executedFileInd = result.indexOf(executedFile);
        if (executedFileInd >= 0 && (executedFileExtension = executedFile.getExtension()) != null) {
            int sameExtInd = -1;
            for (int i = 0; i < result.size(); ++i) {
                VirtualFile file = result.get(i);
                if (!executedFileExtension.equals(file.getExtension())) continue;
                sameExtInd = i;
                break;
            }
            if (sameExtInd >= 0 && sameExtInd != executedFileInd) {
                Collections.swap(result, sameExtInd, executedFileInd);
            }
        }
    }

    @NotNull
    private static List<VirtualFile> lowerJsFileTypesRelevance(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "lowerJsFileTypesRelevance"));
        }
        if (files.size() <= 1) {
            List<VirtualFile> list = files;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "lowerJsFileTypesRelevance"));
            }
            return list;
        }
        Collections.sort(files, (file1, file2) -> {
            boolean js2;
            String ext1 = StringUtil.notNullize((String)file1.getExtension()).toLowerCase(Locale.ENGLISH);
            String ext2 = StringUtil.notNullize((String)file2.getExtension()).toLowerCase(Locale.ENGLISH);
            boolean js1 = ext1.equals("js");
            if (js1 != (js2 = ext2.equals("js"))) {
                return js1 ? 1 : -1;
            }
            return file1.getPath().compareToIgnoreCase(file2.getPath());
        });
        List<VirtualFile> list = files;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/JsTestFileByTestNameIndex", "lowerJsFileTypesRelevance"));
        }
        return list;
    }
}

