/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.midp.nokia;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileFilters;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    @Nullable
    private static Element getEmulatorProperties(String homeDir) {
        File home = new File(homeDir);
        if (!home.exists() || !home.isDirectory()) {
            return null;
        }
        FileFilter xmlFilter = FileFilters.filesWithExtension((String)"xml");
        File[] xml = home.listFiles(xmlFilter);
        if (xml == null) {
            return null;
        }
        if (xml.length != 1) {
            xml = home.listFiles(pathname -> {
                String homeName;
                int _index;
                return xmlFilter.accept(pathname) && (_index = (homeName = home.getName()).indexOf(95)) > 0 && pathname.getName().startsWith(homeName.substring(0, _index));
            });
        }
        if (xml == null || xml.length != 1) {
            return null;
        }
        try {
            return JDOMUtil.load((InputStream)new BufferedInputStream(new FileInputStream(xml[0])));
        }
        catch (IOException ignored) {
            return null;
        }
        catch (JDOMException ignored) {
            return null;
        }
    }

    @Nullable
    public static String getPreferences(String homeDir) {
        Element pref = ConfigurationUtil.getByNameGroup(homeDir, "preferences");
        if (pref == null) {
            return null;
        }
        for (Element property : pref.getChildren("property")) {
            String name = property.getAttributeValue("name");
            if (!Comparing.equal((String)name, (String)"prefs")) continue;
            String preferencePath = property.getAttributeValue("value");
            if (preferencePath == null) {
                return null;
            }
            int separatorIndex = preferencePath.indexOf(File.separatorChar);
            return separatorIndex > -1 ? preferencePath.substring(separatorIndex) : null;
        }
        return null;
    }

    @Nullable
    private static Element getByNameGroup(String homeDir, String groupName) {
        Element emulatorProperties = ConfigurationUtil.getEmulatorProperties(homeDir);
        if (emulatorProperties == null) {
            return null;
        }
        Element group2 = null;
        for (Element group2 : emulatorProperties.getChildren("group")) {
            String name = group2.getAttributeValue("name");
            if (!Comparing.equal((String)name, (String)groupName)) continue;
            return group2;
        }
        return group2;
    }

    @Nullable
    public static Properties getProperties(String homePath) {
        Properties properties = new Properties();
        File home = new File(homePath);
        if (!home.exists() || !home.isDirectory()) {
            return null;
        }
        FileFilter propertiesFilter = FileFilters.filesWithExtension((String)"properties");
        File[] props = home.listFiles(propertiesFilter);
        if (props == null) {
            return properties;
        }
        if (props.length != 1) {
            props = home.listFiles(pathname -> pathname.getName().equals(home.getName() + ".properties"));
        }
        if (props == null || props.length != 1) {
            return properties;
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(props[0]));
            properties.load(is);
            ((InputStream)is).close();
            return properties;
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

