/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.context.FacetContextProvider;
import com.intellij.javaee.context.WebModuleContextProvider;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFacetContextProvider
implements FacetContextProvider {
    @Override
    public FacetTypeId<? extends JavaeeFacet> getFacetId() {
        return WebFacet.ID;
    }

    @Override
    public String getDeploymentContext(@NotNull WebModuleContextProvider webModuleContextProvider, @NotNull DeploymentModel deploymentModel, @NotNull JavaeeFacet facet) {
        if (webModuleContextProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webModuleContextProvider", "com/intellij/javaee/web/WebFacetContextProvider", "getDeploymentContext"));
        }
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/web/WebFacetContextProvider", "getDeploymentContext"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/web/WebFacetContextProvider", "getDeploymentContext"));
        }
        WebFacet webFacet = (WebFacet)facet;
        Artifact artifact = deploymentModel.getArtifact();
        if (artifact != null && JavaeeArtifactUtil.getInstance().isJavaeeApplication(artifact.getArtifactType())) {
            return WebFacetContextProvider.getModuleContext(webModuleContextProvider, artifact, webFacet);
        }
        String serverSpecificContext = StringUtil.nullize((String)this.getContextServerSpecific(deploymentModel, webFacet));
        if (serverSpecificContext != null) {
            return serverSpecificContext;
        }
        File source = deploymentModel.getDeploymentSource().getFile();
        return source == null ? null : FileUtil.getNameWithoutExtension((File)source);
    }

    protected String getContextServerSpecific(@NotNull DeploymentModel deploymentModel, @NotNull WebFacet facet) {
        if (deploymentModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentModel", "com/intellij/javaee/web/WebFacetContextProvider", "getContextServerSpecific"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/web/WebFacetContextProvider", "getContextServerSpecific"));
        }
        return this.getContextServerSpecific(facet);
    }

    protected String getContextServerSpecific(@NotNull WebFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/web/WebFacetContextProvider", "getContextServerSpecific"));
        }
        return null;
    }

    @Nullable
    public static String getModuleContext(@NotNull WebModuleContextProvider webModuleContextProvider, @NotNull Artifact earArtifact, @NotNull WebFacet webFacet) {
        if (webModuleContextProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webModuleContextProvider", "com/intellij/javaee/web/WebFacetContextProvider", "getModuleContext"));
        }
        if (earArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earArtifact", "com/intellij/javaee/web/WebFacetContextProvider", "getModuleContext"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/WebFacetContextProvider", "getModuleContext"));
        }
        Project project = webFacet.getModule().getProject();
        String moduleWebUri = WebArtifactUtil.getInstance().getModuleWebUri(earArtifact, webFacet);
        if (moduleWebUri == null) {
            return null;
        }
        Collection<JavaeeApplicationFacet> earFacets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, earArtifact, JavaeeApplicationFacet.ID);
        for (JavaeeApplicationFacet earFacet : earFacets) {
            String contextRoot = webModuleContextProvider.getContext(earFacet, moduleWebUri);
            if (contextRoot == null) continue;
            return contextRoot;
        }
        return null;
    }
}

