/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.model.impl;

import com.intellij.batch.model.BatchXmlModel;
import com.intellij.batch.model.batch.BatchArtifacts;
import com.intellij.batch.model.impl.BatchXmlModelImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ModuleContentRootSearchScope;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchXmlModelFactory
extends DomModelFactory<BatchArtifacts, BatchXmlModel, PsiElement> {
    public BatchXmlModelFactory(Project project) {
        super(BatchArtifacts.class, project, "batch-artifacts");
    }

    protected List<BatchXmlModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/model/impl/BatchXmlModelFactory", "computeAllModels"));
        }
        ArrayList<BatchXmlModel> models = new ArrayList<BatchXmlModel>();
        ModuleContentRootSearchScope moduleContentScope = new ModuleContentRootSearchScope(module);
        Collection files = DomService.getInstance().getDomFileCandidates(BatchArtifacts.class, moduleContentScope.getProject(), (GlobalSearchScope)moduleContentScope);
        for (VirtualFile beansXmlCandidate : files) {
            BatchXmlModel model;
            PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(beansXmlCandidate);
            if (!(file instanceof XmlFile) || (model = this.computeModel((XmlFile)file, module)) == null) continue;
            models.add(model);
        }
        return models;
    }

    @Nullable
    public BatchXmlModel getModelByConfigFile(@Nullable XmlFile psiFile) {
        if (psiFile == null) {
            return null;
        }
        return this.computeModel(psiFile, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
    }

    protected BatchXmlModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/batch/model/impl/BatchXmlModelFactory", "computeModel"));
        }
        if (module == null) {
            return null;
        }
        return this.createSingleModel(psiFile, module);
    }

    @Nullable
    private BatchXmlModel createSingleModel(XmlFile psiFile, Module module) {
        DomFileElement domRoot = this.getDomRoot(psiFile);
        if (domRoot != null) {
            DomFileElement fileElement;
            HashSet<XmlFile> files = new HashSet<XmlFile>();
            files.add(psiFile);
            DomFileElement domFileElement = fileElement = files.size() > 1 ? this.createMergedModelRoot(files) : domRoot;
            if (fileElement != null) {
                return new BatchXmlModelImpl(module, (DomFileElement<BatchArtifacts>)fileElement, files);
            }
        }
        return null;
    }

    protected BatchXmlModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<BatchArtifacts> mergedModel, BatchXmlModel firstModel, Module module) {
        if (configFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFiles", "com/intellij/batch/model/impl/BatchXmlModelFactory", "createCombinedModel"));
        }
        if (mergedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedModel", "com/intellij/batch/model/impl/BatchXmlModelFactory", "createCombinedModel"));
        }
        throw new UnsupportedOperationException();
    }
}

