/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.CompatibilityAwareRunProfile;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.ide.browsers.BrowserStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceBrowserRunConfigurationEditor;
import com.intellij.javascript.trace.execution.TraceBrowserRunConfigurationSettings;
import com.intellij.javascript.trace.execution.TraceBrowserSettingsSerializationUtil;
import com.intellij.javascript.trace.execution.TraceProfileState;
import com.intellij.javascript.trace.execution.TraceRunConfiguration;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.systemProxy.ProxyConfigurator;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import java.io.File;
import java.util.HashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class TraceBrowserConfiguration
extends TraceRunConfiguration
implements RunConfigurationWithSuppressedDefaultRunAction,
RefactoringListenerProvider,
CompatibilityAwareRunProfile {
    public static final int DEFAULT_TRACE_SERVER_PORT = 3546;
    private TraceBrowserRunConfigurationSettings mySettings;
    private VirtualFile myConfigFile;

    public TraceBrowserConfiguration(Project project, @NotNull ConfigurationFactory factory, String name) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.mySettings = new TraceBrowserRunConfigurationSettings(3546, false, true, "", NodeJsInterpreterRef.createProjectRef(), false, null, null);
    }

    @Override
    @NotNull
    public JSONObject getConfigJson() {
        boolean hasConfigurationFile = this.mySettings.hasConfig();
        String config = hasConfigurationFile ? this.mySettings.getConfigPath() : this.mySettings.getUrl();
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!hasConfigurationFile) {
            config = config.replace("\\", "/");
        }
        values.put(hasConfigurationFile ? "path" : "url", config);
        if (this.mySettings.getTraceLimits() != null) {
            this.mySettings.getTraceLimits().addToConfigJson(values);
        }
        JSONObject jSONObject = new JSONObject(values);
        if (jSONObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "getConfigJson"));
        }
        return jSONObject;
    }

    @Override
    @NotNull
    public GeneralCommandLine createCommandLine() throws ExecutionException {
        boolean useSource;
        NodeJsLocalInterpreter interpreter = this.mySettings.getNodeInterpreterRef().resolveAsLocal(this.getProject());
        int serverPort = this.mySettings.getProxyPort();
        String debugPortStr = System.getenv("DEBUG_SPY_JS");
        boolean debug = useSource = !StringUtil.isEmpty((String)debugPortStr);
        int debugPort = 0;
        if (useSource) {
            try {
                debugPort = Integer.parseInt(debugPortStr);
            }
            catch (Exception ignored) {
                debug = false;
            }
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        if (debug) {
            commandLine.addParameter("--debug-brk=" + String.valueOf(debugPort));
            commandLine.addParameter("--expose-debug-as=v8debug");
        }
        commandLine.addParameter(Utils.getServerScriptPath("spy.js", !useSource));
        commandLine.addParameter("--port=" + serverPort);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @Override
    @Nullable
    public VirtualFile getConfigFile() {
        if (this.mySettings.hasConfig() && this.myConfigFile == null) {
            this.myConfigFile = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getConfigPath()), (boolean)false);
        }
        return this.myConfigFile;
    }

    @Override
    public void configurationStarted(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "configurationStarted"));
        }
        UsageTrigger.trigger((String)TraceBundle.message("usage.browser.config.start", new Object[0]));
        if (this.mySettings.isSystemProxyUsed()) {
            ProxyConfigurator.getInstance().requestStart(this.mySettings.getProxyPort());
        }
        if (this.mySettings.needToOpenBrowser() && !this.mySettings.hasConfig() && !StringUtil.isEmpty((String)this.mySettings.getUrl())) {
            String browserId = this.mySettings.getBrowserId();
            StartBrowserSettings settings = new StartBrowserSettings();
            settings.setSelected(true);
            settings.setUrl(this.mySettings.getUrl());
            settings.setBrowser(StringUtil.isEmpty((String)browserId) ? WebBrowserManager.getInstance().getFirstActiveBrowser() : WebBrowserManager.getInstance().findBrowserById(browserId));
            settings.setStartJavaScriptDebugger(false);
            new BrowserStarter((RunConfiguration)this, settings, processHandler).start();
        }
    }

    @Override
    public void configurationStopped() {
        if (this.mySettings.isSystemProxyUsed()) {
            ProxyConfigurator.getInstance().requestStop(this.mySettings.getProxyPort());
        }
    }

    @Override
    public int getProxyPort() {
        return this.mySettings.getProxyPort();
    }

    @NotNull
    public TraceBrowserRunConfigurationSettings getTraceSettings() {
        TraceBrowserRunConfigurationSettings traceBrowserRunConfigurationSettings = this.mySettings;
        if (traceBrowserRunConfigurationSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "getTraceSettings"));
        }
        return traceBrowserRunConfigurationSettings;
    }

    public void setTraceSettings(@NotNull TraceBrowserRunConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "setTraceSettings"));
        }
        this.mySettings = settings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        TraceBrowserRunConfigurationEditor traceBrowserRunConfigurationEditor = new TraceBrowserRunConfigurationEditor(this.getProject());
        if (traceBrowserRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "getConfigurationEditor"));
        }
        return traceBrowserRunConfigurationEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeJsInterpreter interpreter = this.mySettings.getNodeInterpreterRef().resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        if (this.mySettings.hasConfig()) {
            String configPath = this.mySettings.getConfigPath();
            if (configPath.trim().isEmpty()) {
                throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.emptyConfigPath", new Object[0]));
            }
            File config = new File(configPath);
            if (!config.isFile() || !config.exists()) {
                throw new RuntimeConfigurationError(TraceBundle.message("configuration.validation.incorrectConfigPath", new Object[0]));
            }
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "getState"));
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        catch (RuntimeConfigurationException runtimeConfigurationException) {
            // empty catch block
        }
        return new TraceProfileState(this.getProject(), env);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.setTraceSettings(TraceBrowserSettingsSerializationUtil.readFromXml(element));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        TraceBrowserSettingsSerializationUtil.writeToXml(element, this.getTraceSettings());
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (!this.mySettings.hasConfig()) {
            return null;
        }
        VirtualFile file = PsiUtilBase.asVirtualFile((PsiElement)element);
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        String configPath = FileUtil.toSystemIndependentName((String)this.mySettings.getConfigPath());
        if (configPath.equals(path)) {
            return new UndoRefactoringElementAdapter(){

                protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration$1", "refactored"));
                    }
                    VirtualFile newFile = PsiUtilBase.asVirtualFile((PsiElement)element);
                    if (newFile != null) {
                        String newPath = FileUtil.toSystemDependentName((String)newFile.getPath());
                        TraceBrowserConfiguration.this.setTraceSettings(new TraceBrowserRunConfigurationSettings(TraceBrowserConfiguration.this.mySettings.getProxyPort(), true, TraceBrowserConfiguration.this.mySettings.isSystemProxyUsed(), newPath, TraceBrowserConfiguration.this.mySettings.getNodeInterpreterRef(), TraceBrowserConfiguration.this.mySettings.needToOpenBrowser(), TraceBrowserConfiguration.this.mySettings.getBrowserId(), TraceBrowserConfiguration.this.mySettings.getTraceLimits()));
                    }
                }
            };
        }
        return null;
    }

    public boolean mustBeStoppedToRun(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/trace/execution/TraceBrowserConfiguration", "mustBeStoppedToRun"));
        }
        return configuration instanceof JavaScriptDebugConfiguration && this.mySettings.isSystemProxyUsed();
    }
}

