/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceBrowserConfiguration;
import com.intellij.javascript.trace.execution.TraceBrowserRunConfigurationSettings;
import com.intellij.javascript.trace.execution.TraceConfigurationEditorUtils;
import com.intellij.javascript.trace.execution.TraceLimitsPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PortField;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.Urls;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;

public class TraceBrowserRunConfigurationEditor
extends SettingsEditor<TraceBrowserConfiguration> {
    private static final String DEFAULT_CONFIG = TraceBundle.message("configuration.type.noConfig", new Object[0]);
    private static final String CODE_CONFIG = TraceBundle.message("configuration.type.codeConfig", new Object[0]);
    private final JPanel myRootComponent;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final PortField myTraceServerPortField;
    private final ComboBox<String> myConfigTypeCombo;
    private final HashMap<String, String> myConfigLabelMap;
    private final JLabel myConfigTypeDependentLabel;
    private final TextFieldWithHistoryWithBrowseButton myConfig;
    private final TextFieldWithHistory myUrl;
    private final JBCheckBox myUseSystemProxy;
    private final BrowserSelector myBrowserSelector;
    private final JBCheckBox myOpenBrowserCheckBox;
    private final JPanel myBrowserContainer;
    private final TraceLimitsPanel myTraceLimitsPanel;
    private Project myProject;

    public TraceBrowserRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TraceBrowserRunConfigurationEditor", "<init>"));
        }
        this.myProject = project;
        this.myConfigLabelMap = new HashMap();
        this.myConfigLabelMap.put((Object)DEFAULT_CONFIG, (Object)TraceBundle.message("configuration.label.url", new Object[0]));
        this.myConfigLabelMap.put((Object)CODE_CONFIG, (Object)TraceBundle.message("configuration.label.config", new Object[0]));
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myTraceServerPortField = new PortField(3546);
        this.myConfigTypeCombo = new ComboBox((Object[])new String[]{DEFAULT_CONFIG, CODE_CONFIG}, JBUI.scale((int)180));
        this.myConfigTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String selectedValue = TraceBrowserRunConfigurationEditor.this.myConfigTypeCombo.getSelectedItem().toString();
                TraceBrowserRunConfigurationEditor.this.myConfigTypeDependentLabel.setText((String)TraceBrowserRunConfigurationEditor.this.myConfigLabelMap.get((Object)selectedValue));
                TraceBrowserRunConfigurationEditor.this.myConfig.setVisible(selectedValue.equals(CODE_CONFIG));
                TraceBrowserRunConfigurationEditor.this.myUrl.setVisible(!TraceBrowserRunConfigurationEditor.this.myConfig.isVisible());
                TraceBrowserRunConfigurationEditor.this.myBrowserContainer.setVisible(TraceBrowserRunConfigurationEditor.this.myUrl.isVisible());
                TraceBrowserRunConfigurationEditor.this.myTraceLimitsPanel.setEditable(TraceBrowserRunConfigurationEditor.this.myUrl.isVisible());
            }
        });
        this.myConfigTypeDependentLabel = new JLabel((String)this.myConfigLabelMap.get((Object)DEFAULT_CONFIG));
        this.myConfig = TraceConfigurationEditorUtils.createConfigurationFileTextField(project);
        this.myUrl = this.createUrlTextField();
        this.myBrowserSelector = new BrowserSelector();
        this.myOpenBrowserCheckBox = new JBCheckBox(TraceBundle.message("configuration.label.openBrowser", new Object[0]));
        JPanel configOrUrl = new JPanel(new GridBagLayout());
        configOrUrl.add((Component)this.myConfig, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        configOrUrl.add((Component)this.myUrl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myBrowserContainer = new JPanel(new BorderLayout());
        configOrUrl.add((Component)this.myBrowserContainer, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.myBrowserContainer.add((Component)this.myOpenBrowserCheckBox, "West");
        this.myBrowserContainer.add((Component)this.myBrowserSelector.getMainComponent(), "Center");
        this.myUseSystemProxy = new JBCheckBox(TraceBundle.message("configuration.label.systemProxy", new Object[0]));
        this.myTraceLimitsPanel = new TraceLimitsPanel();
        this.myRootComponent = FormBuilder.createFormBuilder().addLabeledComponent(TraceBundle.message("configuration.label.node", new Object[0]), (JComponent)this.myNodeInterpreterField).addLabeledComponent(TraceBundle.message("configuration.label.port", new Object[0]), (JComponent)this.myTraceServerPortField).addLabeledComponent(TraceBundle.message("configuration.label.use", new Object[0]), this.myConfigTypeCombo).addLabeledComponent((JComponent)this.myConfigTypeDependentLabel, (JComponent)configOrUrl).addLabeledComponent(TraceBundle.message("configuration.label.traceLimits", new Object[0]), (JComponent)this.myTraceLimitsPanel).addLabeledComponent((JComponent)this.myUseSystemProxy, (JComponent)new JPanel(), true).getPanel();
    }

    private TextFieldWithHistory createUrlTextField() {
        TextFieldWithHistory textFieldWithHistory = new TextFieldWithHistory();
        textFieldWithHistory.setHistorySize(-1);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> Collections.singletonList(Urls.newHttpUrl((String)("localhost:" + BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort()), (String)('/' + this.myProject.getName() + '/')).toString()));
        return textFieldWithHistory;
    }

    protected void resetEditorFrom(TraceBrowserConfiguration rc) {
        TraceBrowserRunConfigurationSettings settings = rc.getTraceSettings();
        NodeJsInterpreterRef interpreterRef = settings.getNodeInterpreterRef();
        this.myNodeInterpreterField.setInterpreterRef(interpreterRef);
        String configType = settings.hasConfig() ? CODE_CONFIG : DEFAULT_CONFIG;
        this.myConfigTypeCombo.setSelectedItem((Object)configType);
        this.myConfigTypeDependentLabel.setText((String)this.myConfigLabelMap.get((Object)configType));
        this.myConfig.setVisible(settings.hasConfig());
        this.myUrl.setVisible(!settings.hasConfig());
        this.myBrowserContainer.setVisible(this.myUrl.isVisible());
        this.myTraceLimitsPanel.setEditable(this.myUrl.isVisible());
        TraceConfigurationEditorUtils.setTextAndAddToHistory((TextFieldWithHistory)this.myConfig.getChildComponent(), settings.getConfigPath());
        TraceConfigurationEditorUtils.setTextAndAddToHistory(this.myUrl, settings.getUrl());
        this.myTraceServerPortField.setValue((Object)settings.getProxyPort());
        this.myUseSystemProxy.setSelected(settings.isSystemProxyUsed());
        this.myOpenBrowserCheckBox.setSelected(settings.needToOpenBrowser() && this.myUrl.isVisible());
        if (!StringUtil.isEmpty((String)settings.getBrowserId()) && this.myUrl.isVisible()) {
            this.myBrowserSelector.setSelected(WebBrowserManager.getInstance().findBrowserById(settings.getBrowserId()));
        }
        if (this.myUrl.isVisible() && settings.getTraceLimits() != null) {
            this.myTraceLimitsPanel.setValue(settings.getTraceLimits());
        }
    }

    protected void applyEditorTo(TraceBrowserConfiguration rc) throws ConfigurationException {
        NodeJsInterpreterRef interpreterRef = this.myNodeInterpreterField.getInterpreterRef();
        boolean hasConfig = this.myConfigTypeCombo.getSelectedItem().equals(CODE_CONFIG);
        rc.setTraceSettings(new TraceBrowserRunConfigurationSettings(this.myTraceServerPortField.getNumber(), hasConfig, this.myUseSystemProxy.isSelected(), hasConfig ? ((TextFieldWithHistory)this.myConfig.getChildComponent()).getText() : this.myUrl.getText(), interpreterRef, this.myOpenBrowserCheckBox.isSelected(), this.myBrowserSelector.getSelectedBrowserId(), hasConfig ? null : this.myTraceLimitsPanel.getValue()));
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceBrowserRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }
}

