/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyDiagramFileType;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraph;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.Predicate;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyVirtualFile
extends LightVirtualFile {
    private final String myName;
    private TraceContext myTraceContext;
    private FileDependencyGraph myFileDependencyGraph;
    private boolean myUpToDate;
    private boolean myHasChanged;

    public FileDependencyVirtualFile(@NotNull FileDependencyGraph fileDependencyGraph, @NotNull String name) {
        if (fileDependencyGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDependencyGraph", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "<init>"));
        }
        this.myFileDependencyGraph = fileDependencyGraph;
        this.myName = name.length() > 45 ? StringUtil.first((String)name, (int)20, (boolean)true) + StringUtil.last((CharSequence)name, (int)25, (boolean)false) : name;
        this.setFileType(FileDependencyDiagramFileType.INSTANCE);
        this.myUpToDate = true;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "getName"));
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "getPath"));
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return new VirtualFile[0];
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = new byte[]{};
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    public FileDependencyGraph getFileDependencyGraph() {
        return this.myFileDependencyGraph;
    }

    @NotNull
    public TraceContext getTraceContext() {
        TraceContext traceContext = this.myTraceContext;
        if (traceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "getTraceContext"));
        }
        return traceContext;
    }

    public void addNodeFilter(@NotNull Predicate<FileNode> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "addNodeFilter"));
        }
        this.myFileDependencyGraph.addNodeFilter(predicate);
    }

    public void setTraceContext(@NotNull TraceContext traceContext) {
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "setTraceContext"));
        }
        this.myTraceContext = traceContext;
    }

    public boolean isUpToDate() {
        return this.myUpToDate;
    }

    public void update(@NotNull FileDependencyGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/javascript/trace/execution/fileDependency/FileDependencyVirtualFile", "update"));
        }
        this.myFileDependencyGraph = graph;
        this.myUpToDate = true;
        this.myHasChanged = true;
    }

    public boolean hasChanged() {
        return this.myHasChanged;
    }

    public void setExpired() {
        this.myUpToDate = false;
    }

    public void setUpdated() {
        this.myHasChanged = false;
    }
}

