/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.search.TraceSearch;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoToSearchOccurenceAction
extends AnAction {
    public final void actionPerformed(AnActionEvent e) {
        TraceSearch traceSearch = GoToSearchOccurenceAction.getCurrentTraceSearch(e.getProject());
        if (traceSearch != null) {
            this.actionPerformed(e, traceSearch);
        }
    }

    public final void update(AnActionEvent e) {
        TraceSearch traceSearch = GoToSearchOccurenceAction.getCurrentTraceSearch(e.getProject());
        if (traceSearch == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(traceSearch.isActive());
            e.getPresentation().setEnabled(this.canGo(e, traceSearch));
        }
    }

    protected void actionPerformed(@NotNull AnActionEvent e, @NotNull TraceSearch traceSearch) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/stack/actions/GoToSearchOccurenceAction", "actionPerformed"));
        }
        if (traceSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceSearch", "com/intellij/javascript/trace/execution/stack/actions/GoToSearchOccurenceAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        if (!this.canGo(e, traceSearch)) {
            return;
        }
        OccurenceNavigator.OccurenceInfo occurenceInfo = this.go(e, traceSearch);
        if (occurenceInfo == null) {
            return;
        }
        Navigatable descriptor = occurenceInfo.getNavigateable();
        if (descriptor != null && descriptor.canNavigate()) {
            descriptor.navigate(false);
        }
        if (occurenceInfo.getOccurenceNumber() == -1 || occurenceInfo.getOccurencesCount() == -1) {
            return;
        }
        StatusBar.Info.set((String)IdeBundle.message((String)"message.occurrence.N.of.M", (Object[])new Object[]{occurenceInfo.getOccurenceNumber(), occurenceInfo.getOccurencesCount()}), (Project)project);
    }

    protected OccurenceNavigator.OccurenceInfo go(@NotNull AnActionEvent e, @NotNull TraceSearch traceSearch) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/stack/actions/GoToSearchOccurenceAction", "go"));
        }
        if (traceSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceSearch", "com/intellij/javascript/trace/execution/stack/actions/GoToSearchOccurenceAction", "go"));
        }
        return null;
    }

    protected abstract boolean canGo(@NotNull AnActionEvent var1, @NotNull TraceSearch var2);

    @Nullable
    private static TraceSearch getCurrentTraceSearch(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)project);
        RunContentDescriptor selectedContent = executionManager.getContentManager().getSelectedContent();
        if (selectedContent == null) {
            return null;
        }
        ProcessHandler processHandler = selectedContent.getProcessHandler();
        if (processHandler == null) {
            return null;
        }
        TraceContext traceContext = (TraceContext)processHandler.getUserData(TraceContext.KEY);
        if (traceContext == null) {
            return null;
        }
        return traceContext.getTraceSearch();
    }
}

