/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.javascript.trace.execution.stack.actions.StackTreeAction;
import com.intellij.lang.javascript.ui.NodeModuleNamesUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class JumpToPackageFileAction
extends StackTreeAction {
    @Override
    protected void doUpdate(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/JumpToPackageFileAction", "doUpdate"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/JumpToPackageFileAction", "doUpdate"));
        }
        String packageFile = NodeModuleNamesUtil.getModulePackageFile((String)selectedNode.getFile());
        if (StringUtil.isEmpty((String)packageFile) || !new File(packageFile).exists()) {
            e.getPresentation().setVisible(false);
        }
    }

    @Override
    protected void doPerform(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/JumpToPackageFileAction", "doPerform"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/JumpToPackageFileAction", "doPerform"));
        }
        String packageFilePath = NodeModuleNamesUtil.getModulePackageFile((String)selectedNode.getFile());
        if (StringUtil.isEmpty((String)packageFilePath)) {
            return;
        }
        VirtualFile packageFile = LocalFileSystem.getInstance().findFileByPath(packageFilePath);
        if (packageFile == null) {
            return;
        }
        FileEditorManager.getInstance((Project)e.getProject()).openFile(packageFile, true);
    }

    @Override
    protected boolean isAvailableForLoadedTrace() {
        return false;
    }
}

