/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations.impl;

import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServersManagerImpl;
import com.intellij.javaee.appServers.library.AppServerFrameworkLibraryProperties;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AppServersLibraryTable
extends LibraryTableBase {
    AppServersLibraryTable() {
    }

    public String getTableLevel() {
        return "application_server_libraries";
    }

    public LibraryTablePresentation getPresentation() {
        return ApplicationServersManagerImpl.APP_SERVER_LIBRARY_TABLE_PRESENTATION;
    }

    public boolean isEditable() {
        return false;
    }

    @NotNull
    public List<Pair<Library, AppServerFrameworkLibraryProperties>> getApplicationServerFrameworkLibraries(@NotNull String appServerName) {
        if (appServerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appServerName", "com/intellij/j2ee/appServerIntegrations/impl/AppServersLibraryTable", "getApplicationServerFrameworkLibraries"));
        }
        List<Pair<Library, AppServerFrameworkLibraryProperties>> list = AppServersLibraryTable.getApplicationServerFrameworkLibraries(appServerName, this.getLibraryIterator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/appServerIntegrations/impl/AppServersLibraryTable", "getApplicationServerFrameworkLibraries"));
        }
        return list;
    }

    @NotNull
    public static List<Pair<Library, AppServerFrameworkLibraryProperties>> getApplicationServerFrameworkLibraries(@NotNull String appServerName, Iterator<Library> libraryIterator) {
        if (appServerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appServerName", "com/intellij/j2ee/appServerIntegrations/impl/AppServersLibraryTable", "getApplicationServerFrameworkLibraries"));
        }
        ArrayList<Pair<Library, AppServerFrameworkLibraryProperties>> libraries = new ArrayList<Pair<Library, AppServerFrameworkLibraryProperties>>();
        while (libraryIterator.hasNext()) {
            AppServerFrameworkLibraryProperties libraryProperties;
            LibraryEx library = (LibraryEx)libraryIterator.next();
            LibraryProperties properties = library.getProperties();
            if (!(properties instanceof AppServerFrameworkLibraryProperties) || !appServerName.equals((libraryProperties = (AppServerFrameworkLibraryProperties)properties).getServerName())) continue;
            libraries.add((Pair<Library, AppServerFrameworkLibraryProperties>)Pair.create((Object)library, (Object)((Object)libraryProperties)));
        }
        ArrayList<Pair<Library, AppServerFrameworkLibraryProperties>> arrayList = libraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/appServerIntegrations/impl/AppServersLibraryTable", "getApplicationServerFrameworkLibraries"));
        }
        return arrayList;
    }
}

