/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.artifact;

import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.artifact.WebFacetContextEvaluationService;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebFacetContextEvaluationServiceImpl
extends WebFacetContextEvaluationService {
    private static final Key<CachedValue<List<IncludedFacetWithPath>>> INCLUDED_WEB_FACETS_KEY = Key.create((String)"WEB_FACETS_INCLUDED_IN_ARTIFACT");
    private static final Key<CachedValue<List<PrefixedVirtualFile>>> WEB_FACET_OUTPUT_FILES_KEY = Key.create((String)"WEB_FACET_OUTPUT_FILES");
    private final Project myProject;

    public WebFacetContextEvaluationServiceImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    private List<IncludedFacetWithPath> getIncludedFacets(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getIncludedFacets"));
        }
        CachedValue cachedValue = (CachedValue)artifact.getUserData(INCLUDED_WEB_FACETS_KEY);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                if (artifact == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "lambda$getIncludedFacets$0"));
                }
                return CachedValueProvider.Result.create(this.computeIncludedFacets(artifact), (Object[])new Object[]{ArtifactManager.getInstance((Project)this.myProject).getModificationTracker(), JavaeeUtil.getAllJavaeeFacetModificationTracker(this.myProject)});
            }, false);
            artifact.putUserData(INCLUDED_WEB_FACETS_KEY, (Object)cachedValue);
        }
        List list = (List)cachedValue.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getIncludedFacets"));
        }
        return list;
    }

    @NotNull
    private List<IncludedFacetWithPath> computeIncludedFacets(@NotNull Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "computeIncludedFacets"));
        }
        SmartList result = new SmartList();
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)this.myProject).getResolvingContext();
        WebArtifactUtil webArtifactUtil = WebArtifactUtil.getInstance();
        PackagingElementProcessor<JavaeeFacetResourcesPackagingElement> processor = new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>((List)result, artifact, webArtifactUtil){
            final /* synthetic */ List val$result;
            final /* synthetic */ Artifact val$artifact;
            final /* synthetic */ WebArtifactUtil val$webArtifactUtil;
            {
                this.val$result = list;
                this.val$artifact = artifact;
                this.val$webArtifactUtil = webArtifactUtil;
            }

            public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$1", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$1", "process"));
                }
                JavaeeFacet facet = element.findFacet(context);
                if (facet instanceof WebFacet) {
                    this.val$result.add(new IncludedFacetWithPath((WebFacet)facet, WebFacetContextEvaluationServiceImpl.normalizeRelativePath(path.getPathStringFrom("/", this.val$artifact.getRootElement()))));
                }
                return true;
            }

            public boolean shouldProcessSubstitution(ComplexPackagingElement<?> element) {
                Artifact included;
                if (element instanceof ArtifactPackagingElement && (included = ((ArtifactPackagingElement)element).findArtifact(context)) != null && !this.val$webArtifactUtil.isWebApplication(included.getArtifactType())) {
                    return false;
                }
                return super.shouldProcessSubstitution(element);
            }
        };
        ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)processor, (PackagingElementResolvingContext)context, (boolean)true);
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "computeIncludedFacets"));
        }
        return smartList;
    }

    private List<PrefixedVirtualFile> getOutputFiles(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getOutputFiles"));
        }
        CachedValue cachedValue = (CachedValue)webFacet.getUserData(WEB_FACET_OUTPUT_FILES_KEY);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                if (webFacet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "lambda$getOutputFiles$1"));
                }
                return CachedValueProvider.Result.create(this.computeOutputFiles(webFacet), (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myProject), ArtifactManager.getInstance((Project)this.myProject).getModificationTracker(), JavaeeUtil.getAllJavaeeFacetModificationTracker(this.myProject)});
            }, false);
            webFacet.putUserData(WEB_FACET_OUTPUT_FILES_KEY, (Object)cachedValue);
        }
        return (List)cachedValue.getValue();
    }

    private List<PrefixedVirtualFile> computeOutputFiles(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "computeOutputFiles"));
        }
        PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)this.myProject).getResolvingContext();
        Collection webArtifactTypes = WebArtifactUtil.getInstance().getWebArtifactTypes();
        Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, context, webArtifactTypes, false);
        ArrayList<PrefixedVirtualFile> result = new ArrayList<PrefixedVirtualFile>();
        for (Artifact artifact : artifacts) {
            for (IncludedFacetWithPath includedFacet : this.getIncludedFacets(artifact)) {
                WebFacetContextEvaluationServiceImpl.collectWebRoots(includedFacet, result);
            }
        }
        if (artifacts.isEmpty()) {
            WebFacetContextEvaluationServiceImpl.collectWebRoots(new IncludedFacetWithPath(webFacet, ""), result);
        }
        return result;
    }

    private static void collectWebRoots(IncludedFacetWithPath includedFacet, List<PrefixedVirtualFile> result) {
        for (WebRoot root : includedFacet.getWebFacet().getWebRoots()) {
            VirtualFile file = root.getFile();
            if (file == null) continue;
            String prefix = includedFacet.getPathInArtifact() + WebFacetContextEvaluationServiceImpl.normalizeRelativePath(root.getURI());
            result.add(new PrefixedVirtualFile(file, prefix));
        }
    }

    @Override
    @NotNull
    public List<VirtualFile> getOutputFiles(@NotNull WebFacet webFacet, @NotNull String relativePathInOutput) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getOutputFiles"));
        }
        if (relativePathInOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePathInOutput", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getOutputFiles"));
        }
        List<PrefixedVirtualFile> files = this.getOutputFiles(webFacet);
        relativePathInOutput = WebFacetContextEvaluationServiceImpl.normalizeRelativePath(relativePathInOutput);
        SmartList result = new SmartList();
        for (PrefixedVirtualFile prefixedFile : files) {
            String relativePath = WebFacetContextEvaluationServiceImpl.getRelativePathIfStartsWith(relativePathInOutput, prefixedFile.getPrefixPath());
            if (relativePath == null) continue;
            ContainerUtil.addIfNotNull((Object)prefixedFile.getFile().findFileByRelativePath(UriUtil.trimTrailingSlashes((String)relativePath)), (Collection)result);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getOutputFiles"));
        }
        return smartList;
    }

    @Override
    public boolean processChildren(@NotNull WebFacet webFacet, @NotNull String relativePathInOutput, @NotNull WebDirectoryElement.WebDirectoryProcessor processor) throws Exception {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "processChildren"));
        }
        if (relativePathInOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePathInOutput", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "processChildren"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "processChildren"));
        }
        relativePathInOutput = WebFacetContextEvaluationServiceImpl.normalizeRelativePath(relativePathInOutput);
        List<PrefixedVirtualFile> files = this.getOutputFiles(webFacet);
        for (PrefixedVirtualFile prefixedFile : files) {
            String name;
            String prefixTail;
            int i;
            String prefixPath = prefixedFile.getPrefixPath();
            String relativePath = WebFacetContextEvaluationServiceImpl.getRelativePathIfStartsWith(relativePathInOutput, prefixPath);
            if (relativePath != null) {
                VirtualFile file = prefixedFile.getFile().findFileByRelativePath(UriUtil.trimTrailingSlashes((String)relativePath));
                if (file == null) continue;
                for (VirtualFile child : file.getChildren()) {
                    if (!child.isValid() || processor.execute(child.getName(), child.isDirectory())) continue;
                    return false;
                }
                continue;
            }
            if (!prefixPath.startsWith(relativePathInOutput) || (i = (prefixTail = prefixPath.substring(relativePathInOutput.length())).indexOf(47)) == -1 || processor.execute(name = prefixTail.substring(0, i), true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getRelativeOutputPathForFile(@NotNull WebFacet webFacet, @NotNull VirtualFile file) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getRelativeOutputPathForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getRelativeOutputPathForFile"));
        }
        List<PrefixedVirtualFile> files = this.getOutputFiles(webFacet);
        for (PrefixedVirtualFile prefixedFile : files) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)prefixedFile.getFile(), (char)'/');
            if (relativePath == null) continue;
            return UriUtil.trimTrailingSlashes((String)(prefixedFile.getPrefixPath() + WebFacetContextEvaluationServiceImpl.normalizeRelativePath(relativePath)));
        }
        return null;
    }

    @Nullable
    private static String getRelativePathIfStartsWith(@NotNull String path, @NotNull String basePath) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getRelativePathIfStartsWith"));
        }
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "getRelativePathIfStartsWith"));
        }
        if (!path.startsWith(basePath)) {
            return null;
        }
        return path.substring(basePath.length());
    }

    private static String normalizeRelativePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl", "normalizeRelativePath"));
        }
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        return path;
    }

    private static class PrefixedVirtualFile {
        private final VirtualFile myFile;
        private final String myPrefixPath;

        private PrefixedVirtualFile(@NotNull VirtualFile file, @NotNull String prefixPath) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$PrefixedVirtualFile", "<init>"));
            }
            if (prefixPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixPath", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$PrefixedVirtualFile", "<init>"));
            }
            this.myFile = file;
            this.myPrefixPath = prefixPath;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public String getPrefixPath() {
            return this.myPrefixPath;
        }
    }

    private static class IncludedFacetWithPath {
        private final WebFacet myWebFacet;
        private final String myPathInArtifact;

        private IncludedFacetWithPath(@NotNull WebFacet webFacet, @NotNull String pathInArtifact) {
            if (webFacet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$IncludedFacetWithPath", "<init>"));
            }
            if (pathInArtifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInArtifact", "com/intellij/javaee/web/artifact/WebFacetContextEvaluationServiceImpl$IncludedFacetWithPath", "<init>"));
            }
            this.myWebFacet = webFacet;
            this.myPathInArtifact = pathInArtifact;
        }

        public WebFacet getWebFacet() {
            return this.myWebFacet;
        }

        public String getPathInArtifact() {
            return this.myPathInArtifact;
        }
    }
}

