/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation;

import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PackageUtil;
import com.intellij.javaee.JavaeeVersion;
import com.intellij.javaee.model.common.persistence.mapping.Basic;
import com.intellij.javaee.model.common.persistence.mapping.Embedded;
import com.intellij.javaee.model.common.persistence.mapping.EmbeddedId;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodContainer;
import com.intellij.javaee.model.common.persistence.mapping.Id;
import com.intellij.javaee.model.common.persistence.mapping.Transient;
import com.intellij.javaee.model.common.persistence.mapping.Version;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.javaee.model.xml.persistence.mapping.AssociationOverride;
import com.intellij.javaee.model.xml.persistence.mapping.AttributeBase;
import com.intellij.javaee.model.xml.persistence.mapping.AttributeOverride;
import com.intellij.javaee.model.xml.persistence.mapping.AttributeWithColumn;
import com.intellij.javaee.model.xml.persistence.mapping.CascadeType;
import com.intellij.javaee.model.xml.persistence.mapping.CollectionTable;
import com.intellij.javaee.model.xml.persistence.mapping.Column;
import com.intellij.javaee.model.xml.persistence.mapping.ColumnBase;
import com.intellij.javaee.model.xml.persistence.mapping.ColumnResult;
import com.intellij.javaee.model.xml.persistence.mapping.DiscriminatorType;
import com.intellij.javaee.model.xml.persistence.mapping.Embeddable;
import com.intellij.javaee.model.xml.persistence.mapping.Entity;
import com.intellij.javaee.model.xml.persistence.mapping.EntityBase;
import com.intellij.javaee.model.xml.persistence.mapping.EntityListener;
import com.intellij.javaee.model.xml.persistence.mapping.EntityMappings;
import com.intellij.javaee.model.xml.persistence.mapping.EntityResult;
import com.intellij.javaee.model.xml.persistence.mapping.Enumerated;
import com.intellij.javaee.model.xml.persistence.mapping.FetchType;
import com.intellij.javaee.model.xml.persistence.mapping.FieldResult;
import com.intellij.javaee.model.xml.persistence.mapping.GenerationType;
import com.intellij.javaee.model.xml.persistence.mapping.InheritanceType;
import com.intellij.javaee.model.xml.persistence.mapping.JoinColumn;
import com.intellij.javaee.model.xml.persistence.mapping.JoinTable;
import com.intellij.javaee.model.xml.persistence.mapping.ManyToMany;
import com.intellij.javaee.model.xml.persistence.mapping.ManyToOne;
import com.intellij.javaee.model.xml.persistence.mapping.MapKey;
import com.intellij.javaee.model.xml.persistence.mapping.MappedSuperclass;
import com.intellij.javaee.model.xml.persistence.mapping.NamedNativeQuery;
import com.intellij.javaee.model.xml.persistence.mapping.NamedQuery;
import com.intellij.javaee.model.xml.persistence.mapping.OneToMany;
import com.intellij.javaee.model.xml.persistence.mapping.OneToOne;
import com.intellij.javaee.model.xml.persistence.mapping.PersistentObjectBase;
import com.intellij.javaee.model.xml.persistence.mapping.PrimaryKeyJoinColumn;
import com.intellij.javaee.model.xml.persistence.mapping.QueryHint;
import com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase;
import com.intellij.javaee.model.xml.persistence.mapping.SecondaryTable;
import com.intellij.javaee.model.xml.persistence.mapping.SequenceGenerator;
import com.intellij.javaee.model.xml.persistence.mapping.SqlResultSetMapping;
import com.intellij.javaee.model.xml.persistence.mapping.Table;
import com.intellij.javaee.model.xml.persistence.mapping.Temporal;
import com.intellij.javaee.model.xml.persistence.mapping.TemporalType;
import com.intellij.javaee.model.xml.persistence.mapping.UniqueConstraint;
import com.intellij.javaee.module.JavaeeLibrariesUtil;
import com.intellij.javaee.util.AnnotationManipulator;
import com.intellij.javaee.util.AnnotationTextUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ORMToAnnotationsConverter
implements AnnotationManipulator<PsiModifierListOwner> {
    private final Module myModule;
    private final JavaCodeStyleManager myCodeStyleManager;
    private final Map<PsiElement, MyUsageInfo> usageInfos = new HashMap<PsiElement, MyUsageInfo>();
    private boolean myAddDefaultNames;
    private final Map<String, Pair<String, String>> myAttributeNameMap = new HashMap<String, Pair<String, String>>();

    public ORMToAnnotationsConverter(Module module) {
        this.myModule = module;
        this.myCodeStyleManager = JavaCodeStyleManager.getInstance((Project)module.getProject());
        this.myAddDefaultNames = true;
    }

    public void setAddDefaultNames(boolean addDefaultNames) {
        this.myAddDefaultNames = addDefaultNames;
    }

    private void addUsageInfo(MyUsageInfo info) {
        MyUsageInfo usageInfo;
        if (info instanceof ReplaceUsageInfo || info instanceof DeleteUsageInfo) {
            this.usageInfos.put(info.getElement(), info);
        }
        if ((usageInfo = this.usageInfos.get(info.getElement())) == null) {
            this.usageInfos.put(info.getElement(), info);
        } else if (usageInfo instanceof AddUsageInfo) {
            AddUsageInfo addUsageInfo = (AddUsageInfo)usageInfo;
            addUsageInfo.list.addAll(((AddUsageInfo)info).list);
        }
    }

    private void processUsageInfos() throws Exception {
        if (CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myModule.getProject(), this.usageInfos.keySet())) {
            Collection<MyUsageInfo> myUsageInfos = this.usageInfos.values();
            ArrayList<PsiElement> results = new ArrayList<PsiElement>();
            for (MyUsageInfo info : myUsageInfos) {
                results.add(info.processUsage());
            }
            for (PsiElement result : results) {
                if (result == null || !result.isValid()) continue;
                this.myCodeStyleManager.shortenClassReferences(result);
            }
        }
        this.clear();
    }

    private PsiAnnotation findAddedAnnotation(PsiModifierList modifierList, PsiAnnotation psiCurrentAnno, String annotationName) {
        UsageInfo info;
        if (psiCurrentAnno != null && (info = (UsageInfo)this.usageInfos.get(psiCurrentAnno)) instanceof ReplaceUsageInfo) {
            ReplaceUsageInfo replaceUsageInfo = (ReplaceUsageInfo)info;
            return (PsiAnnotation)replaceUsageInfo.myNewElement;
        }
        if (modifierList != null && (info = this.usageInfos.get(modifierList)) instanceof AddUsageInfo) {
            AddUsageInfo addUsageInfo = (AddUsageInfo)info;
            for (PsiElement psiElement : addUsageInfo.list) {
                PsiAnnotation psiAnnotation;
                if (!(psiElement instanceof PsiAnnotation) || !annotationName.equals((psiAnnotation = (PsiAnnotation)psiElement).getQualifiedName())) continue;
                return psiAnnotation;
            }
        }
        return psiCurrentAnno;
    }

    private void clear() {
        this.usageInfos.clear();
    }

    public void migrateORM(List<EntityMappings> entityMappingsList) throws Exception {
        this.clear();
        if (!this.createMissingClassesAndFields(entityMappingsList)) {
            return;
        }
        for (EntityMappings entityMappings : entityMappingsList) {
            for (Entity entity : entityMappings.getEntities()) {
                this.migrateEntity(entityMappings, entity);
            }
            for (Embeddable embeddable : entityMappings.getEmbeddables()) {
                this.migrateEmbeddable(entityMappings, embeddable);
            }
            for (MappedSuperclass mappedSuperclass : entityMappings.getMappedSuperclasses()) {
                this.migrateMappedSuperClass(entityMappings, mappedSuperclass);
            }
        }
        this.processUsageInfos();
    }

    public void applyChanges() throws Exception {
        this.processUsageInfos();
    }

    public boolean createMissingClassesAndFields(List<EntityMappings> entityMappingsList) throws Exception {
        PostprocessReformattingAspect.getInstance((Project)this.myModule.getProject()).doPostponedFormatting();
        ArrayList psiClasses = new ArrayList();
        for (EntityMappings entityMappings : entityMappingsList) {
            for (Entity entity : entityMappings.getEntities()) {
                ContainerUtil.addIfNotNull((Object)entity.getClazz().getValue(), psiClasses);
                ContainerUtil.addIfNotNull((Object)entity.getIdClass().getClazz().getValue(), psiClasses);
            }
            for (Embeddable embeddable : entityMappings.getEmbeddables()) {
                ContainerUtil.addIfNotNull((Object)embeddable.getClazz().getValue(), psiClasses);
            }
            for (MappedSuperclass mappedSuperclass : entityMappings.getMappedSuperclasses()) {
                ContainerUtil.addIfNotNull((Object)mappedSuperclass.getClazz().getValue(), psiClasses);
                ContainerUtil.addIfNotNull((Object)mappedSuperclass.getIdClass().getClazz().getValue(), psiClasses);
            }
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myModule.getProject(), psiClasses)) {
            return false;
        }
        Ref exception = new Ref();
        for (EntityMappings entityMappings : entityMappingsList) {
            Processor processor = t -> {
                PsiClass psiObjectClass;
                try {
                    psiObjectClass = this.ensureClassExists((com.intellij.javaee.model.common.persistence.mapping.PersistentObject)t);
                }
                catch (IncorrectOperationException e) {
                    Messages.showErrorDialog((Project)this.myModule.getProject(), (String)e.getMessage(), (String)IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]));
                    return true;
                }
                AccessType accessType = ORMToAnnotationsConverter.getAccessType(t, entityMappings);
                List attrList = t.getAllAttributes();
                if (psiObjectClass != null) {
                    this.ensurePropertiesImplemented(psiObjectClass, accessType, false, attrList, entityMappingsList, (Ref<Exception>)exception);
                }
                if (t instanceof EntityBase) {
                    EntityBase entityBase = (EntityBase)t;
                    GenericAttributeValue clazz = entityBase.getIdClass().getClazz();
                    PsiClass idClass = (PsiClass)clazz.getValue();
                    try {
                        PsiClass serializableClass;
                        if (!StringUtil.isEmpty((String)clazz.getStringValue()) && idClass == null) {
                            idClass = ORMToAnnotationsConverter.createClass(this.myModule, JpaUtil.getQualifiedName((PersistentObject)t, clazz.getStringValue()));
                        }
                        if (idClass != null && (serializableClass = JavaPsiFacade.getInstance((Project)idClass.getProject()).findClass("java.io.Serializable", ProjectScope.getAllScope((Project)idClass.getProject()))) != null && !idClass.isInheritor(serializableClass, true)) {
                            idClass.getImplementsList().addAfter((PsiElement)JavaPsiFacade.getInstance((Project)idClass.getProject()).getElementFactory().createClassReferenceElement(serializableClass), null);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        Messages.showErrorDialog((Project)this.myModule.getProject(), (String)e.getMessage(), (String)IdeBundle.message((String)"title.cannot.create.class", (Object[])new Object[0]));
                        return true;
                    }
                    if (idClass != null) {
                        this.ensurePropertiesImplemented(idClass, accessType, true, attrList, entityMappingsList, (Ref<Exception>)exception);
                    }
                }
                return true;
            };
            ContainerUtil.process((List)entityMappings.getEntities(), (Processor)processor);
            ContainerUtil.process((List)entityMappings.getEmbeddables(), (Processor)processor);
            ContainerUtil.process((List)entityMappings.getMappedSuperclasses(), (Processor)processor);
            if (exception.isNull()) continue;
            throw (Exception)exception.get();
        }
        return true;
    }

    private void ensurePropertiesImplemented(PsiClass psiClass, AccessType accessType, boolean idAttrsOnly, List<? extends com.intellij.javaee.model.common.persistence.mapping.AttributeBase> attrList, List<EntityMappings> entityMappingsList, Ref<Exception> exception) {
        ArrayList<PsiField> idFields = new ArrayList<PsiField>();
        for (com.intellij.javaee.model.common.persistence.mapping.AttributeBase attributeBase : attrList) {
            try {
                boolean idAttr;
                boolean bl = idAttr = attributeBase instanceof com.intellij.javaee.model.xml.persistence.mapping.Id || attributeBase instanceof com.intellij.javaee.model.xml.persistence.mapping.EmbeddedId;
                if (!idAttr && idAttrsOnly) continue;
                PsiField psiField = this.ensurePropertyExists((String)attributeBase.getName().getValue(), accessType, ORMToAnnotationsConverter.getDefaultType((AttributeBase)attributeBase, entityMappingsList), psiClass);
                if (!idAttr) continue;
                ContainerUtil.addIfNotNull((Object)psiField, idFields);
            }
            catch (IncorrectOperationException e) {
                if (!exception.isNull()) continue;
                exception.set((Object)e);
            }
        }
        ORMToAnnotationsConverter.ensureEqualsAndHashCodeImplemented(psiClass, idFields);
    }

    public static void ensureEqualsAndHashCodeImplemented(PsiClass aClass, Collection<PsiField> idFields) {
        if (idFields.isEmpty()) {
            return;
        }
        PsiField[] psiFields = idFields.toArray(new PsiField[idFields.size()]);
        new GenerateEqualsHelper(aClass.getProject(), aClass, psiFields, psiFields, PsiField.EMPTY_ARRAY, false).run();
    }

    public PsiField ensurePropertyExists(String name, AccessType accessType, String defaultType, PsiClass psiClass) throws IncorrectOperationException {
        String fixedName = ORMToAnnotationsConverter.fixPropertyName(name, PsiNameHelper.getInstance((Project)psiClass.getProject()));
        PsiMember[] psiMember = this.findPropertyPsiMember(fixedName, AccessType.FIELD, psiClass);
        if (psiMember[0] == null && (accessType == null || accessType == AccessType.FIELD)) {
            psiMember[0] = ORMToAnnotationsConverter.createPropertyField(psiClass, fixedName, fixedName, defaultType, true);
        } else if (psiMember[1] == null && accessType == AccessType.PROPERTY) {
            psiMember[1] = ORMToAnnotationsConverter.createPropertyGetter(psiClass, fixedName, defaultType, psiMember);
        }
        PsiMember targetMember = psiMember[accessType == null || accessType == AccessType.FIELD ? 0 : 1];
        assert (targetMember != null);
        this.myAttributeNameMap.put(fixedName + ":" + psiClass.getQualifiedName(), (Pair<String, String>)Pair.create((Object)(psiMember[0] == null ? null : psiMember[0].getName()), psiMember[1] == null ? null : PropertyUtil.getPropertyNameByGetter((PsiMethod)((PsiMethod)psiMember[1]))));
        if (targetMember.getContainingClass() != psiClass) {
            this.createAnnotation((PsiModifierListOwner)targetMember.getContainingClass(), "javax.persistence.MappedSuperclass", true, new String[0]);
        }
        return (PsiField)psiMember[0];
    }

    @Nullable
    public PsiClass ensureClassExists(com.intellij.javaee.model.common.persistence.mapping.PersistentObject obj) throws IncorrectOperationException {
        PsiClass aClass = (PsiClass)obj.getClazz().getValue();
        if (aClass != null) {
            return aClass;
        }
        return ORMToAnnotationsConverter.createClass(this.myModule, JpaUtil.getQualifiedName((PersistentObject)obj));
    }

    private void migrateMappedSuperClass(EntityMappings entityMappings, MappedSuperclass mappedSuperclass) throws Exception {
        PsiClass psiTargetClass = (PsiClass)mappedSuperclass.getClazz().getValue();
        if (psiTargetClass == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.MappedSuperclass", true, new String[0]);
        this.migrateEntityBase(entityMappings, (EntityBase)mappedSuperclass, psiTargetClass);
        JavaCodeStyleManager.getInstance((Project)psiTargetClass.getProject()).shortenClassReferences((PsiElement)psiTargetClass);
    }

    private void createEntityListenerAnnotations(EntityListenerMethodContainer entity) throws Exception {
        Ref ref = new Ref();
        entity.processEntityListenerMethods(null, t -> {
            if (t.getMethod() != null) {
                try {
                    this.createAnnotation((PsiModifierListOwner)t.getMethod(), t.getType().getMethodAnnotation(), true, new String[0]);
                }
                catch (IncorrectOperationException e) {
                    ref.set((Object)e);
                }
            }
            return true;
        });
        if (ref.get() != null) {
            throw (IncorrectOperationException)((Object)ref.get());
        }
    }

    private void migrateEmbeddable(EntityMappings entityMappings, Embeddable embeddable) throws Exception {
        PsiClass psiTargetClass = (PsiClass)embeddable.getClazz().getValue();
        if (psiTargetClass == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.Embeddable", true, new String[0]);
        this.migrateAttributes((PersistentObjectBase)embeddable, psiTargetClass, entityMappings);
        JavaCodeStyleManager.getInstance((Project)psiTargetClass.getProject()).shortenClassReferences((PsiElement)psiTargetClass);
    }

    private void migrateEntity(EntityMappings entityMappings, Entity entity) throws Exception {
        SequenceGenerator generator;
        String discriminatorValue;
        InheritanceType inheritanceType;
        PsiClass psiTargetClass = (PsiClass)entity.getClazz().getValue();
        if (psiTargetClass == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.Entity", true, "name", AnnotationTextUtil.quote((String)entity.getName().getValue()), AnnotationTextUtil.quote(psiTargetClass.getName()));
        this.migrateEntityBase(entityMappings, (EntityBase)entity, psiTargetClass);
        this.createTableAnnotation((PsiMember)psiTargetClass, entity.getTable(), (String)entity.getName().getValue());
        this.createSecondaryTablesAnnotation(entity.getSecondaryTables(), (PsiMember)psiTargetClass);
        if (entity.getPrimaryKeyJoinColumns().size() > 0) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.PrimaryKeyJoinColumns", true, "value", ORMToAnnotationsConverter.createPkJoinColumnsArray(entity.getPrimaryKeyJoinColumns(), (PsiMember)psiTargetClass), null);
        }
        if ((inheritanceType = (InheritanceType)entity.getInheritance().getStrategy().getValue()) != null) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.Inheritance", true, "strategy", "javax.persistence.InheritanceType." + inheritanceType.name(), "javax.persistence.InheritanceType." + InheritanceType.SINGLE_TABLE.name());
        }
        if ((discriminatorValue = (String)entity.getDiscriminatorValue().getValue()) != null) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.DiscriminatorValue", true, "value", AnnotationTextUtil.quote(discriminatorValue), null);
        }
        if (entity.getDiscriminatorColumn().getXmlTag() != null) {
            DiscriminatorType type = (DiscriminatorType)entity.getDiscriminatorColumn().getDiscriminatorType().getValue();
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.DiscriminatorColumn", true, "name", AnnotationTextUtil.quote((String)entity.getDiscriminatorColumn().getName().getValue()), null, "discriminatorType", type == null ? null : "javax.persistence.DiscriminatorType." + type.name(), "javax.persistence.DiscriminatorType." + DiscriminatorType.STRING.name(), "columnDefinition", AnnotationTextUtil.quote((String)entity.getDiscriminatorColumn().getColumnDefinition().getValue()), null, "length", ORMToAnnotationsConverter.toString(entity.getDiscriminatorColumn().getLength().getValue()), null);
        }
        if (entity.getSequenceGenerator().getXmlTag() != null) {
            generator = entity.getSequenceGenerator();
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.SequenceGenerator", true, "name", AnnotationTextUtil.quote((String)generator.getName().getValue()), null, "sequenceName", AnnotationTextUtil.quote((String)generator.getTableName().getValue()), null, "initialValue", ORMToAnnotationsConverter.toString(generator.getInitialValue().getValue()), null, "allocationSize", ORMToAnnotationsConverter.toString(generator.getAllocationSize().getValue()), null);
        }
        if (entity.getTableGenerator().getXmlTag() != null) {
            generator = entity.getTableGenerator();
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.TableGenerator", true, "name", AnnotationTextUtil.quote((String)generator.getName().getValue()), null, "catalog", AnnotationTextUtil.quote(generator.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote(generator.getSchema().getStringValue()), null, "pkColumnName", AnnotationTextUtil.quote(generator.getPkColumnName().getStringValue()), null, "valueColumnName", AnnotationTextUtil.quote(generator.getValueColumnName().getStringValue()), null, "pkColumnValue", AnnotationTextUtil.quote(generator.getPkColumnValue().getStringValue()), null, "initialValue", ORMToAnnotationsConverter.toString(generator.getInitialValue().getValue()), null, "allocationSize", ORMToAnnotationsConverter.toString(generator.getAllocationSize().getValue()), null, "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(generator.getUniqueConstraints(), (PsiMember)psiTargetClass), null);
        }
        this.createAttributeOverridesAnnotation(entity.getAttributeOverrides(), (PsiMember)psiTargetClass);
        this.createAssociationOverridesAnnotation(entity.getAssociationOverrides(), (PsiMember)psiTargetClass);
        this.createNamedQueriesAnnotation(entity.getNamedQueries(), psiTargetClass, false);
        this.createNamedQueriesAnnotation(entity.getNamedNativeQueries(), psiTargetClass, true);
        this.createSqlResultSetMappingsAnnotation(entity.getSqlResultSetMappings(), psiTargetClass, entityMappings);
        JavaCodeStyleManager.getInstance((Project)psiTargetClass.getProject()).shortenClassReferences((PsiElement)psiTargetClass);
    }

    private void createSqlResultSetMappingsAnnotation(List<SqlResultSetMapping> list, PsiClass psiTargetClass, EntityMappings entityMappings) throws Exception {
        Ref error = new Ref();
        this.createMultiAnnotation(list, (PsiMember)psiTargetClass, "javax.persistence.SqlResultSetMapping", "javax.persistence.SqlResultSetMappings", s -> {
            try {
                return this.createSqlResultSetMappingsAnnotationText((SqlResultSetMapping)s, psiTargetClass, entityMappings);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private String createSqlResultSetMappingsAnnotationText(SqlResultSetMapping mapping, PsiClass psiTargetClass, EntityMappings entityMappings) throws IncorrectOperationException {
        ArrayList<String> entityResultList = new ArrayList<String>();
        for (EntityResult entityResult : mapping.getEntityResults()) {
            String className = ORMToAnnotationsConverter.getClassQName(entityResult.getEntityClass().getStringValue(), entityMappings.getPackage().getStringValue());
            ArrayList<String> fieldResultList = new ArrayList<String>();
            for (FieldResult fieldResult : entityResult.getFieldResults()) {
                String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, "javax.persistence.FieldResult", true, null, "name", AnnotationTextUtil.quote((String)fieldResult.getName().getValue()), null, "column", AnnotationTextUtil.quote(fieldResult.getColumn().getStringValue()), null);
                fieldResultList.add(text);
            }
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, "javax.persistence.EntityResult", true, null, "entityClass", className == null ? null : className + ".class", null, "fields", AnnotationTextUtil.createStringArrayInitializer(fieldResultList, new String[0]), null, "discriminatorColumn", AnnotationTextUtil.quote(entityResult.getDiscriminatorColumn().getStringValue()), null);
            entityResultList.add(text);
        }
        ArrayList<String> columnResultList = new ArrayList<String>();
        for (ColumnResult result : mapping.getColumnResults()) {
            columnResultList.add(result.getName().getStringValue());
        }
        return AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, "javax.persistence.SqlResultSetMapping", false, null, "name", AnnotationTextUtil.quote((String)mapping.getName().getValue()), null, "entities", AnnotationTextUtil.createStringArrayInitializer(entityResultList, new String[0]), null, "columns", AnnotationTextUtil.createStringArrayInitializer(columnResultList, "\""), null);
    }

    private void createNamedQueriesAnnotation(List<? extends NamedQuery> list, final PsiClass psiTargetClass, boolean isNative) throws Exception {
        final Ref error = new Ref();
        this.createMultiAnnotation(list, (PsiMember)psiTargetClass, isNative ? "javax.persistence.NamedNativeQuery" : "javax.persistence.NamedQuery", isNative ? "javax.persistence.NamedNativeQueries" : "javax.persistence.NamedQueries", new Function<NamedQuery, String>(){

            public String fun(NamedQuery s) {
                try {
                    return ORMToAnnotationsConverter.this.createNamedQueryAnnotationText(s, psiTargetClass);
                }
                catch (IncorrectOperationException e) {
                    error.set((Object)e);
                    return null;
                }
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private String createNamedQueryAnnotationText(NamedQuery queryBase, PsiClass psiTargetClass) throws IncorrectOperationException {
        if (queryBase instanceof NamedNativeQuery) {
            NamedNativeQuery query = (NamedNativeQuery)queryBase;
            String resultClass = query.getResultClass().getStringValue();
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, "javax.persistence.NamedQuery", true, null, "name", AnnotationTextUtil.quote((String)query.getName().getValue()), null, "query", AnnotationTextUtil.quote((String)query.getQuery().getValue()), null, "hints", ORMToAnnotationsConverter.createHintsArray(query.getHints(), psiTargetClass), null, "resultClass", resultClass == null ? null : resultClass + ".class", null, "resultSetMapping", AnnotationTextUtil.quote((String)query.getResultSetMapping().getValue()), null);
        }
        NamedQuery query = queryBase;
        return AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, "javax.persistence.NamedQuery", true, null, "name", AnnotationTextUtil.quote((String)query.getName().getValue()), null, "query", AnnotationTextUtil.quote((String)query.getQuery().getValue()), null, "hints", ORMToAnnotationsConverter.createHintsArray(query.getHints(), psiTargetClass), null);
    }

    private static String createHintsArray(List<QueryHint> hints, PsiClass psiTargetClass) throws IncorrectOperationException {
        if (hints.size() == 0) {
            return null;
        }
        ArrayList<String> annoList = new ArrayList<String>();
        for (QueryHint hint : hints) {
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiTargetClass, "javax.persistence.QueryHint", true, null, "name", AnnotationTextUtil.quote((String)hint.getName().getValue()), null, "value", AnnotationTextUtil.quote((String)hint.getValue().getValue()), null);
            annoList.add(text);
        }
        return AnnotationTextUtil.createStringArrayInitializer(annoList, new String[0]);
    }

    private void migrateEntityBase(EntityMappings entityMappings, EntityBase entity, PsiClass psiTargetClass) throws Exception {
        String idClass;
        Boolean exludeSuperListeners;
        this.createEntityListenerAnnotations((EntityListenerMethodContainer)entity);
        Boolean exludeDefListeners = (Boolean)entity.getExcludeDefaultListeners().getValue();
        if (exludeDefListeners != null && exludeDefListeners.booleanValue()) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.ExcludeDefaultListeners", true, new String[0]);
        }
        if ((exludeSuperListeners = (Boolean)entity.getExcludeSuperclassListeners().getValue()) != null && exludeSuperListeners.booleanValue()) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.ExcludeSuperclassListeners", true, new String[0]);
        }
        if (entity.getEntityListeners().getEntityListeners().size() > 0) {
            ArrayList<String> classNamesList = new ArrayList<String>();
            for (EntityListener entityListener : entity.getEntityListeners().getEntityListeners()) {
                classNamesList.add(entityListener.getClazz().getStringValue());
                PsiClass psiListenerClass = (PsiClass)entityListener.getClazz().getValue();
                if (psiListenerClass == null) continue;
                this.createEntityListenerAnnotations((EntityListenerMethodContainer)entityListener);
            }
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.EntityListeners", true, "value", AnnotationTextUtil.createStringArrayInitializer(classNamesList, null, ".class"), null);
        }
        if (entity.getIdClass().getXmlTag() != null && (idClass = ORMToAnnotationsConverter.getClassQName(entity.getIdClass().getClazz().getStringValue(), entityMappings.getPackage().getStringValue())) != null) {
            this.createAnnotation((PsiModifierListOwner)psiTargetClass, "javax.persistence.IdClass", true, "value", idClass + ".class", null);
        }
        this.migrateAttributes((PersistentObjectBase)entity, psiTargetClass, entityMappings);
    }

    private void migrateAttributes(PersistentObjectBase persistent, PsiClass psiTargetClass, EntityMappings entityMappings) throws IncorrectOperationException {
        Ref error = new Ref();
        AccessType accessType = ORMToAnnotationsConverter.getAccessType(persistent, entityMappings);
        String defaultPackage = entityMappings.getPackage().getStringValue();
        for (PersistentAttribute attribute : persistent.getObjectModelHelper().getAttributes()) {
            try {
                if (attribute instanceof Basic) {
                    Basic _basic = (Basic)attribute;
                    this.createBasicAttribute(_basic, accessType, psiTargetClass);
                    continue;
                }
                if (attribute instanceof EmbeddedId) {
                    EmbeddedId _embeddedId = (EmbeddedId)attribute;
                    this.createEmbeddedIdAttribute(_embeddedId, accessType, psiTargetClass);
                    continue;
                }
                if (attribute instanceof Id) {
                    Id _id = (Id)attribute;
                    this.createIdAttribute(_id, accessType, psiTargetClass);
                    continue;
                }
                if (attribute instanceof Embedded) {
                    Embedded _embedded = (Embedded)attribute;
                    this.createEmbeddedAttribute(_embedded, accessType, psiTargetClass);
                    continue;
                }
                if (attribute instanceof Version) {
                    Version _version = (Version)attribute;
                    this.createVersionAttribute(_version, accessType, psiTargetClass);
                    continue;
                }
                if (attribute instanceof Transient) {
                    Transient _aTransient = (Transient)attribute;
                    this.createTransientAttribute(_aTransient, accessType, psiTargetClass);
                    continue;
                }
                if (attribute instanceof com.intellij.javaee.model.common.persistence.mapping.ManyToOne) {
                    com.intellij.javaee.model.common.persistence.mapping.ManyToOne _manyToOne = (com.intellij.javaee.model.common.persistence.mapping.ManyToOne)attribute;
                    this.createManyToOneAttribute(_manyToOne, accessType, psiTargetClass, defaultPackage);
                    continue;
                }
                if (attribute instanceof com.intellij.javaee.model.common.persistence.mapping.OneToMany) {
                    com.intellij.javaee.model.common.persistence.mapping.OneToMany _oneToMany = (com.intellij.javaee.model.common.persistence.mapping.OneToMany)attribute;
                    this.createOneToManyAttribute(_oneToMany, accessType, psiTargetClass, defaultPackage);
                    continue;
                }
                if (attribute instanceof com.intellij.javaee.model.common.persistence.mapping.OneToOne) {
                    com.intellij.javaee.model.common.persistence.mapping.OneToOne _oneToOne = (com.intellij.javaee.model.common.persistence.mapping.OneToOne)attribute;
                    this.createOneToOneAttribute(_oneToOne, accessType, psiTargetClass, defaultPackage);
                    continue;
                }
                if (!(attribute instanceof com.intellij.javaee.model.common.persistence.mapping.ManyToMany)) continue;
                com.intellij.javaee.model.common.persistence.mapping.ManyToMany _manyToMany = (com.intellij.javaee.model.common.persistence.mapping.ManyToMany)attribute;
                this.createManyToManyAttribute(_manyToMany, accessType, psiTargetClass, defaultPackage);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
            }
        }
    }

    public void createManyToManyAttribute(com.intellij.javaee.model.common.persistence.mapping.ManyToMany _manyToMany, AccessType accessType, PsiClass psiTargetClass, String defaultPackage) throws IncorrectOperationException {
        ManyToMany manyToMany = (ManyToMany)_manyToMany;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)manyToMany.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)manyToMany.getFetch().getValue();
        String targetEntity = ORMToAnnotationsConverter.getClassQName(manyToMany.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.ManyToMany", true, "cascade", this.createCascadeArrayInitializer(manyToMany.getCascade()), null, "fetch", fetch == null ? null : "javax.persistence.FetchType." + fetch.name(), null, "mappedBy", AnnotationTextUtil.quote(manyToMany.getMappedBy().getStringValue()), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, "javax.persistence.OneToOne", "javax.persistence.ManyToOne", "javax.persistence.OneToMany");
        if (manyToMany.getMapKey().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.MapKey", true, "name", AnnotationTextUtil.quote(manyToMany.getMapKey().getTargetAttribute().getStringValue()), null);
        }
        if (manyToMany.getOrderBy().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.OrderBy", true, "value", AnnotationTextUtil.quote((String)manyToMany.getOrderBy().getValue()), null);
        }
        this.createJoinTableOrColumnsAnnotation((RelationAttributeBase)manyToMany, psiMember);
    }

    public void createOneToOneAttribute(com.intellij.javaee.model.common.persistence.mapping.OneToOne _oneToOne, AccessType accessType, PsiClass psiTargetClass, String defaultPackage) throws IncorrectOperationException {
        OneToOne oneToOne = (OneToOne)_oneToOne;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)oneToOne.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)oneToOne.getFetch().getValue();
        Boolean optional = (Boolean)oneToOne.getOptional().getValue();
        String targetEntity = ORMToAnnotationsConverter.getClassQName(oneToOne.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.OneToOne", true, "cascade", this.createCascadeArrayInitializer(oneToOne.getCascade()), null, "fetch", fetch == null ? null : "javax.persistence.FetchType." + fetch.name(), null, "mappedBy", AnnotationTextUtil.quote(oneToOne.getMappedBy().getStringValue()), null, "optional", optional == null ? null : optional.toString(), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, "javax.persistence.ManyToMany", "javax.persistence.ManyToOne", "javax.persistence.OneToMany");
        this.createJoinTableOrColumnsAnnotation((RelationAttributeBase)oneToOne, psiMember);
    }

    public void createOneToManyAttribute(com.intellij.javaee.model.common.persistence.mapping.OneToMany _oneToMany, AccessType accessType, PsiClass psiTargetClass, String defaultPackage) throws IncorrectOperationException {
        OneToMany oneToMany = (OneToMany)_oneToMany;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)oneToMany.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)oneToMany.getFetch().getValue();
        String targetEntity = ORMToAnnotationsConverter.getClassQName(oneToMany.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.OneToMany", true, "cascade", this.createCascadeArrayInitializer(oneToMany.getCascade()), null, "fetch", fetch == null ? null : "javax.persistence.FetchType." + fetch.name(), null, "mappedBy", AnnotationTextUtil.quote(oneToMany.getMappedBy().getStringValue()), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, "javax.persistence.ManyToMany", "javax.persistence.ManyToOne", "javax.persistence.OneToOne");
        if (oneToMany.getMapKey().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.MapKey", true, "name", AnnotationTextUtil.quote(oneToMany.getMapKey().getTargetAttribute().getStringValue()), null);
        }
        if (oneToMany.getOrderBy().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.OrderBy", true, "value", AnnotationTextUtil.quote((String)oneToMany.getOrderBy().getValue()), null);
        }
        this.createJoinTableOrColumnsAnnotation((RelationAttributeBase)oneToMany, psiMember);
    }

    public void createManyToOneAttribute(com.intellij.javaee.model.common.persistence.mapping.ManyToOne _manyToOne, AccessType accessType, PsiClass psiTargetClass, String defaultPackage) throws IncorrectOperationException {
        ManyToOne manyToOne = (ManyToOne)_manyToOne;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)manyToOne.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)manyToOne.getFetch().getValue();
        Boolean optional = (Boolean)manyToOne.getOptional().getValue();
        String targetEntity = ORMToAnnotationsConverter.getClassQName(manyToOne.getTargetEntityClass().getStringValue(), defaultPackage);
        String targetEntityDef = ORMToAnnotationsConverter.getTargetEntityClassName(psiMember[0]);
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.ManyToOne", true, "cascade", this.createCascadeArrayInitializer(manyToOne.getCascade()), null, "fetch", fetch == null ? null : "javax.persistence.FetchType." + fetch.name(), null, "optional", optional == null ? null : optional.toString(), null, "targetEntity", targetEntity == null ? null : targetEntity + ".class", targetEntityDef == null ? null : targetEntityDef + ".class");
        this.dropAnnotations((PsiModifierListOwner[])psiMember, "javax.persistence.ManyToMany", "javax.persistence.OneToMany", "javax.persistence.OneToOne");
        this.createJoinTableOrColumnsAnnotation((RelationAttributeBase)manyToOne, psiMember);
    }

    public void createTransientAttribute(Transient _aTransient, AccessType accessType, PsiClass psiTargetClass) throws IncorrectOperationException {
        com.intellij.javaee.model.xml.persistence.mapping.Transient aTransient = (com.intellij.javaee.model.xml.persistence.mapping.Transient)_aTransient;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)aTransient.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Transient", true, new String[0]);
    }

    public void createVersionAttribute(Version _version, AccessType accessType, PsiClass psiTargetClass) throws IncorrectOperationException {
        com.intellij.javaee.model.xml.persistence.mapping.Version version = (com.intellij.javaee.model.xml.persistence.mapping.Version)_version;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)version.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Version", true, new String[0]);
        this.createAttributeWithColumnCommonAnnotations((AttributeWithColumn)version, psiMember);
    }

    public void createEmbeddedAttribute(Embedded _embedded, AccessType accessType, PsiClass psiTargetClass) throws IncorrectOperationException {
        com.intellij.javaee.model.xml.persistence.mapping.Embedded embedded = (com.intellij.javaee.model.xml.persistence.mapping.Embedded)_embedded;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)embedded.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Embedded", true, new String[0]);
        this.createAttributeOverridesAnnotation(embedded.getAttributeOverrides(), psiMember[0]);
        this.dropAnnotations((PsiModifierListOwner)psiMember[1], "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
    }

    public void createBasicAttribute(Basic _basic, AccessType accessType, PsiClass psiTargetClass) throws IncorrectOperationException {
        com.intellij.javaee.model.xml.persistence.mapping.Basic basic = (com.intellij.javaee.model.xml.persistence.mapping.Basic)_basic;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)basic.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        FetchType fetch = (FetchType)basic.getFetch().getValue();
        Boolean optional = (Boolean)basic.getOptional().getValue();
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Basic", true, "fetch", fetch == null ? null : "javax.persistence.FetchType." + fetch.name(), "javax.persistence.FetchType." + FetchType.EAGER.name(), "optional", optional == null ? null : optional.toString(), null);
        if (basic.getLob().getXmlTag() != null) {
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Lob", true, new String[0]);
        }
        if (basic.getEnumerated().getXmlTag() != null) {
            Enumerated enumerated = (Enumerated)basic.getEnumerated().getValue();
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Enumerated", true, "value", enumerated == null ? null : "javax.persistence.EnumType." + enumerated.name(), "javax.persistence.EnumType." + Enumerated.STRING.name());
        }
        this.createAttributeWithColumnCommonAnnotations((AttributeWithColumn)basic, psiMember);
    }

    public void createEmbeddedIdAttribute(EmbeddedId _embeddedId, AccessType accessType, PsiClass psiTargetClass) throws IncorrectOperationException {
        com.intellij.javaee.model.xml.persistence.mapping.EmbeddedId embeddedId = (com.intellij.javaee.model.xml.persistence.mapping.EmbeddedId)_embeddedId;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)embeddedId.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.EmbeddedId", true, new String[0]);
        this.createAttributeOverridesAnnotation(embeddedId.getAttributeOverrides(), psiMember[0]);
        this.dropAnnotations((PsiModifierListOwner)psiMember[1], "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
    }

    public void createIdAttribute(Id _id, AccessType accessType, PsiClass psiTargetClass) throws IncorrectOperationException {
        com.intellij.javaee.model.xml.persistence.mapping.Id id = (com.intellij.javaee.model.xml.persistence.mapping.Id)_id;
        PsiMember[] psiMember = this.findPropertyPsiMember((String)id.getName().getValue(), accessType, psiTargetClass);
        if (psiMember[0] == null) {
            return;
        }
        this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Id", true, new String[0]);
        if (id.getGeneratedValue().getXmlTag() != null) {
            GenerationType generatorType = (GenerationType)id.getGeneratedValue().getStrategy().getValue();
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.GeneratedValue", true, "strategy", generatorType == null ? null : "javax.persistence.GenerationType." + generatorType.name(), "javax.persistence.GenerationType." + GenerationType.AUTO.name(), "generator", AnnotationTextUtil.quote((String)id.getGeneratedValue().getGenerator().getValue()), null);
        }
        this.createAttributeWithColumnCommonAnnotations((AttributeWithColumn)id, psiMember);
    }

    private void createAttributeWithColumnCommonAnnotations(AttributeWithColumn attributeWithColumn, PsiMember[] psiMember) throws IncorrectOperationException {
        if (attributeWithColumn.getTemporal().getValue() != null) {
            Temporal temporal = (Temporal)attributeWithColumn.getTemporal().getValue();
            this.createAnnotation((PsiModifierListOwner[])psiMember, "javax.persistence.Temporal", true, "value", temporal == null ? null : "javax.persistence.TemporalType." + temporal.name(), "javax.persistence.TemporalType." + TemporalType.TIMESTAMP.name());
        }
        if (attributeWithColumn.getColumn().getXmlTag() != null) {
            this.createColumnAnnotation(psiMember[0], (ColumnBase)attributeWithColumn.getColumn(), (String)attributeWithColumn.getName().getValue());
            this.dropAnnotations((PsiModifierListOwner)psiMember[1], ORMToAnnotationsConverter.getColumnAnnotationName((ColumnBase)attributeWithColumn.getColumn()));
        }
    }

    private String createCascadeArrayInitializer(CascadeType cascade) {
        ArrayList<String> list = new ArrayList<String>();
        if (Boolean.TRUE.equals(cascade.getCascadeAll().getValue())) {
            list.add("ALL");
        }
        if (Boolean.TRUE.equals(cascade.getCascadeMerge().getValue())) {
            list.add("MERGE");
        }
        if (Boolean.TRUE.equals(cascade.getCascadePersist().getValue())) {
            list.add("PERSIST");
        }
        if (Boolean.TRUE.equals(cascade.getCascadeRefresh().getValue())) {
            list.add("REFRESH");
        }
        if (Boolean.TRUE.equals(cascade.getCascadeRemove().getValue())) {
            list.add("REMOVE");
        }
        return AnnotationTextUtil.createStringArrayInitializer(list, "javax.persistence.CascadeType.", "");
    }

    private void createJoinTableOrColumnsAnnotation(RelationAttributeBase attribute, PsiMember[] psiMember) throws IncorrectOperationException {
        RelationAttributeBase.NonManyToManyBase nonManyToManyBase;
        if (attribute.getJoinTable().getXmlTag() != null) {
            this.createTableAnnotation(psiMember[0], (Table)attribute.getJoinTable(), null);
            this.dropAnnotations((PsiModifierListOwner)psiMember[1], ORMToAnnotationsConverter.getTableAnnotationName((Table)attribute.getJoinTable()));
        } else if (attribute instanceof RelationAttributeBase.NonManyToManyBase && (nonManyToManyBase = (RelationAttributeBase.NonManyToManyBase)attribute).getJoinColumns().size() > 0) {
            String columnNameDef = null;
            this.createJoinColumnsAnnotation(nonManyToManyBase.getJoinColumns(), psiMember[0], columnNameDef);
            this.dropAnnotations((PsiModifierListOwner)psiMember[1], "javax.persistence.JoinColumn", "javax.persistence.JoinColumns");
        }
    }

    private void createSecondaryTablesAnnotation(List<SecondaryTable> list, PsiMember psiMember) throws Exception {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables", s -> {
            try {
                return this.createTableAnnotationText(psiMember, (Table)s, null, null);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private <T> void createMultiAnnotation(List<? extends T> list, PsiMember psiMember, String singleAnnoName, String multiAnnoName, Function<T, String> function) throws IncorrectOperationException {
        AnnotationTextUtil.createMultiAnnotation(ContainerUtil.mapNotNull(list, function), psiMember, singleAnnoName, multiAnnoName, this);
    }

    private void createAttributeOverridesAnnotation(List<AttributeOverride> list, PsiMember psiMember) throws IncorrectOperationException {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", s -> {
            try {
                String columnAnno = this.createColumnAnnotationText(psiMember, (ColumnBase)s.getColumn(), (String)s.getName().getValue(), null);
                return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, "javax.persistence.AttributeOverride", true, null, "name", AnnotationTextUtil.quote((String)s.getName().getValue()), null, "column", columnAnno, null);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private void createAssociationOverridesAnnotation(List<AssociationOverride> list, PsiMember psiMember) throws IncorrectOperationException {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides", s -> {
            try {
                String joinColumns = AnnotationTextUtil.createStringArrayInitializer(this.createColumnsAnnosList(s.getJoinColumns(), psiMember), new String[0]);
                return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, "javax.persistence.AssociationOverride", true, null, "name", AnnotationTextUtil.quote((String)s.getName().getValue()), null, "joinColumns", joinColumns, null);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private void createJoinColumnsAnnotation(List<JoinColumn> list, PsiMember psiMember, String columnNameDef) throws IncorrectOperationException {
        Ref error = new Ref();
        this.createMultiAnnotation(list, psiMember, "javax.persistence.JoinColumn", "javax.persistence.JoinColumns", s -> {
            try {
                return this.createColumnAnnotationText(psiMember, (ColumnBase)s, columnNameDef, null);
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e);
                return null;
            }
        });
        if (!error.isNull()) {
            throw (IncorrectOperationException)((Object)error.get());
        }
    }

    private List<String> createColumnsAnnosList(List<? extends ColumnBase> columns, PsiMember psiMember) throws IncorrectOperationException {
        ArrayList<String> annoList = new ArrayList<String>();
        for (ColumnBase columnBase : columns) {
            String text = this.createColumnAnnotationText(psiMember, columnBase, null, null);
            annoList.add(text);
        }
        return annoList;
    }

    private void createColumnAnnotation(PsiMember psiMember, ColumnBase column, String defColumnName) throws IncorrectOperationException {
        if (column.getXmlTag() == null) {
            return;
        }
        PsiModifierList modifierList = psiMember.getModifierList();
        String annotationName = ORMToAnnotationsConverter.getColumnAnnotationName(column);
        PsiAnnotation annotation = modifierList.findAnnotation(annotationName);
        String text = this.createColumnAnnotationText(psiMember, column, defColumnName, annotation);
        this.addAnnotation((PsiModifierListOwner)psiMember, text, annotation);
    }

    private void createTableAnnotation(PsiMember psiMember, Table table, String defaultTableName) throws IncorrectOperationException {
        if (table.getXmlTag() == null) {
            return;
        }
        PsiModifierList modifierList = psiMember.getModifierList();
        PsiAnnotation annotation = modifierList.findAnnotation(ORMToAnnotationsConverter.getTableAnnotationName(table));
        String text = this.createTableAnnotationText(psiMember, table, annotation, defaultTableName);
        this.addAnnotation((PsiModifierListOwner)psiMember, text, annotation);
    }

    @Nullable
    private String createColumnAnnotationText(PsiMember psiMember, ColumnBase columnBase, String defColumnName, PsiAnnotation curAnnotation) throws IncorrectOperationException {
        if (columnBase.getXmlTag() == null) {
            return null;
        }
        String realDefColumnName = this.myAddDefaultNames ? null : defColumnName;
        Boolean unique = (Boolean)columnBase.getUnique().getValue();
        Boolean nullable = (Boolean)columnBase.getNullable().getValue();
        Boolean insertable = (Boolean)columnBase.getInsertable().getValue();
        Boolean updatable = (Boolean)columnBase.getUpdatable().getValue();
        String annotationName = ORMToAnnotationsConverter.getColumnAnnotationName(columnBase);
        if (columnBase instanceof Column) {
            Column column = (Column)columnBase;
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, annotationName, true, curAnnotation, "name", AnnotationTextUtil.quote(columnBase.getName().getStringValue()), AnnotationTextUtil.quote(realDefColumnName), "unique", unique == null ? null : unique.toString(), null, "nullable", nullable == null ? null : nullable.toString(), null, "insertable", insertable == null ? null : insertable.toString(), null, "updatable", updatable == null ? null : updatable.toString(), null, "columnDefinition", AnnotationTextUtil.quote((String)columnBase.getColumnDefinition().getValue()), null, "table", AnnotationTextUtil.quote(columnBase.getTable().getStringValue()), null, "length", ORMToAnnotationsConverter.toString(column.getLength().getValue()), null, "precision", ORMToAnnotationsConverter.toString(column.getPrecision().getValue()), null, "scale", ORMToAnnotationsConverter.toString(column.getScale().getValue()), null);
        }
        if (columnBase instanceof JoinColumn) {
            JoinColumn column = (JoinColumn)columnBase;
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, annotationName, true, curAnnotation, "name", AnnotationTextUtil.quote(columnBase.getName().getStringValue()), AnnotationTextUtil.quote(realDefColumnName), "referencedColumnName", AnnotationTextUtil.quote((String)column.getReferencedColumnName().getValue()), null, "unique", unique == null ? null : unique.toString(), null, "nullable", nullable == null ? null : nullable.toString(), null, "insertable", insertable == null ? null : insertable.toString(), null, "updatable", updatable == null ? null : updatable.toString(), null, "columnDefinition", AnnotationTextUtil.quote((String)columnBase.getColumnDefinition().getValue()), null, "table", AnnotationTextUtil.quote(columnBase.getTable().getStringValue()), null);
        }
        assert (false) : columnBase;
        return null;
    }

    private static String getColumnAnnotationName(ColumnBase columnBase) {
        return columnBase instanceof JoinColumn ? "javax.persistence.JoinColumn" : "javax.persistence.Column";
    }

    private static String getTableAnnotationName(Table table) {
        if (table instanceof JoinTable) {
            return "javax.persistence.JoinTable";
        }
        if (table instanceof CollectionTable) {
            return "javax.persistence.CollectionTable";
        }
        if (table instanceof SecondaryTable) {
            return "javax.persistence.SecondaryTable";
        }
        return "javax.persistence.Table";
    }

    public PsiMember[] findPropertyPsiMember(String name, AccessType type, PsiClass psiTargetClass) throws IncorrectOperationException {
        PsiMember[] result = new PsiMember[]{null, null};
        Pair<String, String> pair = this.myAttributeNameMap.get(name + ":" + psiTargetClass.getQualifiedName());
        PsiField psiField = psiTargetClass.findFieldByName(pair != null ? (String)pair.getFirst() : name, true);
        PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)psiTargetClass, (String)(pair != null ? (String)pair.getSecond() : name), (boolean)false, (boolean)true);
        result[type == null || type == AccessType.FIELD ? 0 : 1] = psiField;
        result[type == null || type == AccessType.FIELD ? 1 : 0] = getter;
        return result;
    }

    private static AccessType getAccessType(PersistentObjectBase obj, EntityMappings entityMappings) {
        AccessType access = (AccessType)obj.getAccess().getValue();
        AccessType defaultAccess = (AccessType)entityMappings.getAccess().getValue();
        if (access != null) {
            return access;
        }
        if (defaultAccess != null) {
            return defaultAccess;
        }
        return AccessType.PROPERTY;
    }

    @Nullable
    private String createTableAnnotationText(PsiMember psiMember, Table tableBase, PsiAnnotation curAnnotation, String defaultTableName) throws IncorrectOperationException {
        String annotationName = ORMToAnnotationsConverter.getTableAnnotationName(tableBase);
        if (tableBase instanceof JoinTable) {
            JoinTable table = (JoinTable)tableBase;
            String joinColumns = AnnotationTextUtil.createStringArrayInitializer(this.createColumnsAnnosList(table.getJoinColumns(), psiMember), new String[0]);
            String inverseJoinColumns = AnnotationTextUtil.createStringArrayInitializer(this.createColumnsAnnosList(table.getInverseJoinColumns(), psiMember), new String[0]);
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, annotationName, true, curAnnotation, "catalog", AnnotationTextUtil.quote(table.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote(table.getSchema().getStringValue()), null, "name", AnnotationTextUtil.quote(table.getTableName().getStringValue()), AnnotationTextUtil.quote(defaultTableName), "joinColumns", joinColumns, null, "inverseJoinColumns", inverseJoinColumns, null, "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(table.getUniqueConstraints(), psiMember), null);
        }
        if (tableBase instanceof SecondaryTable) {
            SecondaryTable table = (SecondaryTable)tableBase;
            String pkJoinColumns = ORMToAnnotationsConverter.createPkJoinColumnsArray(table.getPrimaryKeyJoinColumns(), psiMember);
            return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, annotationName, true, curAnnotation, "catalog", AnnotationTextUtil.quote(table.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote(table.getSchema().getStringValue()), null, "name", AnnotationTextUtil.quote(table.getTableName().getStringValue()), AnnotationTextUtil.quote(defaultTableName), "pkJoinColumns", pkJoinColumns, null, "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(table.getUniqueConstraints(), psiMember), null);
        }
        Table table = tableBase;
        return AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, annotationName, true, curAnnotation, "catalog", AnnotationTextUtil.quote(table.getCatalog().getStringValue()), null, "schema", AnnotationTextUtil.quote(table.getSchema().getStringValue()), null, "name", AnnotationTextUtil.quote(table.getTableName().getStringValue()), AnnotationTextUtil.quote(defaultTableName), "uniqueConstraints", ORMToAnnotationsConverter.createUniqueConstraintsArray(table.getUniqueConstraints(), psiMember), null);
    }

    private static String createPkJoinColumnsArray(List<PrimaryKeyJoinColumn> primaryKeyJoinColumns, PsiMember psiMember) throws IncorrectOperationException {
        ArrayList<String> annosList = new ArrayList<String>();
        for (PrimaryKeyJoinColumn column : primaryKeyJoinColumns) {
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, "javax.persistence.PrimaryKeyJoinColumn", true, null, "name", AnnotationTextUtil.quote(column.getName().getStringValue()), null, "referencedColumnName", AnnotationTextUtil.quote((String)column.getReferencedColumnName().getValue()), null, "columnDefinition", AnnotationTextUtil.quote((String)column.getColumnDefinition().getValue()), null);
            annosList.add(text);
        }
        return AnnotationTextUtil.createStringArrayInitializer(annosList, new String[0]);
    }

    private static String createUniqueConstraintsArray(List<UniqueConstraint> uniqueConstraints, PsiMember psiMember) throws IncorrectOperationException {
        ArrayList<String> annosList = new ArrayList<String>();
        for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
            String text = AnnotationTextUtil.createAnnotationText((PsiElement)psiMember, "javax.persistence.UniqueConstraint", true, null, "columnNames", AnnotationTextUtil.createGenericValueArrayInitializer(uniqueConstraint.getColumnNames(), "\""), null);
            annosList.add(text);
        }
        return AnnotationTextUtil.createStringArrayInitializer(annosList, new String[0]);
    }

    @Nullable
    public static PsiClass createClass(Module module, String classQName) throws IncorrectOperationException {
        if (classQName == null) {
            return null;
        }
        String pkgName = StringUtil.getPackageName((String)classQName);
        PsiDirectory psiDirectory = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)(StringUtil.isNotEmpty((String)pkgName) ? pkgName : ""), null, (boolean)false);
        if (psiDirectory == null) {
            return null;
        }
        return CreateClassUtil.createClassNamed((String)classQName, (String)"#DEFAULT_CLASS_TEMPLATE", (PsiDirectory)psiDirectory);
    }

    private static PsiMethod createPropertyGetter(PsiClass psiTargetClass, String fixedName, String defaultType, PsiMember[] psiMember) throws IncorrectOperationException {
        String fieldName = ORMToAnnotationsConverter.fixFieldName(fixedName, psiTargetClass.getManager());
        PsiField field = psiTargetClass.findFieldByName(fieldName, false);
        if (field == null) {
            field = ORMToAnnotationsConverter.createPropertyField(psiTargetClass, fieldName, fixedName, defaultType, false);
        }
        PsiMethod psiGetter = PropertyUtil.generateGetterPrototype((PsiField)field);
        PsiMethod psiSetter = PropertyUtil.generateSetterPrototype((PsiField)field);
        if (!PropertyUtil.getPropertyNameByGetter((PsiMethod)psiGetter).equals(fixedName)) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiTargetClass.getProject()).getElementFactory();
            psiGetter.getNameIdentifier().replace((PsiElement)factory.createIdentifier("get" + StringUtil.capitalize((String)fixedName)));
            psiSetter.getNameIdentifier().replace((PsiElement)factory.createIdentifier("set" + StringUtil.capitalize((String)fixedName)));
        }
        PsiMethod psiMethod = (PsiMethod)psiTargetClass.add((PsiElement)psiGetter);
        psiTargetClass.add((PsiElement)psiSetter);
        psiMember[0] = field;
        return psiMethod;
    }

    private static PsiField createPropertyField(PsiClass psiTargetClass, String fixedName, String propertyName, String defaultType, boolean propertyAccessor) throws IncorrectOperationException {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiTargetClass.getProject()).getElementFactory();
        boolean shouldBeTransient = false;
        PsiField psiField = psiElementFactory.createFieldFromText("private " + defaultType + " " + fixedName + ";", (PsiElement)psiTargetClass);
        return (PsiField)psiTargetClass.add((PsiElement)psiField);
    }

    @NotNull
    public static String fixPropertyName(String text, PsiNameHelper psiNameHelper) {
        if (text.equalsIgnoreCase("class")) {
            if ("clazz" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ORMToAnnotationsConverter", "fixPropertyName"));
            }
            return "clazz";
        }
        if (psiNameHelper.isIdentifier(text, LanguageLevel.HIGHEST)) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ORMToAnnotationsConverter", "fixPropertyName"));
            }
            return string;
        }
        if (text.length() == 0) {
            if ("a" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ORMToAnnotationsConverter", "fixPropertyName"));
            }
            return "a";
        }
        StringBuilder sb = new StringBuilder();
        char ch = text.charAt(0);
        if (!Character.isJavaIdentifierStart(ch)) {
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            } else {
                sb.append('_');
            }
        } else {
            sb.append(ch);
        }
        for (int i = 1; i < text.length(); ++i) {
            ch = text.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) {
                sb.append('_');
                continue;
            }
            sb.append(ch);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ORMToAnnotationsConverter", "fixPropertyName"));
        }
        return string;
    }

    public static String fixFieldName(String fixedPropertyName, PsiManager psiManager) {
        String suggestedName;
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)psiManager.getProject()).suggestVariableName(VariableKind.FIELD, fixedPropertyName, null, null);
        String string = suggestedName = suggestedNameInfo.names.length == 0 ? fixedPropertyName : suggestedNameInfo.names[0];
        if (!PsiNameHelper.getInstance((Project)psiManager.getProject()).isIdentifier(suggestedName, LanguageLevel.HIGHEST)) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)suggestedName);
        }
        return suggestedName;
    }

    private static String getClassQName(String className, String packageName) {
        if (className == null) {
            return null;
        }
        if (className.indexOf(46) < 0 && packageName != null && packageName.length() > 0) {
            return packageName + "." + className;
        }
        return className;
    }

    @NonNls
    public static String getDefaultType(AttributeBase attr, List<EntityMappings> entityMappingsList) {
        if (attr.getDefaultTypeName() != null) {
            return attr.getDefaultTypeName();
        }
        if (attr instanceof com.intellij.javaee.model.xml.persistence.mapping.Id) {
            com.intellij.javaee.model.xml.persistence.mapping.Id id = (com.intellij.javaee.model.xml.persistence.mapping.Id)attr;
            if (id.getTemporal().getValue() != null) {
                return ORMToAnnotationsConverter.getTemporalDefaultType((Temporal)id.getTemporal().getValue());
            }
            return "java.lang.Long";
        }
        if (attr instanceof com.intellij.javaee.model.xml.persistence.mapping.EmbeddedId) {
            String name = (String)attr.getName().getValue();
            return name == null ? "java.lang.Object" : StringUtil.capitalize((String)name);
        }
        if (attr instanceof com.intellij.javaee.model.xml.persistence.mapping.Basic) {
            com.intellij.javaee.model.xml.persistence.mapping.Basic basic = (com.intellij.javaee.model.xml.persistence.mapping.Basic)attr;
            if (basic.getTemporal().getValue() != null) {
                return ORMToAnnotationsConverter.getTemporalDefaultType((Temporal)basic.getTemporal().getValue());
            }
            if (basic.getLob().getXmlTag() != null) {
                return "byte[]";
            }
            if (basic.getEnumerated().getXmlTag() != null) {
                return "java.lang.Enum";
            }
            return "java.lang.String";
        }
        if (attr instanceof com.intellij.javaee.model.xml.persistence.mapping.Embedded) {
            String name = (String)attr.getName().getValue();
            return name == null ? "java.lang.Object" : StringUtil.capitalize((String)name);
        }
        if (attr instanceof com.intellij.javaee.model.xml.persistence.mapping.Version) {
            com.intellij.javaee.model.xml.persistence.mapping.Version version = (com.intellij.javaee.model.xml.persistence.mapping.Version)attr;
            if (version.getTemporal().getValue() != null) {
                return ORMToAnnotationsConverter.getTemporalDefaultType((Temporal)version.getTemporal().getValue());
            }
            return "java.lang.Long";
        }
        if (attr instanceof ManyToMany) {
            ManyToMany manyToMany = (ManyToMany)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType((RelationAttributeBase)manyToMany, true, manyToMany.getMapKey(), entityMappingsList);
        }
        if (attr instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType((RelationAttributeBase)manyToOne, false, null, entityMappingsList);
        }
        if (attr instanceof OneToMany) {
            OneToMany oneToMany = (OneToMany)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType((RelationAttributeBase)oneToMany, true, oneToMany.getMapKey(), entityMappingsList);
        }
        if (attr instanceof OneToOne) {
            OneToOne oneToOne = (OneToOne)attr;
            return ORMToAnnotationsConverter.getDefaultCMRType((RelationAttributeBase)oneToOne, false, null, entityMappingsList);
        }
        if (attr instanceof com.intellij.javaee.model.xml.persistence.mapping.Transient) {
            return "java.lang.String";
        }
        return "java.lang.Integer";
    }

    private static String getTemporalDefaultType(Temporal value) {
        switch (value) {
            case DATE: {
                return "java.sql.Date";
            }
            case TIME: {
                return "java.sql.Time";
            }
            case TIMESTAMP: {
                return "java.sql.Timestamp";
            }
        }
        assert (false);
        return null;
    }

    @NonNls
    private static String getDefaultCMRType(RelationAttributeBase mapping, boolean toMany, MapKey mapKey, List<EntityMappings> entityMappingsList) {
        String className;
        String entityName = mapping.getTargetEntityClass().getStringValue();
        if (entityName == null) {
            return "java.lang.Object";
        }
        Entity targetEntity = null;
        block0: for (EntityMappings entityMappings : entityMappingsList) {
            for (Entity entity : entityMappings.getEntities()) {
                if (!entityName.equals(entity.getName().getValue())) continue;
                targetEntity = entity;
                break block0;
            }
        }
        String string = className = targetEntity == null ? entityName : targetEntity.getClazz().getStringValue();
        if (toMany) {
            if (mapKey.getXmlTag() != null) {
                return "java.util.Map<java.lang.Object, " + (className == null ? "?" : className) + ">";
            }
            return "java.util.Collection<" + (className == null ? "?" : className) + ">";
        }
        return className == null ? "java.lang.Object" : className;
    }

    @Override
    public void addAnnotation(PsiModifierListOwner psiMember, String text, PsiAnnotation annotation) throws IncorrectOperationException {
        if (text == null) {
            return;
        }
        PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)psiMember.getProject()).getElementFactory().createAnnotationFromText(text, null);
        if (annotation == null) {
            this.addUsageInfo(new AddUsageInfo((PsiElement)psiMember.getModifierList(), (PsiElement)psiAnnotation));
        } else {
            this.addUsageInfo(new ReplaceUsageInfo((PsiElement)annotation, (PsiElement)psiAnnotation));
        }
    }

    @Override
    public void removeAnnotation(PsiModifierListOwner owner, PsiAnnotation existingAnnotation) throws IncorrectOperationException {
        this.addUsageInfo(new DeleteUsageInfo((PsiElement)existingAnnotation));
    }

    @Override
    public PsiAnnotation findAnnotation(PsiModifierListOwner psiMember, String annotationName) {
        PsiModifierList list = psiMember.getModifierList();
        return this.findAddedAnnotation(list, list.findAnnotation(annotationName), annotationName);
    }

    @Override
    @NotNull
    public PsiElement getElement(PsiModifierListOwner owner) {
        PsiModifierListOwner psiModifierListOwner = owner;
        if (psiModifierListOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ORMToAnnotationsConverter", "getElement"));
        }
        return psiModifierListOwner;
    }

    private void createAnnotation(PsiModifierListOwner[] object, String annotationName, boolean merge, String ... arguments) throws IncorrectOperationException {
        assert (object.length == 2);
        this.createAnnotation(object[0], annotationName, merge, arguments);
        this.dropAnnotations(object[1], annotationName);
    }

    private void dropAnnotations(PsiModifierListOwner[] object, String ... annotationNames) {
        assert (object.length == 2);
        this.dropAnnotations(object[0], annotationNames);
        this.dropAnnotations(object[1], annotationNames);
    }

    private void dropAnnotations(PsiModifierListOwner object, String ... annotationNames) {
        if (object != null) {
            for (String annotationName : annotationNames) {
                PsiAnnotation psiAnnotation = object.getModifierList().findAnnotation(annotationName);
                if (psiAnnotation == null) continue;
                this.addUsageInfo(new DeleteUsageInfo((PsiElement)psiAnnotation));
            }
        }
    }

    private void createAnnotation(PsiModifierListOwner object, String annotationName, boolean merge, String ... arguments) throws IncorrectOperationException {
        PsiModifierList modifierList = object.getModifierList();
        PsiAnnotation annotation = this.findAddedAnnotation(modifierList, modifierList.findAnnotation(annotationName), annotationName);
        String text = AnnotationTextUtil.createAnnotationText((PsiElement)object, annotationName, merge, annotation, arguments);
        this.addAnnotation(object, text, annotation);
    }

    private static String toString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static boolean canModify(PsiElement psiElement) {
        return psiElement != null && CommonRefactoringUtil.checkReadOnlyStatus((Project)psiElement.getProject(), (PsiElement)psiElement);
    }

    @Nullable
    public static String getTargetEntityClassName(PsiMember psiMember) {
        PsiType type = PersistenceCommonUtil.getTargetEntityType((PsiMember)psiMember);
        return type == null ? null : type.getCanonicalText();
    }

    public static void ensureJpaApiLibraryExists(Module module) {
        PsiClass entityClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.persistence.Entity", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (entityClass == null) {
            JavaeeLibrariesUtil.addJavaeeLibrary(module, JavaeeVersion.JAVAEE_6);
        }
    }

    static class DeleteUsageInfo
    extends MyUsageInfo {
        public DeleteUsageInfo(PsiElement element) {
            super(element);
        }

        @Override
        public PsiElement processUsage() throws Exception {
            if (!ORMToAnnotationsConverter.canModify(this.getElement())) {
                return null;
            }
            this.getElement().delete();
            return null;
        }
    }

    static class ReplaceUsageInfo
    extends MyUsageInfo {
        PsiElement myNewElement;

        public ReplaceUsageInfo(PsiElement element, PsiElement newElement) {
            super(element);
            this.myNewElement = newElement;
        }

        @Override
        public PsiElement processUsage() throws Exception {
            if (!ORMToAnnotationsConverter.canModify(this.getElement())) {
                return null;
            }
            return this.getElement().replace(this.myNewElement);
        }
    }

    static class AddUsageInfo
    extends MyUsageInfo {
        List<PsiElement> list = new ArrayList<PsiElement>();

        public AddUsageInfo(PsiElement element, PsiElement newElement) {
            super(element);
            this.list.add(newElement);
        }

        @Override
        public PsiElement processUsage() throws Exception {
            if (!ORMToAnnotationsConverter.canModify(this.getElement())) {
                return null;
            }
            PsiElement anchor = null;
            for (PsiElement psiElement : this.list) {
                anchor = this.getElement().addAfter(psiElement, anchor);
            }
            return this.getElement();
        }
    }

    static abstract class MyUsageInfo
    extends UsageInfo {
        public MyUsageInfo(PsiElement element) {
            super(element);
        }

        @Nullable
        public abstract PsiElement processUsage() throws Exception;
    }
}

