/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration.converters;

import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.javaee.model.xml.GenericNamedValueConvertersRegistry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.model.converters.CustomConverterRegistry;
import com.intellij.spring.model.converters.PropertyKeyConverter;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.Props;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.persistence.integration.IntegrationUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernatePropertyNameConverter
extends ResolvingConverter<String>
implements CustomConverterRegistry.Provider {
    @NonNls
    private static final String HIBERNATE_PROPERTIES = "hibernateProperties";

    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        Map converters = GenericNamedValueConvertersRegistry.getRegistry().getConverters(Property.class);
        List<String> definedProperties = HibernatePropertyNameConverter.getDefinedPropertyKeys(context);
        Set allPropertyNames = converters.keySet();
        allPropertyNames.removeAll(definedProperties);
        Set set = allPropertyNames;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/persistence/integration/converters/HibernatePropertyNameConverter", "getVariants"));
        }
        return set;
    }

    public Converter getConverter() {
        return this;
    }

    public Class getConverterClass() {
        return PropertyKeyConverter.class;
    }

    private static List<String> getDefinedPropertyKeys(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        return HibernatePropertyNameConverter.getKeys(element);
    }

    public static List<String> getKeys(DomElement element) {
        ArrayList<String> keys = new ArrayList<String>();
        Props props = (Props)element.getParentOfType(Props.class, false);
        if (props != null) {
            for (Prop prop : props.getProps()) {
                String value = prop.getKey().getStringValue();
                if (!StringUtil.isNotEmpty((String)value)) continue;
                keys.add(value);
            }
        }
        return keys;
    }

    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    public boolean value(GenericDomValue domValue) {
        SpringProperty springProperty = (SpringProperty)domValue.getParentOfType(SpringProperty.class, false);
        if (springProperty != null && HIBERNATE_PROPERTIES.equals(springProperty.getName().getStringValue())) {
            SpringBean springBean = (SpringBean)springProperty.getParentOfType(SpringBean.class, false);
            return IntegrationUtil.isSessionFactoryBean(springBean, false, true);
        }
        return false;
    }
}

