/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.deploy.jmx;

import com.intellij.dmserver.deploy.DeploymentIdentity;
import com.intellij.dmserver.deploy.jmx.AbstractDMConnectorCommand;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.javaee.deployment.DeploymentModel;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;

public abstract class AbstractDeploymentModelCommand<T>
extends AbstractDMConnectorCommand<T> {
    private final DeploymentModel myDeploymentModel;

    public AbstractDeploymentModelCommand(DMServerInstance dmServer, DeploymentModel deploymentModel) {
        super(dmServer);
        this.myDeploymentModel = deploymentModel;
    }

    @Override
    protected T doExecute(MBeanServerConnection connection) throws JMException, IOException {
        DeploymentIdentity identity = this.getIdentity();
        if (identity == null) {
            return null;
        }
        return this.doDeploymentExecute(connection, identity);
    }

    protected DeploymentIdentity getIdentity() {
        return this.getServerInstance().findRegisteredDeployment(this.myDeploymentModel);
    }

    protected abstract T doDeploymentExecute(MBeanServerConnection var1, DeploymentIdentity var2) throws JMException, IOException;
}

