/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.dmserver.run.DMConfigurationFactory;
import com.intellij.dmserver.run.DMServerModel;
import com.intellij.dmserver.run.DMServerStartupPolicy;
import com.intellij.dmserver.run.remote.DMServerRemoteModel;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.run.configuration.J2EEConfigurationType;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.localRun.ExecutableObjectStartupPolicy;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.openapi.project.Project;
import icons.DmServerSupportIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DMServerRunConfigurationType
extends J2EEConfigurationType {
    private final DMConfigurationFactory myLocalFactory = new DMConfigurationFactory(this, DmServerBundle.message("DMServerRunConfigurationType.name.local", new Object[0]), true){

        @Override
        protected ServerModel createServerModel() {
            return new DMServerModel();
        }

        @Override
        protected ExecutableObjectStartupPolicy createStartupPolicy() {
            return new DMServerStartupPolicy();
        }
    };
    private final DMConfigurationFactory myRemoteFactory = new DMConfigurationFactory(this, DmServerBundle.message("RemoteConfigurationFactoryAccess.configuration.name.remote", new Object[0]), false){

        @Override
        protected ServerModel createServerModel() {
            return new DMServerRemoteModel();
        }

        @Override
        protected ExecutableObjectStartupPolicy createStartupPolicy() {
            return null;
        }
    };

    public static DMServerRunConfigurationType getInstance() {
        return (DMServerRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(DMServerRunConfigurationType.class);
    }

    public ConfigurationFactory getLocalFactory() {
        return this.myLocalFactory;
    }

    protected RunConfiguration createJ2EEConfigurationTemplate(ConfigurationFactory factory, Project project, boolean isLocal) {
        throw new UnsupportedOperationException("This method should not be called");
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        ArrayList<DMConfigurationFactory> result = new ArrayList<DMConfigurationFactory>();
        result.add(this.myLocalFactory);
        if (TransportManager.getInstance().hasServices()) {
            result.add(this.myRemoteFactory);
        }
        return result.toArray(new ConfigurationFactory[result.size()]);
    }

    public AppServerIntegration getIntegration() {
        return DMServerIntegration.getInstance();
    }

    @NotNull
    public String getId() {
        String string = DMServerRunConfigurationType.class.getName() + ":id";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/run/DMServerRunConfigurationType", "getId"));
        }
        return string;
    }

    public String getDisplayName() {
        return DmServerBundle.message("DMServerRunConfigurationType.display.name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return DmServerBundle.message("DMServerRunConfigurationType.description", new Object[0]);
    }

    public Icon getIcon() {
        return DmServerSupportIcons.DM;
    }
}

