/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.shell;

import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.dmserver.shell.DmShellToolWindowPanel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DmShellToolWindowFactory
implements ToolWindowFactory {
    private static final Logger LOG = Logger.getInstance((String)("#" + DmShellToolWindowFactory.class.getName()));

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/shell/DmShellToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/dmserver/shell/DmShellToolWindowFactory", "createToolWindowContent"));
        }
        toolWindow.setAvailable(false, null);
        toolWindow.hide(null);
    }

    public static void addServer(CommonModel model, ToolWindow toolWindow, DMServerInstance serverInstance) {
        DmShellToolWindowPanel component = new DmShellToolWindowPanel(model.getProject(), serverInstance);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)component), model.getApplicationServer().getName(), false);
        toolWindow.getContentManager().addContent(content);
        toolWindow.getContentManager().setSelectedContent(content);
        toolWindow.setAvailable(true, null);
    }

    public static void removeServer(ToolWindow toolWindow, DMServerInstance serverInstance) {
        Content serverContent = null;
        for (Content content : toolWindow.getContentManager().getContents()) {
            if (content.getComponent() instanceof DmShellToolWindowPanel) {
                if (((DmShellToolWindowPanel)((Object)content.getComponent())).getServerInstance() != serverInstance) continue;
                serverContent = content;
                break;
            }
            LOG.error("Alien component found looking for DmShellToolWindowPanel: " + content.getComponent() + "\n" + "Content : " + content);
        }
        if (serverContent == null) {
            return;
        }
        toolWindow.getContentManager().removeContent(serverContent, true);
        if (toolWindow.getContentManager().getContentCount() == 0) {
            toolWindow.setAvailable(false, null);
        }
    }
}

