/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MessageSend
extends Expression
implements InvocationSite {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    MethodBinding syntheticAccessor;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding valueCast;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean nonStatic = !this.binding.isStatic();
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo, nonStatic).unconditionalInits();
        if (nonStatic) {
            this.receiver.checkNullStatus(currentScope, flowContext, flowInfo, -1);
        }
        if (this.arguments != null) {
            int length = this.arguments.length;
            int i = 0;
            while (i < length) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != NoExceptions) {
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, flowInfo, currentScope);
        }
        this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        if (runtimeTimeType == null || compileTimeType == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            MethodBinding originalBinding = this.binding.original();
            if (originalBinding != this.binding && originalBinding.returnType != this.binding.returnType) {
                if ((originalBinding.returnType.tagBits & 0x20000000L) != 0L && runtimeTimeType.id != 1) {
                    TypeBinding targetType = !compileTimeType.isBaseType() && runtimeTimeType.isBaseType() ? compileTimeType : runtimeTimeType;
                    this.valueCast = originalBinding.returnType.genericCast(targetType);
                }
            } else if (this.actualReceiverType.isArrayType() && runtimeTimeType.id != 1 && this.binding.parameters == NoParameters && scope.compilerOptions().complianceLevel >= 0x310000L && CharOperation.equals(this.binding.selector, CLONE)) {
                this.valueCast = runtimeTimeType;
            }
        }
        super.computeConversion(scope, runtimeTimeType, compileTimeType);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        boolean isStatic = this.codegenBinding.isStatic();
        if (!isStatic && (this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] path = currentScope.getEmulationPath(targetType, true, false);
            codeStream.generateOuterAccess(path, this, targetType, currentScope);
        } else {
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        this.generateArguments(this.binding, this.arguments, currentScope, codeStream);
        if (this.syntheticAccessor == null) {
            if (isStatic) {
                codeStream.invokestatic(this.codegenBinding);
            } else if (this.receiver.isSuper() || this.codegenBinding.isPrivate()) {
                codeStream.invokespecial(this.codegenBinding);
            } else if (this.codegenBinding.declaringClass.isInterface()) {
                codeStream.invokeinterface(this.codegenBinding);
            } else {
                codeStream.invokevirtual(this.codegenBinding);
            }
        } else {
            codeStream.invokestatic(this.syntheticAccessor);
        }
        if (valueRequired) {
            if (this.valueCast != null) {
                codeStream.checkcast(this.valueCast);
            }
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            switch (this.binding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, (int)(this.nameSourcePosition >>> 32));
    }

    public TypeBinding generatedType(Scope scope) {
        TypeBinding convertedType = this.resolvedType;
        if (this.valueCast != null) {
            convertedType = this.valueCast;
        }
        int runtimeType = (this.implicitConversion & 0xFF) >> 4;
        switch (runtimeType) {
            case 5: {
                convertedType = BooleanBinding;
                break;
            }
            case 3: {
                convertedType = ByteBinding;
                break;
            }
            case 4: {
                convertedType = ShortBinding;
                break;
            }
            case 2: {
                convertedType = CharBinding;
                break;
            }
            case 10: {
                convertedType = IntBinding;
                break;
            }
            case 9: {
                convertedType = FloatBinding;
                break;
            }
            case 7: {
                convertedType = LongBinding;
                break;
            }
            case 8: {
                convertedType = DoubleBinding;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            convertedType = scope.environment().computeBoxingType(convertedType);
        }
        return convertedType;
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            if (currentScope.enclosingSourceType() != this.codegenBinding.declaringClass) {
                this.syntheticAccessor = ((SourceTypeBinding)this.codegenBinding.declaringClass).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding destinationType = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticAccessor = destinationType.addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding enclosingSourceType = currentScope.enclosingSourceType();
                if (this.codegenBinding.declaringClass.getPackage() != enclosingSourceType.getPackage()) {
                    SourceTypeBinding currentCompatibleType = (SourceTypeBinding)enclosingSourceType.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticAccessor = currentCompatibleType.addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                    currentScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                    return;
                }
            }
        }
        if (this.binding.declaringClass != this.actualReceiverType && !this.actualReceiverType.isArrayType()) {
            CompilerOptions options = currentScope.compilerOptions();
            if (!((options.targetJDK < 0x2E0000L || options.complianceLevel < 0x300000L && this.receiver.isImplicitThis() && this.codegenBinding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(currentScope))) {
                this.codegenBinding = currentScope.enclosingSourceType().getUpdatedMethodBinding(this.codegenBinding, (ReferenceBinding)this.actualReceiverType.erasure());
            }
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, output).append('.');
        }
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        output.append(this.selector).append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(')');
    }

    public TypeBinding resolveType(BlockScope scope) {
        boolean argHasError;
        boolean receiverIsType;
        this.constant = Constant.NotAConstant;
        boolean receiverCast = false;
        boolean argsContainCast = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            receiverCast = true;
        }
        this.actualReceiverType = this.receiver.resolveType(scope);
        boolean bl = receiverIsType = this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0;
        if (receiverCast && this.actualReceiverType != null && ((CastExpression)this.receiver).expression.resolvedType == this.actualReceiverType) {
            scope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            argHasError = false;
            this.genericTypeArguments = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                this.genericTypeArguments[i] = this.typeArguments[i].resolveType(scope, true);
                if (this.genericTypeArguments[i] == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                return null;
            }
        }
        TypeBinding[] argumentTypes = NoParameters;
        if (this.arguments != null) {
            argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                if (argument instanceof CastExpression) {
                    argument.bits |= 0x20;
                    argsContainCast = true;
                }
                if ((argumentTypes[i] = argument.resolveType(scope)) == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    TypeBinding[] pseudoArgs = new TypeBinding[length];
                    int i2 = length;
                    while (--i2 >= 0) {
                        TypeBinding typeBinding = pseudoArgs[i2] = argumentTypes[i2] == null ? this.actualReceiverType : argumentTypes[i2];
                    }
                    this.binding = scope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, pseudoArgs, this);
                }
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? scope.getImplicitMethod(this.selector, argumentTypes, this) : scope.getMethod(this.actualReceiverType, this.selector, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
                    return null;
                }
            }
            scope.problemReporter().invalidMethod(this, this.binding);
            MethodBinding closestMatch = ((ProblemMethodBinding)this.binding).closestMatch;
            switch (this.binding.problemId()) {
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (closestMatch == null) break;
                    this.resolvedType = closestMatch.returnType;
                }
            }
            if (closestMatch != null) {
                this.binding = closestMatch;
                if ((closestMatch.isPrivate() || closestMatch.declaringClass.isLocalType()) && !scope.isDefinedInMethod(closestMatch)) {
                    closestMatch.original().modifiers |= 0x8000000;
                }
            }
            return this.resolvedType;
        }
        if (!this.binding.isStatic()) {
            if (receiverIsType) {
                scope.problemReporter().mustUseAStaticMethod(this, this.binding);
                if (this.actualReceiverType.isRawType() && (this.receiver.bits & 0x40000000) == 0 && scope.compilerOptions().getSeverity(0x200000000000L) != -1) {
                    scope.problemReporter().rawTypeReference(this.receiver, this.actualReceiverType);
                }
            } else {
                ReferenceBinding match;
                TypeBinding receiverErasure = this.actualReceiverType.erasure();
                if (receiverErasure instanceof ReferenceBinding && (match = ((ReferenceBinding)receiverErasure).findSuperTypeWithSameErasure(this.binding.declaringClass)) == null) {
                    this.actualReceiverType = this.binding.declaringClass;
                }
                this.receiver.computeConversion(scope, this.actualReceiverType, this.actualReceiverType);
            }
        } else {
            if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || receiverIsType)) {
                scope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis() && this.binding.declaringClass != this.actualReceiverType) {
                scope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        }
        MessageSend.checkInvocationArguments(scope, this.receiver, this.actualReceiverType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            scope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.actualReceiverType.isArrayType() && this.binding.parameters == NoParameters && scope.compilerOptions().complianceLevel >= 0x310000L && CharOperation.equals(this.binding.selector, CLONE)) {
            this.resolvedType = this.actualReceiverType;
        } else {
            TypeBinding returnType = this.binding.returnType;
            if (returnType != null) {
                returnType = returnType.capture(scope, this.sourceEnd);
            }
            this.resolvedType = returnType;
        }
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
        if (receiverType == null) {
            return;
        }
        this.actualReceiverType = receiverType;
    }

    public void setExpectedType(TypeBinding expectedType) {
        this.expectedType = expectedType;
    }

    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int depth) {
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.receiver.traverse(visitor, blockScope);
            if (this.typeArguments != null) {
                int i = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i < typeArgumentsLength) {
                    this.typeArguments[i].traverse(visitor, blockScope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, blockScope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

