/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.NullMissingCase;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnNullableExhaustivenessChecker;", "", "()V", "getMissingCases", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "", "getNullCaseIfMissing", "frontend"})
final class WhenOnNullableExhaustivenessChecker {
    public static final WhenOnNullableExhaustivenessChecker INSTANCE;

    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @Nullable ClassDescriptor subjectDescriptor, boolean nullable2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return nullable2 ? this.getNullCaseIfMissing(expression2, context) : CollectionsKt.emptyList();
    }

    private final List<WhenMissingCase> getNullCaseIfMissing(KtWhenExpression expression2, BindingContext context) {
        for (KtWhenEntry entry : expression2.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
            for (int i = 0; i < ktWhenConditionArray.length; ++i) {
                Unit unit;
                KtWhenCondition condition2 = ktWhenConditionArray[i];
                if (!(condition2 instanceof KtWhenConditionWithExpression)) continue;
                if (((KtWhenConditionWithExpression)condition2).getExpression() != null) {
                    KtExpression ktExpression;
                    KtExpression it = ktExpression;
                    KotlinType type2 = context.getType(it);
                    if (type2 != null && KotlinBuiltIns.isNullableNothing(type2)) {
                        return CollectionsKt.emptyList();
                    }
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
        }
        return CollectionsKt.listOf((Object)NullMissingCase.INSTANCE);
    }

    private WhenOnNullableExhaustivenessChecker() {
        INSTANCE = this;
    }

    static {
        new WhenOnNullableExhaustivenessChecker();
    }
}

