/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u001a(\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u001a-\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u00012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u000fH\u0082\b\u001aT\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u001a\b\u0002\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u000f2\u001a\b\u0002\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u000f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001a"}, d2={"MAX_PORT_NUMBER", "", "getMAX_PORT_NUMBER", "()I", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "", "digest", "makeRunFilenameString", "timestamp", "port", "escapeSequence", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "walkDaemons", "Lkotlin/sequences/Sequence;", "registryDir", "Ljava/io/File;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "filter", "", "daemon-common"})
public final class ClientUtilsKt {
    private static final int MAX_PORT_NUMBER = 65535;

    public static final int getMAX_PORT_NUMBER() {
        return MAX_PORT_NUMBER;
    }

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        Intrinsics.checkParameterIsNotNull((Object)port, (String)"port");
        Intrinsics.checkParameterIsNotNull((Object)escapeSequence, (String)"escapeSequence");
        return DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + escapeSequence + "." + timestamp + escapeSequence + "." + digest + escapeSequence + "." + port + escapeSequence + ".run";
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String makeRunFilenameString$default(String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makeRunFilenameString");
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string, string2, string3, string4);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        Intrinsics.checkParameterIsNotNull((Object)digest, (String)"digest");
        String string = ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\");
        Regex regex = new Regex(string);
        return (Function1)new Function1<String, Integer>(regex){
            final /* synthetic */ Regex $regex;

            @Nullable
            public final Integer invoke(@NotNull String it) {
                Integer n;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Object object = Regex.find$default((Regex)this.$regex, (CharSequence)it, (int)0, (int)2, null);
                if (object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null) {
                    Object object2 = object;
                    n = Integer.parseInt((String)object2);
                } else {
                    n = null;
                }
                return n;
            }
            {
                this.$regex = regex;
                super(1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<CompileService> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull Function2<? super File, ? super Integer, Boolean> filter2, @NotNull Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)registryDir, (String)"registryDir");
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull(filter2, (String)"filter");
        Intrinsics.checkParameterIsNotNull(report2, (String)"report");
        Iterable iterable = compilerId.getCompilerClasspath();
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            void var14_10 = destination$iv$iv;
            String string2 = new File((String)it).getAbsolutePath();
            var14_10.add(string2);
        }
        String classPathDigest = DaemonParamsKt.toHexString(DaemonParamsKt.distinctStringsDigest((List)destination$iv$iv));
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)((Sequence)FilesKt.walk$default((File)registryDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(portExtractor){
            final /* synthetic */ Function1 $portExtractor;

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                return new Pair((Object)it, this.$portExtractor.invoke((Object)string));
            }
            {
                this.$portExtractor = function1;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, Boolean>(filter2){
            final /* synthetic */ Function2 $filter;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Pair<? extends File, Integer> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                if (it.getSecond() == null) return false;
                Object object = it.getFirst();
                Object object2 = it.getSecond();
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((Boolean)this.$filter.invoke(object, object2) == false) return false;
                return true;
            }
            {
                this.$filter = function2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends File, ? extends Integer>, CompileService>(report2){
            final /* synthetic */ Function2 $report;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final CompileService invoke(@NotNull Pair<? extends File, Integer> it) {
                block16: {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    v0 = it.getSecond();
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((Number)v0).intValue() <= 0) ** GOTO lbl-1000
                    v1 = it.getSecond();
                    if (v1 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (((Number)v1).intValue() < ClientUtilsKt.getMAX_PORT_NUMBER()) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    var2_2 = v2;
                    if (_Assertions.ENABLED) {
                        if (!var2_2) {
                            var3_4 = "Assertion failed";
                            throw (Throwable)new AssertionError((Object)var3_4);
                        }
                        v3 = Unit.INSTANCE;
                    } else {
                        v3 = Unit.INSTANCE;
                    }
                    this.$report.invoke((Object)DaemonReportCategory.DEBUG, (Object)("found daemon on port " + (Integer)it.getSecond() + ", trying to connect"));
                    v4 = it.getSecond();
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    var3_5 = ((Number)v4).intValue();
                    var4_6 = this.$report;
                    try {
                        v5 = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), (int)port$iv);
                        v6 = daemon$iv = v5 != null ? v5.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
                        if (daemon$iv != null) {
                            v7 = daemon$iv;
                            if (!(v7 instanceof CompileService)) {
                                v7 = null;
                            }
                            if ((v8 = (CompileService)v7) == null) {
                                throw (Throwable)new ClassCastException("Unable to cast compiler service, actual class received: " + daemon$iv.getClass());
                            }
                            break block16;
                        }
                        report$iv.invoke((Object)DaemonReportCategory.EXCEPTION, (Object)"daemon not found");
                    }
                    catch (ConnectException e$iv) {
                        v9 = new StringBuilder().append("cannot connect to registry: ");
                        v10 = e$iv.getCause();
                        if (v10 == null || (v10 = v10.getMessage()) == null) {
                            v10 = v11 = e$iv.getMessage();
                        }
                        if (v10 == null) {
                            v11 = "unknown exception";
                        }
                        report$iv.invoke((Object)DaemonReportCategory.EXCEPTION, (Object)v9.append(v11).toString());
                    }
                    v8 = daemon = (CompileService)null;
                }
                if (daemon == null && !((File)it.getFirst()).delete()) {
                    this.$report.invoke((Object)DaemonReportCategory.INFO, (Object)("WARNING: unable to delete seemingly orphaned file '" + ((File)it.getFirst()).getAbsolutePath() + "', cleanup recommended"));
                }
                return var2_3;
            }
            {
                this.$report = function2;
                super(1);
            }
        }));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Sequence walkDaemons$default(File file, CompilerId compilerId, Function2 function2, Function2 function22, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: walkDaemons");
        }
        if ((n & 4) != 0) {
            function2 = walkDaemons.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function22 = walkDaemons.2.INSTANCE;
        }
        return ClientUtilsKt.walkDaemons(file, compilerId, (Function2<? super File, ? super Integer, Boolean>)function2, (Function2<? super DaemonReportCategory, ? super String, Unit>)function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        try {
            Remote daemon;
            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port);
            Remote remote = daemon = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
            if (daemon != null) {
                Remote remote2 = daemon;
                if (!(remote2 instanceof CompileService)) {
                    remote2 = null;
                }
                CompileService compileService = (CompileService)remote2;
                if (compileService == null) {
                    throw (Throwable)new ClassCastException("Unable to cast compiler service, actual class received: " + daemon.getClass());
                }
                return compileService;
            }
            report2.invoke((Object)DaemonReportCategory.EXCEPTION, (Object)"daemon not found");
        }
        catch (ConnectException e) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
            Object object2 = e.getCause();
            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                object2 = object = e.getMessage();
            }
            if (object2 == null) {
                object = "unknown exception";
            }
            report2.invoke((Object)DaemonReportCategory.EXCEPTION, (Object)stringBuilder.append(object).toString());
        }
        return null;
    }

    static {
        MAX_PORT_NUMBER = 65535;
    }

    @Nullable
    public static final /* synthetic */ CompileService access$tryConnectToDaemon(int port, @NotNull Function2 report2) {
        return ClientUtilsKt.tryConnectToDaemon(port, (Function2<? super DaemonReportCategory, ? super String, Unit>)report2);
    }
}

